/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;


public class CardPayment {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("statementDescriptor")
    private Optional<String> statementDescriptor;

    @JsonCreator
    public CardPayment(
            @JsonProperty("statementDescriptor") Optional<String> statementDescriptor) {
        Utils.checkNotNull(statementDescriptor, "statementDescriptor");
        this.statementDescriptor = statementDescriptor;
    }
    
    public CardPayment() {
        this(Optional.empty());
    }

    @JsonIgnore
    public Optional<String> statementDescriptor() {
        return statementDescriptor;
    }

    public static Builder builder() {
        return new Builder();
    }


    public CardPayment withStatementDescriptor(String statementDescriptor) {
        Utils.checkNotNull(statementDescriptor, "statementDescriptor");
        this.statementDescriptor = Optional.ofNullable(statementDescriptor);
        return this;
    }


    public CardPayment withStatementDescriptor(Optional<String> statementDescriptor) {
        Utils.checkNotNull(statementDescriptor, "statementDescriptor");
        this.statementDescriptor = statementDescriptor;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CardPayment other = (CardPayment) o;
        return 
            Utils.enhancedDeepEquals(this.statementDescriptor, other.statementDescriptor);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            statementDescriptor);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CardPayment.class,
                "statementDescriptor", statementDescriptor);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<String> statementDescriptor = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        public Builder statementDescriptor(String statementDescriptor) {
            Utils.checkNotNull(statementDescriptor, "statementDescriptor");
            this.statementDescriptor = Optional.ofNullable(statementDescriptor);
            return this;
        }

        public Builder statementDescriptor(Optional<String> statementDescriptor) {
            Utils.checkNotNull(statementDescriptor, "statementDescriptor");
            this.statementDescriptor = statementDescriptor;
            return this;
        }

        public CardPayment build() {

            return new CardPayment(
                statementDescriptor);
        }

    }
}
