/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;

/**
 * CardAcquiringDispute
 * 
 * <p>Details of a card dispute.
 */
public class CardAcquiringDispute {

    @JsonProperty("disputeID")
    private String disputeID;


    @JsonProperty("createdOn")
    private OffsetDateTime createdOn;


    @JsonProperty("amount")
    private Amount amount;

    @JsonCreator
    public CardAcquiringDispute(
            @JsonProperty("disputeID") String disputeID,
            @JsonProperty("createdOn") OffsetDateTime createdOn,
            @JsonProperty("amount") Amount amount) {
        Utils.checkNotNull(disputeID, "disputeID");
        Utils.checkNotNull(createdOn, "createdOn");
        Utils.checkNotNull(amount, "amount");
        this.disputeID = disputeID;
        this.createdOn = createdOn;
        this.amount = amount;
    }

    @JsonIgnore
    public String disputeID() {
        return disputeID;
    }

    @JsonIgnore
    public OffsetDateTime createdOn() {
        return createdOn;
    }

    @JsonIgnore
    public Amount amount() {
        return amount;
    }

    public static Builder builder() {
        return new Builder();
    }


    public CardAcquiringDispute withDisputeID(String disputeID) {
        Utils.checkNotNull(disputeID, "disputeID");
        this.disputeID = disputeID;
        return this;
    }

    public CardAcquiringDispute withCreatedOn(OffsetDateTime createdOn) {
        Utils.checkNotNull(createdOn, "createdOn");
        this.createdOn = createdOn;
        return this;
    }

    public CardAcquiringDispute withAmount(Amount amount) {
        Utils.checkNotNull(amount, "amount");
        this.amount = amount;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CardAcquiringDispute other = (CardAcquiringDispute) o;
        return 
            Utils.enhancedDeepEquals(this.disputeID, other.disputeID) &&
            Utils.enhancedDeepEquals(this.createdOn, other.createdOn) &&
            Utils.enhancedDeepEquals(this.amount, other.amount);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            disputeID, createdOn, amount);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CardAcquiringDispute.class,
                "disputeID", disputeID,
                "createdOn", createdOn,
                "amount", amount);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String disputeID;

        private OffsetDateTime createdOn;

        private Amount amount;

        private Builder() {
          // force use of static builder() method
        }


        public Builder disputeID(String disputeID) {
            Utils.checkNotNull(disputeID, "disputeID");
            this.disputeID = disputeID;
            return this;
        }


        public Builder createdOn(OffsetDateTime createdOn) {
            Utils.checkNotNull(createdOn, "createdOn");
            this.createdOn = createdOn;
            return this;
        }


        public Builder amount(Amount amount) {
            Utils.checkNotNull(amount, "amount");
            this.amount = amount;
            return this;
        }

        public CardAcquiringDispute build() {

            return new CardAcquiringDispute(
                disputeID, createdOn, amount);
        }

    }
}
