/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;

/**
 * CardAcceptanceMethods
 * 
 * <p>Describes the distribution of card transactions by payment method.
 */
public class CardAcceptanceMethods {
    /**
     * Percentage of card transactions that are in-person payments. Minimum value is 0, maximum is 100.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("inPersonPercentage")
    private Optional<Integer> inPersonPercentage;

    /**
     * Percentage of card transactions that are mail or phone payments. Minimum value is 0, maximum is 100.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("mailOrPhonePercentage")
    private Optional<Integer> mailOrPhonePercentage;

    /**
     * Percentage of card transactions that are online payments. Minimum value is 0, maximum is 100.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("onlinePercentage")
    private Optional<Integer> onlinePercentage;

    @JsonCreator
    public CardAcceptanceMethods(
            @JsonProperty("inPersonPercentage") Optional<Integer> inPersonPercentage,
            @JsonProperty("mailOrPhonePercentage") Optional<Integer> mailOrPhonePercentage,
            @JsonProperty("onlinePercentage") Optional<Integer> onlinePercentage) {
        Utils.checkNotNull(inPersonPercentage, "inPersonPercentage");
        Utils.checkNotNull(mailOrPhonePercentage, "mailOrPhonePercentage");
        Utils.checkNotNull(onlinePercentage, "onlinePercentage");
        this.inPersonPercentage = inPersonPercentage;
        this.mailOrPhonePercentage = mailOrPhonePercentage;
        this.onlinePercentage = onlinePercentage;
    }
    
    public CardAcceptanceMethods() {
        this(Optional.empty(), Optional.empty(), Optional.empty());
    }

    /**
     * Percentage of card transactions that are in-person payments. Minimum value is 0, maximum is 100.
     */
    @JsonIgnore
    public Optional<Integer> inPersonPercentage() {
        return inPersonPercentage;
    }

    /**
     * Percentage of card transactions that are mail or phone payments. Minimum value is 0, maximum is 100.
     */
    @JsonIgnore
    public Optional<Integer> mailOrPhonePercentage() {
        return mailOrPhonePercentage;
    }

    /**
     * Percentage of card transactions that are online payments. Minimum value is 0, maximum is 100.
     */
    @JsonIgnore
    public Optional<Integer> onlinePercentage() {
        return onlinePercentage;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Percentage of card transactions that are in-person payments. Minimum value is 0, maximum is 100.
     */
    public CardAcceptanceMethods withInPersonPercentage(int inPersonPercentage) {
        Utils.checkNotNull(inPersonPercentage, "inPersonPercentage");
        this.inPersonPercentage = Optional.ofNullable(inPersonPercentage);
        return this;
    }


    /**
     * Percentage of card transactions that are in-person payments. Minimum value is 0, maximum is 100.
     */
    public CardAcceptanceMethods withInPersonPercentage(Optional<Integer> inPersonPercentage) {
        Utils.checkNotNull(inPersonPercentage, "inPersonPercentage");
        this.inPersonPercentage = inPersonPercentage;
        return this;
    }

    /**
     * Percentage of card transactions that are mail or phone payments. Minimum value is 0, maximum is 100.
     */
    public CardAcceptanceMethods withMailOrPhonePercentage(int mailOrPhonePercentage) {
        Utils.checkNotNull(mailOrPhonePercentage, "mailOrPhonePercentage");
        this.mailOrPhonePercentage = Optional.ofNullable(mailOrPhonePercentage);
        return this;
    }


    /**
     * Percentage of card transactions that are mail or phone payments. Minimum value is 0, maximum is 100.
     */
    public CardAcceptanceMethods withMailOrPhonePercentage(Optional<Integer> mailOrPhonePercentage) {
        Utils.checkNotNull(mailOrPhonePercentage, "mailOrPhonePercentage");
        this.mailOrPhonePercentage = mailOrPhonePercentage;
        return this;
    }

    /**
     * Percentage of card transactions that are online payments. Minimum value is 0, maximum is 100.
     */
    public CardAcceptanceMethods withOnlinePercentage(int onlinePercentage) {
        Utils.checkNotNull(onlinePercentage, "onlinePercentage");
        this.onlinePercentage = Optional.ofNullable(onlinePercentage);
        return this;
    }


    /**
     * Percentage of card transactions that are online payments. Minimum value is 0, maximum is 100.
     */
    public CardAcceptanceMethods withOnlinePercentage(Optional<Integer> onlinePercentage) {
        Utils.checkNotNull(onlinePercentage, "onlinePercentage");
        this.onlinePercentage = onlinePercentage;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CardAcceptanceMethods other = (CardAcceptanceMethods) o;
        return 
            Utils.enhancedDeepEquals(this.inPersonPercentage, other.inPersonPercentage) &&
            Utils.enhancedDeepEquals(this.mailOrPhonePercentage, other.mailOrPhonePercentage) &&
            Utils.enhancedDeepEquals(this.onlinePercentage, other.onlinePercentage);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            inPersonPercentage, mailOrPhonePercentage, onlinePercentage);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CardAcceptanceMethods.class,
                "inPersonPercentage", inPersonPercentage,
                "mailOrPhonePercentage", mailOrPhonePercentage,
                "onlinePercentage", onlinePercentage);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<Integer> inPersonPercentage = Optional.empty();

        private Optional<Integer> mailOrPhonePercentage = Optional.empty();

        private Optional<Integer> onlinePercentage = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Percentage of card transactions that are in-person payments. Minimum value is 0, maximum is 100.
         */
        public Builder inPersonPercentage(int inPersonPercentage) {
            Utils.checkNotNull(inPersonPercentage, "inPersonPercentage");
            this.inPersonPercentage = Optional.ofNullable(inPersonPercentage);
            return this;
        }

        /**
         * Percentage of card transactions that are in-person payments. Minimum value is 0, maximum is 100.
         */
        public Builder inPersonPercentage(Optional<Integer> inPersonPercentage) {
            Utils.checkNotNull(inPersonPercentage, "inPersonPercentage");
            this.inPersonPercentage = inPersonPercentage;
            return this;
        }


        /**
         * Percentage of card transactions that are mail or phone payments. Minimum value is 0, maximum is 100.
         */
        public Builder mailOrPhonePercentage(int mailOrPhonePercentage) {
            Utils.checkNotNull(mailOrPhonePercentage, "mailOrPhonePercentage");
            this.mailOrPhonePercentage = Optional.ofNullable(mailOrPhonePercentage);
            return this;
        }

        /**
         * Percentage of card transactions that are mail or phone payments. Minimum value is 0, maximum is 100.
         */
        public Builder mailOrPhonePercentage(Optional<Integer> mailOrPhonePercentage) {
            Utils.checkNotNull(mailOrPhonePercentage, "mailOrPhonePercentage");
            this.mailOrPhonePercentage = mailOrPhonePercentage;
            return this;
        }


        /**
         * Percentage of card transactions that are online payments. Minimum value is 0, maximum is 100.
         */
        public Builder onlinePercentage(int onlinePercentage) {
            Utils.checkNotNull(onlinePercentage, "onlinePercentage");
            this.onlinePercentage = Optional.ofNullable(onlinePercentage);
            return this;
        }

        /**
         * Percentage of card transactions that are online payments. Minimum value is 0, maximum is 100.
         */
        public Builder onlinePercentage(Optional<Integer> onlinePercentage) {
            Utils.checkNotNull(onlinePercentage, "onlinePercentage");
            this.onlinePercentage = onlinePercentage;
            return this;
        }

        public CardAcceptanceMethods build() {

            return new CardAcceptanceMethods(
                inPersonPercentage, mailOrPhonePercentage, onlinePercentage);
        }

    }
}
