/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;

/**
 * CapabilityID
 * 
 * <p>Moov account capabilities.
 * 
 * <p>The `production-app`, `platform.production-app`, and / or `platform.wallet-transfers` capabilities might appear in your list. These are read-only capabilities that Moov requests and uses for account verification purposes. These capabilities remains active with your account and require no additional action.
 */
public enum CapabilityID {
    TRANSFERS("transfers"),
    SEND_FUNDS("send-funds"),
    SEND_FUNDS_PUSH_TO_CARD("send-funds.push-to-card"),
    MONEY_TRANSFER_PUSH_TO_CARD("money-transfer.push-to-card"),
    SEND_FUNDS_ACH("send-funds.ach"),
    SEND_FUNDS_RTP("send-funds.rtp"),
    COLLECT_FUNDS("collect-funds"),
    COLLECT_FUNDS_CARD_PAYMENTS("collect-funds.card-payments"),
    MONEY_TRANSFER_PULL_FROM_CARD("money-transfer.pull-from-card"),
    COLLECT_FUNDS_ACH("collect-funds.ach"),
    WALLET("wallet"),
    WALLET_BALANCE("wallet.balance"),
    CARD_ISSUING("card-issuing"),
    PRODUCTION_APP("production-app"),
    PLATFORM_PRODUCTION_APP("platform.production-app"),
    PLATFORM_WALLET_TRANSFERS("platform.wallet-transfers");

    @JsonValue
    private final String value;

    CapabilityID(String value) {
        this.value = value;
    }
    
    public String value() {
        return value;
    }
    
    public static Optional<CapabilityID> fromValue(String value) {
        for (CapabilityID o: CapabilityID.values()) {
            if (Objects.deepEquals(o.value, value)) {
                return Optional.of(o);
            }
        }
        return Optional.empty();
    }
}

