/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class BrandProperties {
    /**
     * Brand colors for light and dark modes.
     */
    @JsonProperty("colors")
    private BrandColors colors;

    @JsonCreator
    public BrandProperties(
            @JsonProperty("colors") BrandColors colors) {
        Utils.checkNotNull(colors, "colors");
        this.colors = colors;
    }

    /**
     * Brand colors for light and dark modes.
     */
    @JsonIgnore
    public BrandColors colors() {
        return colors;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Brand colors for light and dark modes.
     */
    public BrandProperties withColors(BrandColors colors) {
        Utils.checkNotNull(colors, "colors");
        this.colors = colors;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BrandProperties other = (BrandProperties) o;
        return 
            Utils.enhancedDeepEquals(this.colors, other.colors);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            colors);
    }
    
    @Override
    public String toString() {
        return Utils.toString(BrandProperties.class,
                "colors", colors);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private BrandColors colors;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Brand colors for light and dark modes.
         */
        public Builder colors(BrandColors colors) {
            Utils.checkNotNull(colors, "colors");
            this.colors = colors;
            return this;
        }

        public BrandProperties build() {

            return new BrandProperties(
                colors);
        }

    }
}
