/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class ApplePayPaymentMethod implements PaymentMethod {
    /**
     * ID of the payment method.
     */
    @JsonProperty("paymentMethodID")
    private String paymentMethodID;


    @JsonProperty("paymentMethodType")
    private ApplePayPaymentMethodPaymentMethodType paymentMethodType;

    /**
     * Describes an Apple Pay token on a Moov account.
     */
    @JsonProperty("applePay")
    private ApplePayResponse applePay;

    @JsonCreator
    public ApplePayPaymentMethod(
            @JsonProperty("paymentMethodID") String paymentMethodID,
            @JsonProperty("paymentMethodType") ApplePayPaymentMethodPaymentMethodType paymentMethodType,
            @JsonProperty("applePay") ApplePayResponse applePay) {
        Utils.checkNotNull(paymentMethodID, "paymentMethodID");
        Utils.checkNotNull(paymentMethodType, "paymentMethodType");
        Utils.checkNotNull(applePay, "applePay");
        this.paymentMethodID = paymentMethodID;
        this.paymentMethodType = paymentMethodType;
        this.applePay = applePay;
    }

    /**
     * ID of the payment method.
     */
    @JsonIgnore
    public String paymentMethodID() {
        return paymentMethodID;
    }

    @JsonIgnore
    @Override
    public String paymentMethodType() {
        return Utils.discriminatorToString(paymentMethodType);
    }

    /**
     * Describes an Apple Pay token on a Moov account.
     */
    @JsonIgnore
    public ApplePayResponse applePay() {
        return applePay;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * ID of the payment method.
     */
    public ApplePayPaymentMethod withPaymentMethodID(String paymentMethodID) {
        Utils.checkNotNull(paymentMethodID, "paymentMethodID");
        this.paymentMethodID = paymentMethodID;
        return this;
    }

    public ApplePayPaymentMethod withPaymentMethodType(ApplePayPaymentMethodPaymentMethodType paymentMethodType) {
        Utils.checkNotNull(paymentMethodType, "paymentMethodType");
        this.paymentMethodType = paymentMethodType;
        return this;
    }

    /**
     * Describes an Apple Pay token on a Moov account.
     */
    public ApplePayPaymentMethod withApplePay(ApplePayResponse applePay) {
        Utils.checkNotNull(applePay, "applePay");
        this.applePay = applePay;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ApplePayPaymentMethod other = (ApplePayPaymentMethod) o;
        return 
            Utils.enhancedDeepEquals(this.paymentMethodID, other.paymentMethodID) &&
            Utils.enhancedDeepEquals(this.paymentMethodType, other.paymentMethodType) &&
            Utils.enhancedDeepEquals(this.applePay, other.applePay);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            paymentMethodID, paymentMethodType, applePay);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ApplePayPaymentMethod.class,
                "paymentMethodID", paymentMethodID,
                "paymentMethodType", paymentMethodType,
                "applePay", applePay);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String paymentMethodID;

        private ApplePayPaymentMethodPaymentMethodType paymentMethodType;

        private ApplePayResponse applePay;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * ID of the payment method.
         */
        public Builder paymentMethodID(String paymentMethodID) {
            Utils.checkNotNull(paymentMethodID, "paymentMethodID");
            this.paymentMethodID = paymentMethodID;
            return this;
        }


        public Builder paymentMethodType(ApplePayPaymentMethodPaymentMethodType paymentMethodType) {
            Utils.checkNotNull(paymentMethodType, "paymentMethodType");
            this.paymentMethodType = paymentMethodType;
            return this;
        }


        /**
         * Describes an Apple Pay token on a Moov account.
         */
        public Builder applePay(ApplePayResponse applePay) {
            Utils.checkNotNull(applePay, "applePay");
            this.applePay = applePay;
            return this;
        }

        public ApplePayPaymentMethod build() {

            return new ApplePayPaymentMethod(
                paymentMethodID, paymentMethodType, applePay);
        }

    }
}
