/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.List;


public class ApplePayMerchantDomains {

    @JsonProperty("accountID")
    private String accountID;

    /**
     * A UTF-8 string to display in the Buy button.
     */
    @JsonProperty("displayName")
    private String displayName;

    /**
     * A unique list of fully-qualified, top-level or sub-domain names where you will accept Apple Pay.
     */
    @JsonProperty("domains")
    private List<String> domains;


    @JsonProperty("createdOn")
    private OffsetDateTime createdOn;


    @JsonProperty("updatedOn")
    private OffsetDateTime updatedOn;

    @JsonCreator
    public ApplePayMerchantDomains(
            @JsonProperty("accountID") String accountID,
            @JsonProperty("displayName") String displayName,
            @JsonProperty("domains") List<String> domains,
            @JsonProperty("createdOn") OffsetDateTime createdOn,
            @JsonProperty("updatedOn") OffsetDateTime updatedOn) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(displayName, "displayName");
        Utils.checkNotNull(domains, "domains");
        Utils.checkNotNull(createdOn, "createdOn");
        Utils.checkNotNull(updatedOn, "updatedOn");
        this.accountID = accountID;
        this.displayName = displayName;
        this.domains = domains;
        this.createdOn = createdOn;
        this.updatedOn = updatedOn;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    /**
     * A UTF-8 string to display in the Buy button.
     */
    @JsonIgnore
    public String displayName() {
        return displayName;
    }

    /**
     * A unique list of fully-qualified, top-level or sub-domain names where you will accept Apple Pay.
     */
    @JsonIgnore
    public List<String> domains() {
        return domains;
    }

    @JsonIgnore
    public OffsetDateTime createdOn() {
        return createdOn;
    }

    @JsonIgnore
    public OffsetDateTime updatedOn() {
        return updatedOn;
    }

    public static Builder builder() {
        return new Builder();
    }


    public ApplePayMerchantDomains withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    /**
     * A UTF-8 string to display in the Buy button.
     */
    public ApplePayMerchantDomains withDisplayName(String displayName) {
        Utils.checkNotNull(displayName, "displayName");
        this.displayName = displayName;
        return this;
    }

    /**
     * A unique list of fully-qualified, top-level or sub-domain names where you will accept Apple Pay.
     */
    public ApplePayMerchantDomains withDomains(List<String> domains) {
        Utils.checkNotNull(domains, "domains");
        this.domains = domains;
        return this;
    }

    public ApplePayMerchantDomains withCreatedOn(OffsetDateTime createdOn) {
        Utils.checkNotNull(createdOn, "createdOn");
        this.createdOn = createdOn;
        return this;
    }

    public ApplePayMerchantDomains withUpdatedOn(OffsetDateTime updatedOn) {
        Utils.checkNotNull(updatedOn, "updatedOn");
        this.updatedOn = updatedOn;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ApplePayMerchantDomains other = (ApplePayMerchantDomains) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.displayName, other.displayName) &&
            Utils.enhancedDeepEquals(this.domains, other.domains) &&
            Utils.enhancedDeepEquals(this.createdOn, other.createdOn) &&
            Utils.enhancedDeepEquals(this.updatedOn, other.updatedOn);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, displayName, domains,
            createdOn, updatedOn);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ApplePayMerchantDomains.class,
                "accountID", accountID,
                "displayName", displayName,
                "domains", domains,
                "createdOn", createdOn,
                "updatedOn", updatedOn);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private String displayName;

        private List<String> domains;

        private OffsetDateTime createdOn;

        private OffsetDateTime updatedOn;

        private Builder() {
          // force use of static builder() method
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        /**
         * A UTF-8 string to display in the Buy button.
         */
        public Builder displayName(String displayName) {
            Utils.checkNotNull(displayName, "displayName");
            this.displayName = displayName;
            return this;
        }


        /**
         * A unique list of fully-qualified, top-level or sub-domain names where you will accept Apple Pay.
         */
        public Builder domains(List<String> domains) {
            Utils.checkNotNull(domains, "domains");
            this.domains = domains;
            return this;
        }


        public Builder createdOn(OffsetDateTime createdOn) {
            Utils.checkNotNull(createdOn, "createdOn");
            this.createdOn = createdOn;
            return this;
        }


        public Builder updatedOn(OffsetDateTime updatedOn) {
            Utils.checkNotNull(updatedOn, "updatedOn");
            this.updatedOn = updatedOn;
            return this;
        }

        public ApplePayMerchantDomains build() {

            return new ApplePayMerchantDomains(
                accountID, displayName, domains,
                createdOn, updatedOn);
        }

    }
}
