/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.List;
import java.util.Optional;

/**
 * AppleBillingContact
 * 
 * <p>Billing contact information as returned from Apple Pay.
 * 
 * <p>  Refer to [Apple's documentation](https://developer.apple.com/documentation/apple_pay_on_the_web/applepaypaymentcontact) 
 *   for more information.
 */
public class AppleBillingContact {
    /**
     * Address lines 1 and 2 for the contact.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("addressLines")
    private Optional<? extends List<String>> addressLines;

    /**
     * The contact's city.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("locality")
    private Optional<String> locality;

    /**
     * The contact's postal code.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("postalCode")
    private Optional<String> postalCode;

    /**
     * The contact's two-letter state code.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("administrativeArea")
    private Optional<String> administrativeArea;

    /**
     * The contact's two-letter ISO 3166
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("countryCode")
    private Optional<String> countryCode;

    @JsonCreator
    public AppleBillingContact(
            @JsonProperty("addressLines") Optional<? extends List<String>> addressLines,
            @JsonProperty("locality") Optional<String> locality,
            @JsonProperty("postalCode") Optional<String> postalCode,
            @JsonProperty("administrativeArea") Optional<String> administrativeArea,
            @JsonProperty("countryCode") Optional<String> countryCode) {
        Utils.checkNotNull(addressLines, "addressLines");
        Utils.checkNotNull(locality, "locality");
        Utils.checkNotNull(postalCode, "postalCode");
        Utils.checkNotNull(administrativeArea, "administrativeArea");
        Utils.checkNotNull(countryCode, "countryCode");
        this.addressLines = addressLines;
        this.locality = locality;
        this.postalCode = postalCode;
        this.administrativeArea = administrativeArea;
        this.countryCode = countryCode;
    }
    
    public AppleBillingContact() {
        this(Optional.empty(), Optional.empty(), Optional.empty(),
            Optional.empty(), Optional.empty());
    }

    /**
     * Address lines 1 and 2 for the contact.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<List<String>> addressLines() {
        return (Optional<List<String>>) addressLines;
    }

    /**
     * The contact's city.
     */
    @JsonIgnore
    public Optional<String> locality() {
        return locality;
    }

    /**
     * The contact's postal code.
     */
    @JsonIgnore
    public Optional<String> postalCode() {
        return postalCode;
    }

    /**
     * The contact's two-letter state code.
     */
    @JsonIgnore
    public Optional<String> administrativeArea() {
        return administrativeArea;
    }

    /**
     * The contact's two-letter ISO 3166
     */
    @JsonIgnore
    public Optional<String> countryCode() {
        return countryCode;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Address lines 1 and 2 for the contact.
     */
    public AppleBillingContact withAddressLines(List<String> addressLines) {
        Utils.checkNotNull(addressLines, "addressLines");
        this.addressLines = Optional.ofNullable(addressLines);
        return this;
    }


    /**
     * Address lines 1 and 2 for the contact.
     */
    public AppleBillingContact withAddressLines(Optional<? extends List<String>> addressLines) {
        Utils.checkNotNull(addressLines, "addressLines");
        this.addressLines = addressLines;
        return this;
    }

    /**
     * The contact's city.
     */
    public AppleBillingContact withLocality(String locality) {
        Utils.checkNotNull(locality, "locality");
        this.locality = Optional.ofNullable(locality);
        return this;
    }


    /**
     * The contact's city.
     */
    public AppleBillingContact withLocality(Optional<String> locality) {
        Utils.checkNotNull(locality, "locality");
        this.locality = locality;
        return this;
    }

    /**
     * The contact's postal code.
     */
    public AppleBillingContact withPostalCode(String postalCode) {
        Utils.checkNotNull(postalCode, "postalCode");
        this.postalCode = Optional.ofNullable(postalCode);
        return this;
    }


    /**
     * The contact's postal code.
     */
    public AppleBillingContact withPostalCode(Optional<String> postalCode) {
        Utils.checkNotNull(postalCode, "postalCode");
        this.postalCode = postalCode;
        return this;
    }

    /**
     * The contact's two-letter state code.
     */
    public AppleBillingContact withAdministrativeArea(String administrativeArea) {
        Utils.checkNotNull(administrativeArea, "administrativeArea");
        this.administrativeArea = Optional.ofNullable(administrativeArea);
        return this;
    }


    /**
     * The contact's two-letter state code.
     */
    public AppleBillingContact withAdministrativeArea(Optional<String> administrativeArea) {
        Utils.checkNotNull(administrativeArea, "administrativeArea");
        this.administrativeArea = administrativeArea;
        return this;
    }

    /**
     * The contact's two-letter ISO 3166
     */
    public AppleBillingContact withCountryCode(String countryCode) {
        Utils.checkNotNull(countryCode, "countryCode");
        this.countryCode = Optional.ofNullable(countryCode);
        return this;
    }


    /**
     * The contact's two-letter ISO 3166
     */
    public AppleBillingContact withCountryCode(Optional<String> countryCode) {
        Utils.checkNotNull(countryCode, "countryCode");
        this.countryCode = countryCode;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AppleBillingContact other = (AppleBillingContact) o;
        return 
            Utils.enhancedDeepEquals(this.addressLines, other.addressLines) &&
            Utils.enhancedDeepEquals(this.locality, other.locality) &&
            Utils.enhancedDeepEquals(this.postalCode, other.postalCode) &&
            Utils.enhancedDeepEquals(this.administrativeArea, other.administrativeArea) &&
            Utils.enhancedDeepEquals(this.countryCode, other.countryCode);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            addressLines, locality, postalCode,
            administrativeArea, countryCode);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AppleBillingContact.class,
                "addressLines", addressLines,
                "locality", locality,
                "postalCode", postalCode,
                "administrativeArea", administrativeArea,
                "countryCode", countryCode);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<? extends List<String>> addressLines = Optional.empty();

        private Optional<String> locality = Optional.empty();

        private Optional<String> postalCode = Optional.empty();

        private Optional<String> administrativeArea = Optional.empty();

        private Optional<String> countryCode = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Address lines 1 and 2 for the contact.
         */
        public Builder addressLines(List<String> addressLines) {
            Utils.checkNotNull(addressLines, "addressLines");
            this.addressLines = Optional.ofNullable(addressLines);
            return this;
        }

        /**
         * Address lines 1 and 2 for the contact.
         */
        public Builder addressLines(Optional<? extends List<String>> addressLines) {
            Utils.checkNotNull(addressLines, "addressLines");
            this.addressLines = addressLines;
            return this;
        }


        /**
         * The contact's city.
         */
        public Builder locality(String locality) {
            Utils.checkNotNull(locality, "locality");
            this.locality = Optional.ofNullable(locality);
            return this;
        }

        /**
         * The contact's city.
         */
        public Builder locality(Optional<String> locality) {
            Utils.checkNotNull(locality, "locality");
            this.locality = locality;
            return this;
        }


        /**
         * The contact's postal code.
         */
        public Builder postalCode(String postalCode) {
            Utils.checkNotNull(postalCode, "postalCode");
            this.postalCode = Optional.ofNullable(postalCode);
            return this;
        }

        /**
         * The contact's postal code.
         */
        public Builder postalCode(Optional<String> postalCode) {
            Utils.checkNotNull(postalCode, "postalCode");
            this.postalCode = postalCode;
            return this;
        }


        /**
         * The contact's two-letter state code.
         */
        public Builder administrativeArea(String administrativeArea) {
            Utils.checkNotNull(administrativeArea, "administrativeArea");
            this.administrativeArea = Optional.ofNullable(administrativeArea);
            return this;
        }

        /**
         * The contact's two-letter state code.
         */
        public Builder administrativeArea(Optional<String> administrativeArea) {
            Utils.checkNotNull(administrativeArea, "administrativeArea");
            this.administrativeArea = administrativeArea;
            return this;
        }


        /**
         * The contact's two-letter ISO 3166
         */
        public Builder countryCode(String countryCode) {
            Utils.checkNotNull(countryCode, "countryCode");
            this.countryCode = Optional.ofNullable(countryCode);
            return this;
        }

        /**
         * The contact's two-letter ISO 3166
         */
        public Builder countryCode(Optional<String> countryCode) {
            Utils.checkNotNull(countryCode, "countryCode");
            this.countryCode = countryCode;
            return this;
        }

        public AppleBillingContact build() {

            return new AppleBillingContact(
                addressLines, locality, postalCode,
                administrativeArea, countryCode);
        }

    }
}
