/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;


public class AmountUpdate {
    /**
     * A 3-letter ISO 4217 currency code.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("currency")
    private Optional<String> currency;

    /**
     * Quantity in the smallest unit of the specified currency. 
     * 
     * <p>In USD this is cents, for example, $12.04 is 1204 and $0.99 is 99.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private Optional<Long> value;

    @JsonCreator
    public AmountUpdate(
            @JsonProperty("currency") Optional<String> currency,
            @JsonProperty("value") Optional<Long> value) {
        Utils.checkNotNull(currency, "currency");
        Utils.checkNotNull(value, "value");
        this.currency = currency;
        this.value = value;
    }
    
    public AmountUpdate() {
        this(Optional.empty(), Optional.empty());
    }

    /**
     * A 3-letter ISO 4217 currency code.
     */
    @JsonIgnore
    public Optional<String> currency() {
        return currency;
    }

    /**
     * Quantity in the smallest unit of the specified currency. 
     * 
     * <p>In USD this is cents, for example, $12.04 is 1204 and $0.99 is 99.
     */
    @JsonIgnore
    public Optional<Long> value() {
        return value;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * A 3-letter ISO 4217 currency code.
     */
    public AmountUpdate withCurrency(String currency) {
        Utils.checkNotNull(currency, "currency");
        this.currency = Optional.ofNullable(currency);
        return this;
    }


    /**
     * A 3-letter ISO 4217 currency code.
     */
    public AmountUpdate withCurrency(Optional<String> currency) {
        Utils.checkNotNull(currency, "currency");
        this.currency = currency;
        return this;
    }

    /**
     * Quantity in the smallest unit of the specified currency. 
     * 
     * <p>In USD this is cents, for example, $12.04 is 1204 and $0.99 is 99.
     */
    public AmountUpdate withValue(long value) {
        Utils.checkNotNull(value, "value");
        this.value = Optional.ofNullable(value);
        return this;
    }


    /**
     * Quantity in the smallest unit of the specified currency. 
     * 
     * <p>In USD this is cents, for example, $12.04 is 1204 and $0.99 is 99.
     */
    public AmountUpdate withValue(Optional<Long> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AmountUpdate other = (AmountUpdate) o;
        return 
            Utils.enhancedDeepEquals(this.currency, other.currency) &&
            Utils.enhancedDeepEquals(this.value, other.value);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            currency, value);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AmountUpdate.class,
                "currency", currency,
                "value", value);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<String> currency = Optional.empty();

        private Optional<Long> value = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * A 3-letter ISO 4217 currency code.
         */
        public Builder currency(String currency) {
            Utils.checkNotNull(currency, "currency");
            this.currency = Optional.ofNullable(currency);
            return this;
        }

        /**
         * A 3-letter ISO 4217 currency code.
         */
        public Builder currency(Optional<String> currency) {
            Utils.checkNotNull(currency, "currency");
            this.currency = currency;
            return this;
        }


        /**
         * Quantity in the smallest unit of the specified currency. 
         * 
         * <p>In USD this is cents, for example, $12.04 is 1204 and $0.99 is 99.
         */
        public Builder value(long value) {
            Utils.checkNotNull(value, "value");
            this.value = Optional.ofNullable(value);
            return this;
        }

        /**
         * Quantity in the smallest unit of the specified currency. 
         * 
         * <p>In USD this is cents, for example, $12.04 is 1204 and $0.99 is 99.
         */
        public Builder value(Optional<Long> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        public AmountUpdate build() {

            return new AmountUpdate(
                currency, value);
        }

    }
}
