/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;

/**
 * Adjustment
 * 
 * <p>An adjustment to a wallet.
 */
public class Adjustment {

    @JsonProperty("adjustmentID")
    private String adjustmentID;


    @JsonProperty("walletID")
    private String walletID;


    @JsonProperty("amount")
    private AmountDecimal amount;


    @JsonProperty("createdOn")
    private OffsetDateTime createdOn;

    @JsonCreator
    public Adjustment(
            @JsonProperty("adjustmentID") String adjustmentID,
            @JsonProperty("walletID") String walletID,
            @JsonProperty("amount") AmountDecimal amount,
            @JsonProperty("createdOn") OffsetDateTime createdOn) {
        Utils.checkNotNull(adjustmentID, "adjustmentID");
        Utils.checkNotNull(walletID, "walletID");
        Utils.checkNotNull(amount, "amount");
        Utils.checkNotNull(createdOn, "createdOn");
        this.adjustmentID = adjustmentID;
        this.walletID = walletID;
        this.amount = amount;
        this.createdOn = createdOn;
    }

    @JsonIgnore
    public String adjustmentID() {
        return adjustmentID;
    }

    @JsonIgnore
    public String walletID() {
        return walletID;
    }

    @JsonIgnore
    public AmountDecimal amount() {
        return amount;
    }

    @JsonIgnore
    public OffsetDateTime createdOn() {
        return createdOn;
    }

    public static Builder builder() {
        return new Builder();
    }


    public Adjustment withAdjustmentID(String adjustmentID) {
        Utils.checkNotNull(adjustmentID, "adjustmentID");
        this.adjustmentID = adjustmentID;
        return this;
    }

    public Adjustment withWalletID(String walletID) {
        Utils.checkNotNull(walletID, "walletID");
        this.walletID = walletID;
        return this;
    }

    public Adjustment withAmount(AmountDecimal amount) {
        Utils.checkNotNull(amount, "amount");
        this.amount = amount;
        return this;
    }

    public Adjustment withCreatedOn(OffsetDateTime createdOn) {
        Utils.checkNotNull(createdOn, "createdOn");
        this.createdOn = createdOn;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Adjustment other = (Adjustment) o;
        return 
            Utils.enhancedDeepEquals(this.adjustmentID, other.adjustmentID) &&
            Utils.enhancedDeepEquals(this.walletID, other.walletID) &&
            Utils.enhancedDeepEquals(this.amount, other.amount) &&
            Utils.enhancedDeepEquals(this.createdOn, other.createdOn);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            adjustmentID, walletID, amount,
            createdOn);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Adjustment.class,
                "adjustmentID", adjustmentID,
                "walletID", walletID,
                "amount", amount,
                "createdOn", createdOn);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String adjustmentID;

        private String walletID;

        private AmountDecimal amount;

        private OffsetDateTime createdOn;

        private Builder() {
          // force use of static builder() method
        }


        public Builder adjustmentID(String adjustmentID) {
            Utils.checkNotNull(adjustmentID, "adjustmentID");
            this.adjustmentID = adjustmentID;
            return this;
        }


        public Builder walletID(String walletID) {
            Utils.checkNotNull(walletID, "walletID");
            this.walletID = walletID;
            return this;
        }


        public Builder amount(AmountDecimal amount) {
            Utils.checkNotNull(amount, "amount");
            this.amount = amount;
            return this;
        }


        public Builder createdOn(OffsetDateTime createdOn) {
            Utils.checkNotNull(createdOn, "createdOn");
            this.createdOn = createdOn;
            return this;
        }

        public Adjustment build() {

            return new Adjustment(
                adjustmentID, walletID, amount,
                createdOn);
        }

    }
}
