/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;


public class Address {

    @JsonProperty("addressLine1")
    private String addressLine1;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("addressLine2")
    private Optional<String> addressLine2;


    @JsonProperty("city")
    private String city;


    @JsonProperty("stateOrProvince")
    private String stateOrProvince;


    @JsonProperty("postalCode")
    private String postalCode;


    @JsonProperty("country")
    private String country;

    @JsonCreator
    public Address(
            @JsonProperty("addressLine1") String addressLine1,
            @JsonProperty("addressLine2") Optional<String> addressLine2,
            @JsonProperty("city") String city,
            @JsonProperty("stateOrProvince") String stateOrProvince,
            @JsonProperty("postalCode") String postalCode,
            @JsonProperty("country") String country) {
        Utils.checkNotNull(addressLine1, "addressLine1");
        Utils.checkNotNull(addressLine2, "addressLine2");
        Utils.checkNotNull(city, "city");
        Utils.checkNotNull(stateOrProvince, "stateOrProvince");
        Utils.checkNotNull(postalCode, "postalCode");
        Utils.checkNotNull(country, "country");
        this.addressLine1 = addressLine1;
        this.addressLine2 = addressLine2;
        this.city = city;
        this.stateOrProvince = stateOrProvince;
        this.postalCode = postalCode;
        this.country = country;
    }
    
    public Address(
            String addressLine1,
            String city,
            String stateOrProvince,
            String postalCode,
            String country) {
        this(addressLine1, Optional.empty(), city,
            stateOrProvince, postalCode, country);
    }

    @JsonIgnore
    public String addressLine1() {
        return addressLine1;
    }

    @JsonIgnore
    public Optional<String> addressLine2() {
        return addressLine2;
    }

    @JsonIgnore
    public String city() {
        return city;
    }

    @JsonIgnore
    public String stateOrProvince() {
        return stateOrProvince;
    }

    @JsonIgnore
    public String postalCode() {
        return postalCode;
    }

    @JsonIgnore
    public String country() {
        return country;
    }

    public static Builder builder() {
        return new Builder();
    }


    public Address withAddressLine1(String addressLine1) {
        Utils.checkNotNull(addressLine1, "addressLine1");
        this.addressLine1 = addressLine1;
        return this;
    }

    public Address withAddressLine2(String addressLine2) {
        Utils.checkNotNull(addressLine2, "addressLine2");
        this.addressLine2 = Optional.ofNullable(addressLine2);
        return this;
    }


    public Address withAddressLine2(Optional<String> addressLine2) {
        Utils.checkNotNull(addressLine2, "addressLine2");
        this.addressLine2 = addressLine2;
        return this;
    }

    public Address withCity(String city) {
        Utils.checkNotNull(city, "city");
        this.city = city;
        return this;
    }

    public Address withStateOrProvince(String stateOrProvince) {
        Utils.checkNotNull(stateOrProvince, "stateOrProvince");
        this.stateOrProvince = stateOrProvince;
        return this;
    }

    public Address withPostalCode(String postalCode) {
        Utils.checkNotNull(postalCode, "postalCode");
        this.postalCode = postalCode;
        return this;
    }

    public Address withCountry(String country) {
        Utils.checkNotNull(country, "country");
        this.country = country;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Address other = (Address) o;
        return 
            Utils.enhancedDeepEquals(this.addressLine1, other.addressLine1) &&
            Utils.enhancedDeepEquals(this.addressLine2, other.addressLine2) &&
            Utils.enhancedDeepEquals(this.city, other.city) &&
            Utils.enhancedDeepEquals(this.stateOrProvince, other.stateOrProvince) &&
            Utils.enhancedDeepEquals(this.postalCode, other.postalCode) &&
            Utils.enhancedDeepEquals(this.country, other.country);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            addressLine1, addressLine2, city,
            stateOrProvince, postalCode, country);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Address.class,
                "addressLine1", addressLine1,
                "addressLine2", addressLine2,
                "city", city,
                "stateOrProvince", stateOrProvince,
                "postalCode", postalCode,
                "country", country);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String addressLine1;

        private Optional<String> addressLine2 = Optional.empty();

        private String city;

        private String stateOrProvince;

        private String postalCode;

        private String country;

        private Builder() {
          // force use of static builder() method
        }


        public Builder addressLine1(String addressLine1) {
            Utils.checkNotNull(addressLine1, "addressLine1");
            this.addressLine1 = addressLine1;
            return this;
        }


        public Builder addressLine2(String addressLine2) {
            Utils.checkNotNull(addressLine2, "addressLine2");
            this.addressLine2 = Optional.ofNullable(addressLine2);
            return this;
        }

        public Builder addressLine2(Optional<String> addressLine2) {
            Utils.checkNotNull(addressLine2, "addressLine2");
            this.addressLine2 = addressLine2;
            return this;
        }


        public Builder city(String city) {
            Utils.checkNotNull(city, "city");
            this.city = city;
            return this;
        }


        public Builder stateOrProvince(String stateOrProvince) {
            Utils.checkNotNull(stateOrProvince, "stateOrProvince");
            this.stateOrProvince = stateOrProvince;
            return this;
        }


        public Builder postalCode(String postalCode) {
            Utils.checkNotNull(postalCode, "postalCode");
            this.postalCode = postalCode;
            return this;
        }


        public Builder country(String country) {
            Utils.checkNotNull(country, "country");
            this.country = country;
            return this;
        }

        public Address build() {

            return new Address(
                addressLine1, addressLine2, city,
                stateOrProvince, postalCode, country);
        }

    }
}
