/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;

/**
 * AccountTerminalApplication
 * 
 * <p>Describes link between an account and a terminal application.
 */
public class AccountTerminalApplication {
    /**
     * ID of the merchant account.
     */
    @JsonProperty("accountID")
    private String accountID;

    /**
     * ID of the terminal application.
     */
    @JsonProperty("terminalApplicationID")
    private String terminalApplicationID;

    @JsonCreator
    public AccountTerminalApplication(
            @JsonProperty("accountID") String accountID,
            @JsonProperty("terminalApplicationID") String terminalApplicationID) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(terminalApplicationID, "terminalApplicationID");
        this.accountID = accountID;
        this.terminalApplicationID = terminalApplicationID;
    }

    /**
     * ID of the merchant account.
     */
    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    /**
     * ID of the terminal application.
     */
    @JsonIgnore
    public String terminalApplicationID() {
        return terminalApplicationID;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * ID of the merchant account.
     */
    public AccountTerminalApplication withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    /**
     * ID of the terminal application.
     */
    public AccountTerminalApplication withTerminalApplicationID(String terminalApplicationID) {
        Utils.checkNotNull(terminalApplicationID, "terminalApplicationID");
        this.terminalApplicationID = terminalApplicationID;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountTerminalApplication other = (AccountTerminalApplication) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.terminalApplicationID, other.terminalApplicationID);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, terminalApplicationID);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AccountTerminalApplication.class,
                "accountID", accountID,
                "terminalApplicationID", terminalApplicationID);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private String terminalApplicationID;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * ID of the merchant account.
         */
        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        /**
         * ID of the terminal application.
         */
        public Builder terminalApplicationID(String terminalApplicationID) {
            Utils.checkNotNull(terminalApplicationID, "terminalApplicationID");
            this.terminalApplicationID = terminalApplicationID;
            return this;
        }

        public AccountTerminalApplication build() {

            return new AccountTerminalApplication(
                accountID, terminalApplicationID);
        }

    }
}
