/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Optional;

/**
 * AccountNameVerification
 * 
 * <p>The results of submitting cardholder name to a card network for verification.
 */
public class AccountNameVerification {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("firstName")
    private Optional<? extends CardVerificationResult> firstName;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("lastName")
    private Optional<? extends CardVerificationResult> lastName;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("middleName")
    private Optional<? extends CardVerificationResult> middleName;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("fullName")
    private Optional<? extends CardVerificationResult> fullName;

    @JsonCreator
    public AccountNameVerification(
            @JsonProperty("firstName") Optional<? extends CardVerificationResult> firstName,
            @JsonProperty("lastName") Optional<? extends CardVerificationResult> lastName,
            @JsonProperty("middleName") Optional<? extends CardVerificationResult> middleName,
            @JsonProperty("fullName") Optional<? extends CardVerificationResult> fullName) {
        Utils.checkNotNull(firstName, "firstName");
        Utils.checkNotNull(lastName, "lastName");
        Utils.checkNotNull(middleName, "middleName");
        Utils.checkNotNull(fullName, "fullName");
        this.firstName = firstName;
        this.lastName = lastName;
        this.middleName = middleName;
        this.fullName = fullName;
    }
    
    public AccountNameVerification() {
        this(Optional.empty(), Optional.empty(), Optional.empty(),
            Optional.empty());
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<CardVerificationResult> firstName() {
        return (Optional<CardVerificationResult>) firstName;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<CardVerificationResult> lastName() {
        return (Optional<CardVerificationResult>) lastName;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<CardVerificationResult> middleName() {
        return (Optional<CardVerificationResult>) middleName;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<CardVerificationResult> fullName() {
        return (Optional<CardVerificationResult>) fullName;
    }

    public static Builder builder() {
        return new Builder();
    }


    public AccountNameVerification withFirstName(CardVerificationResult firstName) {
        Utils.checkNotNull(firstName, "firstName");
        this.firstName = Optional.ofNullable(firstName);
        return this;
    }


    public AccountNameVerification withFirstName(Optional<? extends CardVerificationResult> firstName) {
        Utils.checkNotNull(firstName, "firstName");
        this.firstName = firstName;
        return this;
    }

    public AccountNameVerification withLastName(CardVerificationResult lastName) {
        Utils.checkNotNull(lastName, "lastName");
        this.lastName = Optional.ofNullable(lastName);
        return this;
    }


    public AccountNameVerification withLastName(Optional<? extends CardVerificationResult> lastName) {
        Utils.checkNotNull(lastName, "lastName");
        this.lastName = lastName;
        return this;
    }

    public AccountNameVerification withMiddleName(CardVerificationResult middleName) {
        Utils.checkNotNull(middleName, "middleName");
        this.middleName = Optional.ofNullable(middleName);
        return this;
    }


    public AccountNameVerification withMiddleName(Optional<? extends CardVerificationResult> middleName) {
        Utils.checkNotNull(middleName, "middleName");
        this.middleName = middleName;
        return this;
    }

    public AccountNameVerification withFullName(CardVerificationResult fullName) {
        Utils.checkNotNull(fullName, "fullName");
        this.fullName = Optional.ofNullable(fullName);
        return this;
    }


    public AccountNameVerification withFullName(Optional<? extends CardVerificationResult> fullName) {
        Utils.checkNotNull(fullName, "fullName");
        this.fullName = fullName;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountNameVerification other = (AccountNameVerification) o;
        return 
            Utils.enhancedDeepEquals(this.firstName, other.firstName) &&
            Utils.enhancedDeepEquals(this.lastName, other.lastName) &&
            Utils.enhancedDeepEquals(this.middleName, other.middleName) &&
            Utils.enhancedDeepEquals(this.fullName, other.fullName);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            firstName, lastName, middleName,
            fullName);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AccountNameVerification.class,
                "firstName", firstName,
                "lastName", lastName,
                "middleName", middleName,
                "fullName", fullName);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<? extends CardVerificationResult> firstName = Optional.empty();

        private Optional<? extends CardVerificationResult> lastName = Optional.empty();

        private Optional<? extends CardVerificationResult> middleName = Optional.empty();

        private Optional<? extends CardVerificationResult> fullName = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        public Builder firstName(CardVerificationResult firstName) {
            Utils.checkNotNull(firstName, "firstName");
            this.firstName = Optional.ofNullable(firstName);
            return this;
        }

        public Builder firstName(Optional<? extends CardVerificationResult> firstName) {
            Utils.checkNotNull(firstName, "firstName");
            this.firstName = firstName;
            return this;
        }


        public Builder lastName(CardVerificationResult lastName) {
            Utils.checkNotNull(lastName, "lastName");
            this.lastName = Optional.ofNullable(lastName);
            return this;
        }

        public Builder lastName(Optional<? extends CardVerificationResult> lastName) {
            Utils.checkNotNull(lastName, "lastName");
            this.lastName = lastName;
            return this;
        }


        public Builder middleName(CardVerificationResult middleName) {
            Utils.checkNotNull(middleName, "middleName");
            this.middleName = Optional.ofNullable(middleName);
            return this;
        }

        public Builder middleName(Optional<? extends CardVerificationResult> middleName) {
            Utils.checkNotNull(middleName, "middleName");
            this.middleName = middleName;
            return this;
        }


        public Builder fullName(CardVerificationResult fullName) {
            Utils.checkNotNull(fullName, "fullName");
            this.fullName = Optional.ofNullable(fullName);
            return this;
        }

        public Builder fullName(Optional<? extends CardVerificationResult> fullName) {
            Utils.checkNotNull(fullName, "fullName");
            this.fullName = fullName;
            return this;
        }

        public AccountNameVerification build() {

            return new AccountNameVerification(
                firstName, lastName, middleName,
                fullName);
        }

    }
}
