/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk;

import static io.moov.sdk.operations.Operations.RequestOperation;

import io.moov.sdk.models.operations.GetWalletRequest;
import io.moov.sdk.models.operations.GetWalletRequestBuilder;
import io.moov.sdk.models.operations.GetWalletResponse;
import io.moov.sdk.models.operations.ListWalletsRequest;
import io.moov.sdk.models.operations.ListWalletsRequestBuilder;
import io.moov.sdk.models.operations.ListWalletsResponse;
import io.moov.sdk.operations.GetWalletOperation;
import io.moov.sdk.operations.ListWalletsOperation;
import java.lang.Exception;
import java.lang.String;


public class Wallets {
    private final SDKConfiguration sdkConfiguration;

    Wallets(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    /**
     * List the wallets associated with a Moov account. 
     * 
     * <p>Read our [Moov wallets guide](https://docs.moov.io/guides/sources/wallets/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/wallets.read` scope.
     * 
     * @return The call builder
     */
    public ListWalletsRequestBuilder list() {
        return new ListWalletsRequestBuilder(sdkConfiguration);
    }

    /**
     * List the wallets associated with a Moov account. 
     * 
     * <p>Read our [Moov wallets guide](https://docs.moov.io/guides/sources/wallets/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/wallets.read` scope.
     * 
     * @param accountID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListWalletsResponse list(String accountID) throws Exception {
        ListWalletsRequest request =
            ListWalletsRequest
                .builder()
                .accountID(accountID)
                .build();
        RequestOperation<ListWalletsRequest, ListWalletsResponse> operation
              = new ListWalletsOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Get information on a specific wallet (e.g., the available balance). 
     * 
     * <p>Read our [Moov wallets guide](https://docs.moov.io/guides/sources/wallets/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/wallets.read` scope.
     * 
     * @return The call builder
     */
    public GetWalletRequestBuilder get() {
        return new GetWalletRequestBuilder(sdkConfiguration);
    }

    /**
     * Get information on a specific wallet (e.g., the available balance). 
     * 
     * <p>Read our [Moov wallets guide](https://docs.moov.io/guides/sources/wallets/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/wallets.read` scope.
     * 
     * @param accountID 
     * @param walletID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetWalletResponse get(String accountID, String walletID) throws Exception {
        GetWalletRequest request =
            GetWalletRequest
                .builder()
                .accountID(accountID)
                .walletID(walletID)
                .build();
        RequestOperation<GetWalletRequest, GetWalletResponse> operation
              = new GetWalletOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

}
