/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk;

import static io.moov.sdk.operations.Operations.RequestOperation;

import io.moov.sdk.models.operations.GetWalletTransactionRequest;
import io.moov.sdk.models.operations.GetWalletTransactionRequestBuilder;
import io.moov.sdk.models.operations.GetWalletTransactionResponse;
import io.moov.sdk.models.operations.ListWalletTransactionsRequest;
import io.moov.sdk.models.operations.ListWalletTransactionsRequestBuilder;
import io.moov.sdk.models.operations.ListWalletTransactionsResponse;
import io.moov.sdk.operations.GetWalletTransactionOperation;
import io.moov.sdk.operations.ListWalletTransactionsOperation;
import java.lang.Exception;
import java.lang.String;


public class WalletTransactions {
    private final SDKConfiguration sdkConfiguration;

    WalletTransactions(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    /**
     * List all the transactions associated with a particular Moov wallet. 
     * 
     * <p>Read our [wallet transactions guide](https://docs.moov.io/guides/sources/wallets/transactions/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/wallets.read` scope.
     * 
     * @return The call builder
     */
    public ListWalletTransactionsRequestBuilder list() {
        return new ListWalletTransactionsRequestBuilder(sdkConfiguration);
    }

    /**
     * List all the transactions associated with a particular Moov wallet. 
     * 
     * <p>Read our [wallet transactions guide](https://docs.moov.io/guides/sources/wallets/transactions/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/wallets.read` scope.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListWalletTransactionsResponse list(ListWalletTransactionsRequest request) throws Exception {
        RequestOperation<ListWalletTransactionsRequest, ListWalletTransactionsResponse> operation
              = new ListWalletTransactionsOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Get details on a specific wallet transaction. 
     * 
     * <p>Read our [wallet transactions guide](https://docs.moov.io/guides/sources/wallets/transactions/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/wallets.read` scope.
     * 
     * @return The call builder
     */
    public GetWalletTransactionRequestBuilder get() {
        return new GetWalletTransactionRequestBuilder(sdkConfiguration);
    }

    /**
     * Get details on a specific wallet transaction. 
     * 
     * <p>Read our [wallet transactions guide](https://docs.moov.io/guides/sources/wallets/transactions/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/wallets.read` scope.
     * 
     * @param accountID 
     * @param walletID 
     * @param transactionID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetWalletTransactionResponse get(
            String accountID, String walletID,
            String transactionID) throws Exception {
        GetWalletTransactionRequest request =
            GetWalletTransactionRequest
                .builder()
                .accountID(accountID)
                .walletID(walletID)
                .transactionID(transactionID)
                .build();
        RequestOperation<GetWalletTransactionRequest, GetWalletTransactionResponse> operation
              = new GetWalletTransactionOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

}
