/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk;

import static io.moov.sdk.operations.Operations.RequestOperation;

import io.moov.sdk.models.components.UpdateUnderwriting;
import io.moov.sdk.models.components.UpsertUnderwriting;
import io.moov.sdk.models.operations.GetUnderwritingRequest;
import io.moov.sdk.models.operations.GetUnderwritingRequestBuilder;
import io.moov.sdk.models.operations.GetUnderwritingResponse;
import io.moov.sdk.models.operations.SaveUnderwritingRequest;
import io.moov.sdk.models.operations.SaveUnderwritingRequestBuilder;
import io.moov.sdk.models.operations.SaveUnderwritingResponse;
import io.moov.sdk.models.operations.UpsertUnderwritingRequest;
import io.moov.sdk.models.operations.UpsertUnderwritingRequestBuilder;
import io.moov.sdk.models.operations.UpsertUnderwritingResponse;
import io.moov.sdk.operations.GetUnderwritingOperation;
import io.moov.sdk.operations.SaveUnderwritingOperation;
import io.moov.sdk.operations.UpsertUnderwritingOperation;
import java.lang.Exception;
import java.lang.String;


public class Underwriting {
    private final SDKConfiguration sdkConfiguration;

    Underwriting(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    /**
     * Retrieve underwriting associated with a given Moov account. 
     * 
     * <p>Read our [underwriting guide](https://docs.moov.io/guides/accounts/requirements/underwriting/) to learn more. 
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/profile.read` scope.
     * 
     * @return The call builder
     */
    public GetUnderwritingRequestBuilder get() {
        return new GetUnderwritingRequestBuilder(sdkConfiguration);
    }

    /**
     * Retrieve underwriting associated with a given Moov account. 
     * 
     * <p>Read our [underwriting guide](https://docs.moov.io/guides/accounts/requirements/underwriting/) to learn more. 
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/profile.read` scope.
     * 
     * @param accountID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetUnderwritingResponse get(String accountID) throws Exception {
        GetUnderwritingRequest request =
            GetUnderwritingRequest
                .builder()
                .accountID(accountID)
                .build();
        RequestOperation<GetUnderwritingRequest, GetUnderwritingResponse> operation
              = new GetUnderwritingOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Create or update the account's underwriting.
     * 
     * <p>Read our [underwriting guide](https://docs.moov.io/guides/accounts/requirements/underwriting/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/profile.write` scope.
     * 
     * @return The call builder
     */
    public SaveUnderwritingRequestBuilder save() {
        return new SaveUnderwritingRequestBuilder(sdkConfiguration);
    }

    /**
     * Create or update the account's underwriting.
     * 
     * <p>Read our [underwriting guide](https://docs.moov.io/guides/accounts/requirements/underwriting/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/profile.write` scope.
     * 
     * @param accountID 
     * @param upsertUnderwriting 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public SaveUnderwritingResponse save(String accountID, UpsertUnderwriting upsertUnderwriting) throws Exception {
        SaveUnderwritingRequest request =
            SaveUnderwritingRequest
                .builder()
                .accountID(accountID)
                .upsertUnderwriting(upsertUnderwriting)
                .build();
        RequestOperation<SaveUnderwritingRequest, SaveUnderwritingResponse> operation
              = new SaveUnderwritingOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Create or update the account's underwriting.
     * 
     * <p>Read our [underwriting guide](https://docs.moov.io/guides/accounts/requirements/underwriting/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/profile.write` scope.
     * 
     * @return The call builder
     */
    public UpsertUnderwritingRequestBuilder upsert() {
        return new UpsertUnderwritingRequestBuilder(sdkConfiguration);
    }

    /**
     * Create or update the account's underwriting.
     * 
     * <p>Read our [underwriting guide](https://docs.moov.io/guides/accounts/requirements/underwriting/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/profile.write` scope.
     * 
     * @param accountID 
     * @param updateUnderwriting 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public UpsertUnderwritingResponse upsert(String accountID, UpdateUnderwriting updateUnderwriting) throws Exception {
        UpsertUnderwritingRequest request =
            UpsertUnderwritingRequest
                .builder()
                .accountID(accountID)
                .updateUnderwriting(updateUnderwriting)
                .build();
        RequestOperation<UpsertUnderwritingRequest, UpsertUnderwritingResponse> operation
              = new UpsertUnderwritingOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

}
