/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk;

import static io.moov.sdk.operations.Operations.RequestOperation;

import io.moov.sdk.models.components.CreateReversal;
import io.moov.sdk.models.components.CreateTransfer;
import io.moov.sdk.models.components.CreateTransferOptions;
import io.moov.sdk.models.components.PatchTransfer;
import io.moov.sdk.models.components.TransferWaitFor;
import io.moov.sdk.models.operations.CreateCancellationRequest;
import io.moov.sdk.models.operations.CreateCancellationRequestBuilder;
import io.moov.sdk.models.operations.CreateCancellationResponse;
import io.moov.sdk.models.operations.CreateReversalRequest;
import io.moov.sdk.models.operations.CreateReversalRequestBuilder;
import io.moov.sdk.models.operations.CreateReversalResponse;
import io.moov.sdk.models.operations.CreateTransferOptionsRequest;
import io.moov.sdk.models.operations.CreateTransferOptionsRequestBuilder;
import io.moov.sdk.models.operations.CreateTransferOptionsResponse;
import io.moov.sdk.models.operations.CreateTransferRequest;
import io.moov.sdk.models.operations.CreateTransferRequestBuilder;
import io.moov.sdk.models.operations.CreateTransferResponse;
import io.moov.sdk.models.operations.GetCancellationRequest;
import io.moov.sdk.models.operations.GetCancellationRequestBuilder;
import io.moov.sdk.models.operations.GetCancellationResponse;
import io.moov.sdk.models.operations.GetRefundRequest;
import io.moov.sdk.models.operations.GetRefundRequestBuilder;
import io.moov.sdk.models.operations.GetRefundResponse;
import io.moov.sdk.models.operations.GetTransferRequest;
import io.moov.sdk.models.operations.GetTransferRequestBuilder;
import io.moov.sdk.models.operations.GetTransferResponse;
import io.moov.sdk.models.operations.InitiateRefundRequest;
import io.moov.sdk.models.operations.InitiateRefundRequestBuilder;
import io.moov.sdk.models.operations.InitiateRefundResponse;
import io.moov.sdk.models.operations.ListRefundsRequest;
import io.moov.sdk.models.operations.ListRefundsRequestBuilder;
import io.moov.sdk.models.operations.ListRefundsResponse;
import io.moov.sdk.models.operations.ListTransfersRequest;
import io.moov.sdk.models.operations.ListTransfersRequestBuilder;
import io.moov.sdk.models.operations.ListTransfersResponse;
import io.moov.sdk.models.operations.UpdateTransferRequest;
import io.moov.sdk.models.operations.UpdateTransferRequestBuilder;
import io.moov.sdk.models.operations.UpdateTransferResponse;
import io.moov.sdk.operations.CreateCancellationOperation;
import io.moov.sdk.operations.CreateReversalOperation;
import io.moov.sdk.operations.CreateTransferOperation;
import io.moov.sdk.operations.CreateTransferOptionsOperation;
import io.moov.sdk.operations.GetCancellationOperation;
import io.moov.sdk.operations.GetRefundOperation;
import io.moov.sdk.operations.GetTransferOperation;
import io.moov.sdk.operations.InitiateRefundOperation;
import io.moov.sdk.operations.ListRefundsOperation;
import io.moov.sdk.operations.ListTransfersOperation;
import io.moov.sdk.operations.UpdateTransferOperation;
import java.lang.Exception;
import java.lang.String;
import java.util.Optional;


public class Transfers {
    private final SDKConfiguration sdkConfiguration;

    Transfers(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    /**
     * Generate available payment method options for one or multiple transfer participants depending on the accountID or paymentMethodID you 
     * supply in the request body.
     * 
     * <p>The accountID in the route should the partner's accountID.
     * 
     * <p>Read our [transfers overview guide](https://docs.moov.io/guides/money-movement/overview/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.write` scope.
     * 
     * @return The call builder
     */
    public CreateTransferOptionsRequestBuilder generateOptions() {
        return new CreateTransferOptionsRequestBuilder(sdkConfiguration);
    }

    /**
     * Generate available payment method options for one or multiple transfer participants depending on the accountID or paymentMethodID you 
     * supply in the request body.
     * 
     * <p>The accountID in the route should the partner's accountID.
     * 
     * <p>Read our [transfers overview guide](https://docs.moov.io/guides/money-movement/overview/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.write` scope.
     * 
     * @param accountID The partner's Moov account ID.
     * @param createTransferOptions 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public CreateTransferOptionsResponse generateOptions(String accountID, CreateTransferOptions createTransferOptions) throws Exception {
        CreateTransferOptionsRequest request =
            CreateTransferOptionsRequest
                .builder()
                .accountID(accountID)
                .createTransferOptions(createTransferOptions)
                .build();
        RequestOperation<CreateTransferOptionsRequest, CreateTransferOptionsResponse> operation
              = new CreateTransferOptionsOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Move money by providing the source, destination, and amount in the request body.
     * 
     * <p>Read our [transfers overview guide](https://docs.moov.io/guides/money-movement/overview/) to learn more. 
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.write` scope.
     * 
     * @return The call builder
     */
    public CreateTransferRequestBuilder create() {
        return new CreateTransferRequestBuilder(sdkConfiguration);
    }

    /**
     * Move money by providing the source, destination, and amount in the request body.
     * 
     * <p>Read our [transfers overview guide](https://docs.moov.io/guides/money-movement/overview/) to learn more. 
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.write` scope.
     * 
     * @param xIdempotencyKey Prevents duplicate transfers from being created.
     * @param accountID Your Moov account ID.
     * @param createTransfer 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public CreateTransferResponse create(
            String xIdempotencyKey, String accountID,
            CreateTransfer createTransfer) throws Exception {
        return create(xIdempotencyKey, Optional.empty(), accountID,
            createTransfer);
    }

    /**
     * Move money by providing the source, destination, and amount in the request body.
     * 
     * <p>Read our [transfers overview guide](https://docs.moov.io/guides/money-movement/overview/) to learn more. 
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.write` scope.
     * 
     * @param xIdempotencyKey Prevents duplicate transfers from being created.
     * @param xWaitFor 
     * @param accountID Your Moov account ID.
     * @param createTransfer 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public CreateTransferResponse create(
            String xIdempotencyKey, Optional<? extends TransferWaitFor> xWaitFor,
            String accountID, CreateTransfer createTransfer) throws Exception {
        CreateTransferRequest request =
            CreateTransferRequest
                .builder()
                .xIdempotencyKey(xIdempotencyKey)
                .xWaitFor(xWaitFor)
                .accountID(accountID)
                .createTransfer(createTransfer)
                .build();
        RequestOperation<CreateTransferRequest, CreateTransferResponse> operation
              = new CreateTransferOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * List all the transfers associated with a particular Moov account. 
     * 
     * <p>Read our [transfers overview guide](https://docs.moov.io/guides/money-movement/overview/) to learn more. 
     * 
     * <p>When you run this request, you retrieve 200 transfers at a time. You can advance past a results set of 200 transfers by using the `skip` parameter (for example, 
     * if you set `skip`= 10, you will see a results set of 200 transfers after the first 10). If you are searching a high volume of transfers, the request will likely 
     * process very slowly. To achieve faster performance, restrict the data as much as you can by using the `StartDateTime` and `EndDateTime` parameters for a limited 
     * period of time. You can run multiple requests in smaller time window increments until you've retrieved all the transfers you need.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.read` scope.
     * 
     * @return The call builder
     */
    public ListTransfersRequestBuilder list() {
        return new ListTransfersRequestBuilder(sdkConfiguration);
    }

    /**
     * List all the transfers associated with a particular Moov account. 
     * 
     * <p>Read our [transfers overview guide](https://docs.moov.io/guides/money-movement/overview/) to learn more. 
     * 
     * <p>When you run this request, you retrieve 200 transfers at a time. You can advance past a results set of 200 transfers by using the `skip` parameter (for example, 
     * if you set `skip`= 10, you will see a results set of 200 transfers after the first 10). If you are searching a high volume of transfers, the request will likely 
     * process very slowly. To achieve faster performance, restrict the data as much as you can by using the `StartDateTime` and `EndDateTime` parameters for a limited 
     * period of time. You can run multiple requests in smaller time window increments until you've retrieved all the transfers you need.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.read` scope.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListTransfersResponse list(ListTransfersRequest request) throws Exception {
        RequestOperation<ListTransfersRequest, ListTransfersResponse> operation
              = new ListTransfersOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Retrieve full transfer details for an individual transfer of a particular Moov account. 
     * 
     * <p>Payment rail-specific details are included in the source and destination. Read our [transfers overview guide](https://docs.moov.io/guides/money-movement/overview/) 
     * to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.read` scope.
     * 
     * @return The call builder
     */
    public GetTransferRequestBuilder get() {
        return new GetTransferRequestBuilder(sdkConfiguration);
    }

    /**
     * Retrieve full transfer details for an individual transfer of a particular Moov account. 
     * 
     * <p>Payment rail-specific details are included in the source and destination. Read our [transfers overview guide](https://docs.moov.io/guides/money-movement/overview/) 
     * to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.read` scope.
     * 
     * @param transferID Identifier for the transfer.
     * @param accountID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetTransferResponse get(String transferID, String accountID) throws Exception {
        GetTransferRequest request =
            GetTransferRequest
                .builder()
                .transferID(transferID)
                .accountID(accountID)
                .build();
        RequestOperation<GetTransferRequest, GetTransferResponse> operation
              = new GetTransferOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Update the metadata contained on a transfer. 
     * 
     * <p>Read our [transfers overview guide](https://docs.moov.io/guides/money-movement/overview/) to learn more. 
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.write` scope.
     * 
     * @return The call builder
     */
    public UpdateTransferRequestBuilder update() {
        return new UpdateTransferRequestBuilder(sdkConfiguration);
    }

    /**
     * Update the metadata contained on a transfer. 
     * 
     * <p>Read our [transfers overview guide](https://docs.moov.io/guides/money-movement/overview/) to learn more. 
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.write` scope.
     * 
     * @param transferID Identifier for the transfer.
     * @param accountID 
     * @param patchTransfer 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public UpdateTransferResponse update(
            String transferID, String accountID,
            PatchTransfer patchTransfer) throws Exception {
        UpdateTransferRequest request =
            UpdateTransferRequest
                .builder()
                .transferID(transferID)
                .accountID(accountID)
                .patchTransfer(patchTransfer)
                .build();
        RequestOperation<UpdateTransferRequest, UpdateTransferResponse> operation
              = new UpdateTransferOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Initiate a cancellation for a card, ACH, or queued transfer.
     * 
     * <p>  To access this endpoint using a [token](https://docs.moov.io/api/authentication/access-tokens/) you'll need 
     *   to specify the `/accounts/{accountID}/transfers.write` scope.
     * 
     * @return The call builder
     */
    public CreateCancellationRequestBuilder createCancellation() {
        return new CreateCancellationRequestBuilder(sdkConfiguration);
    }

    /**
     * Initiate a cancellation for a card, ACH, or queued transfer.
     * 
     * <p>  To access this endpoint using a [token](https://docs.moov.io/api/authentication/access-tokens/) you'll need 
     *   to specify the `/accounts/{accountID}/transfers.write` scope.
     * 
     * @param accountID The partner's Moov account ID.
     * @param transferID The transfer ID to cancel.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public CreateCancellationResponse createCancellation(String accountID, String transferID) throws Exception {
        CreateCancellationRequest request =
            CreateCancellationRequest
                .builder()
                .accountID(accountID)
                .transferID(transferID)
                .build();
        RequestOperation<CreateCancellationRequest, CreateCancellationResponse> operation
              = new CreateCancellationOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Get details of a cancellation for a transfer.
     * 
     * <p>  To access this endpoint using a [token](https://docs.moov.io/api/authentication/access-tokens/) you'll need 
     *   to specify the `/accounts/{accountID}/transfers.read` scope.
     * 
     * @return The call builder
     */
    public GetCancellationRequestBuilder getCancellation() {
        return new GetCancellationRequestBuilder(sdkConfiguration);
    }

    /**
     * Get details of a cancellation for a transfer.
     * 
     * <p>  To access this endpoint using a [token](https://docs.moov.io/api/authentication/access-tokens/) you'll need 
     *   to specify the `/accounts/{accountID}/transfers.read` scope.
     * 
     * @param accountID Moov account ID of the partner or transfer's source or destination.
     * @param transferID Identifier for the transfer.
     * @param cancellationID Identifier for the cancellation.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetCancellationResponse getCancellation(
            String accountID, String transferID,
            String cancellationID) throws Exception {
        GetCancellationRequest request =
            GetCancellationRequest
                .builder()
                .accountID(accountID)
                .transferID(transferID)
                .cancellationID(cancellationID)
                .build();
        RequestOperation<GetCancellationRequest, GetCancellationResponse> operation
              = new GetCancellationOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Initiate a refund for a card transfer.
     * 
     * <p>**Use the [Cancel or refund a card transfer](https://docs.moov.io/api/money-movement/refunds/cancel/) endpoint for more comprehensive cancel and refund options.**    
     * See the [reversals](https://docs.moov.io/guides/money-movement/accept-payments/card-acceptance/reversals/) guide for more information. 
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.write` scope.
     * 
     * @return The call builder
     */
    public InitiateRefundRequestBuilder initiateRefund() {
        return new InitiateRefundRequestBuilder(sdkConfiguration);
    }

    /**
     * Initiate a refund for a card transfer.
     * 
     * <p>**Use the [Cancel or refund a card transfer](https://docs.moov.io/api/money-movement/refunds/cancel/) endpoint for more comprehensive cancel and refund options.**    
     * See the [reversals](https://docs.moov.io/guides/money-movement/accept-payments/card-acceptance/reversals/) guide for more information. 
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.write` scope.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public InitiateRefundResponse initiateRefund(InitiateRefundRequest request) throws Exception {
        RequestOperation<InitiateRefundRequest, InitiateRefundResponse> operation
              = new InitiateRefundOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Get a list of refunds for a card transfer.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.read` scope.
     * 
     * @return The call builder
     */
    public ListRefundsRequestBuilder listRefunds() {
        return new ListRefundsRequestBuilder(sdkConfiguration);
    }

    /**
     * Get a list of refunds for a card transfer.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.read` scope.
     * 
     * @param accountID 
     * @param transferID Identifier for the transfer.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListRefundsResponse listRefunds(String accountID, String transferID) throws Exception {
        ListRefundsRequest request =
            ListRefundsRequest
                .builder()
                .accountID(accountID)
                .transferID(transferID)
                .build();
        RequestOperation<ListRefundsRequest, ListRefundsResponse> operation
              = new ListRefundsOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Get details of a refund for a card transfer.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.read` scope.
     * 
     * @return The call builder
     */
    public GetRefundRequestBuilder getRefund() {
        return new GetRefundRequestBuilder(sdkConfiguration);
    }

    /**
     * Get details of a refund for a card transfer.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.read` scope.
     * 
     * @param transferID Identifier for the transfer.
     * @param accountID 
     * @param refundID Identifier for the refund.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetRefundResponse getRefund(
            String transferID, String accountID,
            String refundID) throws Exception {
        GetRefundRequest request =
            GetRefundRequest
                .builder()
                .transferID(transferID)
                .accountID(accountID)
                .refundID(refundID)
                .build();
        RequestOperation<GetRefundRequest, GetRefundResponse> operation
              = new GetRefundOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Reverses a card transfer by initiating a cancellation or refund depending on the transaction status. 
     * Read our [reversals guide](https://docs.moov.io/guides/money-movement/accept-payments/card-acceptance/reversals/) 
     * to learn more.
     * 
     * <p>To access this endpoint using a [token](https://docs.moov.io/api/authentication/access-tokens/) you'll need 
     * to specify the `/accounts/{accountID}/transfers.write` scope.
     * 
     * @return The call builder
     */
    public CreateReversalRequestBuilder createReversal() {
        return new CreateReversalRequestBuilder(sdkConfiguration);
    }

    /**
     * Reverses a card transfer by initiating a cancellation or refund depending on the transaction status. 
     * Read our [reversals guide](https://docs.moov.io/guides/money-movement/accept-payments/card-acceptance/reversals/) 
     * to learn more.
     * 
     * <p>To access this endpoint using a [token](https://docs.moov.io/api/authentication/access-tokens/) you'll need 
     * to specify the `/accounts/{accountID}/transfers.write` scope.
     * 
     * @param xIdempotencyKey Prevents duplicate reversals from being created.
     * @param accountID The Moov account ID.
     * @param transferID The transfer ID to reverse.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public CreateReversalResponse createReversal(
            String xIdempotencyKey, String accountID,
            String transferID) throws Exception {
        return createReversal(xIdempotencyKey, accountID, transferID,
            Optional.empty());
    }

    /**
     * Reverses a card transfer by initiating a cancellation or refund depending on the transaction status. 
     * Read our [reversals guide](https://docs.moov.io/guides/money-movement/accept-payments/card-acceptance/reversals/) 
     * to learn more.
     * 
     * <p>To access this endpoint using a [token](https://docs.moov.io/api/authentication/access-tokens/) you'll need 
     * to specify the `/accounts/{accountID}/transfers.write` scope.
     * 
     * @param xIdempotencyKey Prevents duplicate reversals from being created.
     * @param accountID The Moov account ID.
     * @param transferID The transfer ID to reverse.
     * @param createReversal 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public CreateReversalResponse createReversal(
            String xIdempotencyKey, String accountID,
            String transferID, Optional<? extends CreateReversal> createReversal) throws Exception {
        CreateReversalRequest request =
            CreateReversalRequest
                .builder()
                .xIdempotencyKey(xIdempotencyKey)
                .accountID(accountID)
                .transferID(transferID)
                .createReversal(createReversal)
                .build();
        RequestOperation<CreateReversalRequest, CreateReversalResponse> operation
              = new CreateReversalOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

}
