/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk;

import static io.moov.sdk.operations.Operations.RequestOperation;

import io.moov.sdk.models.components.CreateTerminalApplication;
import io.moov.sdk.models.components.TerminalApplicationVersion;
import io.moov.sdk.models.operations.CreateTerminalApplicationRequestBuilder;
import io.moov.sdk.models.operations.CreateTerminalApplicationResponse;
import io.moov.sdk.models.operations.CreateTerminalApplicationVersionRequest;
import io.moov.sdk.models.operations.CreateTerminalApplicationVersionRequestBuilder;
import io.moov.sdk.models.operations.CreateTerminalApplicationVersionResponse;
import io.moov.sdk.models.operations.DeleteTerminalApplicationRequest;
import io.moov.sdk.models.operations.DeleteTerminalApplicationRequestBuilder;
import io.moov.sdk.models.operations.DeleteTerminalApplicationResponse;
import io.moov.sdk.models.operations.GetTerminalApplicationRequest;
import io.moov.sdk.models.operations.GetTerminalApplicationRequestBuilder;
import io.moov.sdk.models.operations.GetTerminalApplicationResponse;
import io.moov.sdk.models.operations.ListTerminalApplicationsRequest;
import io.moov.sdk.models.operations.ListTerminalApplicationsRequestBuilder;
import io.moov.sdk.models.operations.ListTerminalApplicationsResponse;
import io.moov.sdk.operations.CreateTerminalApplicationOperation;
import io.moov.sdk.operations.CreateTerminalApplicationVersionOperation;
import io.moov.sdk.operations.DeleteTerminalApplicationOperation;
import io.moov.sdk.operations.GetTerminalApplicationOperation;
import io.moov.sdk.operations.ListTerminalApplicationsOperation;
import java.lang.Exception;
import java.lang.String;


public class TerminalApplications {
    private final SDKConfiguration sdkConfiguration;

    TerminalApplications(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    /**
     * Create a new terminal application.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/terminal-applications.write` scope.
     * 
     * @return The call builder
     */
    public CreateTerminalApplicationRequestBuilder create() {
        return new CreateTerminalApplicationRequestBuilder(sdkConfiguration);
    }

    /**
     * Create a new terminal application.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/terminal-applications.write` scope.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public CreateTerminalApplicationResponse create(CreateTerminalApplication request) throws Exception {
        RequestOperation<CreateTerminalApplication, CreateTerminalApplicationResponse> operation
              = new CreateTerminalApplicationOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * List all the terminal applications for a Moov Account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/terminal-applications.read` scope.
     * 
     * @return The call builder
     */
    public ListTerminalApplicationsRequestBuilder list() {
        return new ListTerminalApplicationsRequestBuilder(sdkConfiguration);
    }

    /**
     * List all the terminal applications for a Moov Account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/terminal-applications.read` scope.
     * 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListTerminalApplicationsResponse listDirect() throws Exception {
        ListTerminalApplicationsRequest request =
            ListTerminalApplicationsRequest
                .builder()
                .build();
        RequestOperation<ListTerminalApplicationsRequest, ListTerminalApplicationsResponse> operation
              = new ListTerminalApplicationsOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Fetch a specific terminal application.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/terminal-applications.read` scope.
     * 
     * @return The call builder
     */
    public GetTerminalApplicationRequestBuilder get() {
        return new GetTerminalApplicationRequestBuilder(sdkConfiguration);
    }

    /**
     * Fetch a specific terminal application.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/terminal-applications.read` scope.
     * 
     * @param terminalApplicationID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetTerminalApplicationResponse get(String terminalApplicationID) throws Exception {
        GetTerminalApplicationRequest request =
            GetTerminalApplicationRequest
                .builder()
                .terminalApplicationID(terminalApplicationID)
                .build();
        RequestOperation<GetTerminalApplicationRequest, GetTerminalApplicationResponse> operation
              = new GetTerminalApplicationOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Delete a specific terminal application.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/terminal-applications.write` scope.
     * 
     * @return The call builder
     */
    public DeleteTerminalApplicationRequestBuilder delete() {
        return new DeleteTerminalApplicationRequestBuilder(sdkConfiguration);
    }

    /**
     * Delete a specific terminal application.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/terminal-applications.write` scope.
     * 
     * @param terminalApplicationID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public DeleteTerminalApplicationResponse delete(String terminalApplicationID) throws Exception {
        DeleteTerminalApplicationRequest request =
            DeleteTerminalApplicationRequest
                .builder()
                .terminalApplicationID(terminalApplicationID)
                .build();
        RequestOperation<DeleteTerminalApplicationRequest, DeleteTerminalApplicationResponse> operation
              = new DeleteTerminalApplicationOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Register a new version of a terminal application. For Android applications, this is used to register a new version code of the application.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/terminal-applications.write` scope.
     * 
     * @return The call builder
     */
    public CreateTerminalApplicationVersionRequestBuilder createVersion() {
        return new CreateTerminalApplicationVersionRequestBuilder(sdkConfiguration);
    }

    /**
     * Register a new version of a terminal application. For Android applications, this is used to register a new version code of the application.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/terminal-applications.write` scope.
     * 
     * @param terminalApplicationID 
     * @param terminalApplicationVersion Describes a terminal application version.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public CreateTerminalApplicationVersionResponse createVersion(String terminalApplicationID, TerminalApplicationVersion terminalApplicationVersion) throws Exception {
        CreateTerminalApplicationVersionRequest request =
            CreateTerminalApplicationVersionRequest
                .builder()
                .terminalApplicationID(terminalApplicationID)
                .terminalApplicationVersion(terminalApplicationVersion)
                .build();
        RequestOperation<CreateTerminalApplicationVersionRequest, CreateTerminalApplicationVersionResponse> operation
              = new CreateTerminalApplicationVersionOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

}
