/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk;

import static io.moov.sdk.operations.Operations.RequestOperation;

import io.moov.sdk.models.components.CreateSweepConfig;
import io.moov.sdk.models.components.PatchSweepConfig;
import io.moov.sdk.models.operations.CreateSweepConfigRequest;
import io.moov.sdk.models.operations.CreateSweepConfigRequestBuilder;
import io.moov.sdk.models.operations.CreateSweepConfigResponse;
import io.moov.sdk.models.operations.GetSweepConfigRequest;
import io.moov.sdk.models.operations.GetSweepConfigRequestBuilder;
import io.moov.sdk.models.operations.GetSweepConfigResponse;
import io.moov.sdk.models.operations.GetSweepRequest;
import io.moov.sdk.models.operations.GetSweepRequestBuilder;
import io.moov.sdk.models.operations.GetSweepResponse;
import io.moov.sdk.models.operations.ListSweepConfigsRequest;
import io.moov.sdk.models.operations.ListSweepConfigsRequestBuilder;
import io.moov.sdk.models.operations.ListSweepConfigsResponse;
import io.moov.sdk.models.operations.ListSweepsRequest;
import io.moov.sdk.models.operations.ListSweepsRequestBuilder;
import io.moov.sdk.models.operations.ListSweepsResponse;
import io.moov.sdk.models.operations.UpdateSweepConfigRequest;
import io.moov.sdk.models.operations.UpdateSweepConfigRequestBuilder;
import io.moov.sdk.models.operations.UpdateSweepConfigResponse;
import io.moov.sdk.operations.CreateSweepConfigOperation;
import io.moov.sdk.operations.GetSweepConfigOperation;
import io.moov.sdk.operations.GetSweepOperation;
import io.moov.sdk.operations.ListSweepConfigsOperation;
import io.moov.sdk.operations.ListSweepsOperation;
import io.moov.sdk.operations.UpdateSweepConfigOperation;
import java.lang.Exception;
import java.lang.String;


public class Sweeps {
    private final SDKConfiguration sdkConfiguration;

    Sweeps(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    /**
     * Create a sweep config for a wallet.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/wallets.write` scope.
     * 
     * @return The call builder
     */
    public CreateSweepConfigRequestBuilder createConfig() {
        return new CreateSweepConfigRequestBuilder(sdkConfiguration);
    }

    /**
     * Create a sweep config for a wallet.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/wallets.write` scope.
     * 
     * @param accountID 
     * @param createSweepConfig 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public CreateSweepConfigResponse createConfig(String accountID, CreateSweepConfig createSweepConfig) throws Exception {
        CreateSweepConfigRequest request =
            CreateSweepConfigRequest
                .builder()
                .accountID(accountID)
                .createSweepConfig(createSweepConfig)
                .build();
        RequestOperation<CreateSweepConfigRequest, CreateSweepConfigResponse> operation
              = new CreateSweepConfigOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * List sweep configs associated with an account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/wallets.read` scope.
     * 
     * @return The call builder
     */
    public ListSweepConfigsRequestBuilder listConfigs() {
        return new ListSweepConfigsRequestBuilder(sdkConfiguration);
    }

    /**
     * List sweep configs associated with an account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/wallets.read` scope.
     * 
     * @param accountID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListSweepConfigsResponse listConfigs(String accountID) throws Exception {
        ListSweepConfigsRequest request =
            ListSweepConfigsRequest
                .builder()
                .accountID(accountID)
                .build();
        RequestOperation<ListSweepConfigsRequest, ListSweepConfigsResponse> operation
              = new ListSweepConfigsOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Get a sweep config associated with a wallet.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/wallets.read` scope.
     * 
     * @return The call builder
     */
    public GetSweepConfigRequestBuilder getConfig() {
        return new GetSweepConfigRequestBuilder(sdkConfiguration);
    }

    /**
     * Get a sweep config associated with a wallet.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/wallets.read` scope.
     * 
     * @param accountID 
     * @param sweepConfigID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetSweepConfigResponse getConfig(String accountID, String sweepConfigID) throws Exception {
        GetSweepConfigRequest request =
            GetSweepConfigRequest
                .builder()
                .accountID(accountID)
                .sweepConfigID(sweepConfigID)
                .build();
        RequestOperation<GetSweepConfigRequest, GetSweepConfigResponse> operation
              = new GetSweepConfigOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Update settings on a sweep config.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/wallets.write` scope.
     * 
     * @return The call builder
     */
    public UpdateSweepConfigRequestBuilder updateConfig() {
        return new UpdateSweepConfigRequestBuilder(sdkConfiguration);
    }

    /**
     * Update settings on a sweep config.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/wallets.write` scope.
     * 
     * @param accountID 
     * @param sweepConfigID 
     * @param patchSweepConfig 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public UpdateSweepConfigResponse updateConfig(
            String accountID, String sweepConfigID,
            PatchSweepConfig patchSweepConfig) throws Exception {
        UpdateSweepConfigRequest request =
            UpdateSweepConfigRequest
                .builder()
                .accountID(accountID)
                .sweepConfigID(sweepConfigID)
                .patchSweepConfig(patchSweepConfig)
                .build();
        RequestOperation<UpdateSweepConfigRequest, UpdateSweepConfigResponse> operation
              = new UpdateSweepConfigOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * List sweeps associated with a wallet.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/wallets.read` scope.
     * 
     * @return The call builder
     */
    public ListSweepsRequestBuilder list() {
        return new ListSweepsRequestBuilder(sdkConfiguration);
    }

    /**
     * List sweeps associated with a wallet.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/wallets.read` scope.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListSweepsResponse list(ListSweepsRequest request) throws Exception {
        RequestOperation<ListSweepsRequest, ListSweepsResponse> operation
              = new ListSweepsOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Get details on a specific sweep.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/wallets.read` scope.
     * 
     * @return The call builder
     */
    public GetSweepRequestBuilder get() {
        return new GetSweepRequestBuilder(sdkConfiguration);
    }

    /**
     * Get details on a specific sweep.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/wallets.read` scope.
     * 
     * @param accountID 
     * @param walletID 
     * @param sweepID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetSweepResponse get(
            String accountID, String walletID,
            String sweepID) throws Exception {
        GetSweepRequest request =
            GetSweepRequest
                .builder()
                .accountID(accountID)
                .walletID(walletID)
                .sweepID(sweepID)
                .build();
        RequestOperation<GetSweepRequest, GetSweepResponse> operation
              = new GetSweepOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

}
