/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk;

import static io.moov.sdk.operations.Operations.RequestOperation;

import io.moov.sdk.models.components.CreateTicket;
import io.moov.sdk.models.components.TicketStatus;
import io.moov.sdk.models.components.UpdateTicket;
import io.moov.sdk.models.operations.CreateTicketRequest;
import io.moov.sdk.models.operations.CreateTicketRequestBuilder;
import io.moov.sdk.models.operations.CreateTicketResponse;
import io.moov.sdk.models.operations.GetTicketRequest;
import io.moov.sdk.models.operations.GetTicketRequestBuilder;
import io.moov.sdk.models.operations.GetTicketResponse;
import io.moov.sdk.models.operations.ListTicketMessagesRequest;
import io.moov.sdk.models.operations.ListTicketMessagesRequestBuilder;
import io.moov.sdk.models.operations.ListTicketMessagesResponse;
import io.moov.sdk.models.operations.ListTicketsRequest;
import io.moov.sdk.models.operations.ListTicketsRequestBuilder;
import io.moov.sdk.models.operations.ListTicketsResponse;
import io.moov.sdk.models.operations.UpdateTicketRequest;
import io.moov.sdk.models.operations.UpdateTicketRequestBuilder;
import io.moov.sdk.models.operations.UpdateTicketResponse;
import io.moov.sdk.operations.CreateTicketOperation;
import io.moov.sdk.operations.GetTicketOperation;
import io.moov.sdk.operations.ListTicketMessagesOperation;
import io.moov.sdk.operations.ListTicketsOperation;
import io.moov.sdk.operations.UpdateTicketOperation;
import java.lang.Exception;
import java.lang.Long;
import java.lang.String;
import java.util.Optional;


public class Support {
    private final SDKConfiguration sdkConfiguration;

    Support(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    /**
     * Create a support ticket for a Moov account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/tickets.write` scope.
     * 
     * @return The call builder
     */
    public CreateTicketRequestBuilder createTicket() {
        return new CreateTicketRequestBuilder(sdkConfiguration);
    }

    /**
     * Create a support ticket for a Moov account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/tickets.write` scope.
     * 
     * @param accountID 
     * @param createTicket Request to create a new support ticket.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public CreateTicketResponse createTicket(String accountID, CreateTicket createTicket) throws Exception {
        CreateTicketRequest request =
            CreateTicketRequest
                .builder()
                .accountID(accountID)
                .createTicket(createTicket)
                .build();
        RequestOperation<CreateTicketRequest, CreateTicketResponse> operation
              = new CreateTicketOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * List all the support tickets created under a Moov account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/tickets.read` scope.
     * 
     * @return The call builder
     */
    public ListTicketsRequestBuilder listTickets() {
        return new ListTicketsRequestBuilder(sdkConfiguration);
    }

    /**
     * List all the support tickets created under a Moov account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/tickets.read` scope.
     * 
     * @param accountID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListTicketsResponse listTickets(String accountID) throws Exception {
        return listTickets(Optional.empty(), Optional.empty(), Optional.empty(),
            accountID);
    }

    /**
     * List all the support tickets created under a Moov account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/tickets.read` scope.
     * 
     * @param cursor 
     * @param count 
     * @param status 
     * @param accountID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListTicketsResponse listTickets(
            Optional<String> cursor, Optional<Long> count,
            Optional<? extends TicketStatus> status, String accountID) throws Exception {
        ListTicketsRequest request =
            ListTicketsRequest
                .builder()
                .cursor(cursor)
                .count(count)
                .status(status)
                .accountID(accountID)
                .build();
        RequestOperation<ListTicketsRequest, ListTicketsResponse> operation
              = new ListTicketsOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Retrieve a support ticket by ID.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/tickets.read` scope.
     * 
     * @return The call builder
     */
    public GetTicketRequestBuilder getTicket() {
        return new GetTicketRequestBuilder(sdkConfiguration);
    }

    /**
     * Retrieve a support ticket by ID.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/tickets.read` scope.
     * 
     * @param accountID 
     * @param ticketID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetTicketResponse getTicket(String accountID, String ticketID) throws Exception {
        GetTicketRequest request =
            GetTicketRequest
                .builder()
                .accountID(accountID)
                .ticketID(ticketID)
                .build();
        RequestOperation<GetTicketRequest, GetTicketResponse> operation
              = new GetTicketOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Updates a support ticket.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/tickets.write` scope.
     * 
     * @return The call builder
     */
    public UpdateTicketRequestBuilder updateTicket() {
        return new UpdateTicketRequestBuilder(sdkConfiguration);
    }

    /**
     * Updates a support ticket.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/tickets.write` scope.
     * 
     * @param accountID 
     * @param ticketID 
     * @param updateTicket Request to update a support ticket.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public UpdateTicketResponse updateTicket(
            String accountID, String ticketID,
            UpdateTicket updateTicket) throws Exception {
        UpdateTicketRequest request =
            UpdateTicketRequest
                .builder()
                .accountID(accountID)
                .ticketID(ticketID)
                .updateTicket(updateTicket)
                .build();
        RequestOperation<UpdateTicketRequest, UpdateTicketResponse> operation
              = new UpdateTicketOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * List all the messages for a support ticket.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/tickets.read` scope.
     * 
     * @return The call builder
     */
    public ListTicketMessagesRequestBuilder listTicketMessages() {
        return new ListTicketMessagesRequestBuilder(sdkConfiguration);
    }

    /**
     * List all the messages for a support ticket.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/tickets.read` scope.
     * 
     * @param accountID 
     * @param ticketID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListTicketMessagesResponse listTicketMessages(String accountID, String ticketID) throws Exception {
        ListTicketMessagesRequest request =
            ListTicketMessagesRequest
                .builder()
                .accountID(accountID)
                .ticketID(ticketID)
                .build();
        RequestOperation<ListTicketMessagesRequest, ListTicketMessagesResponse> operation
              = new ListTicketMessagesOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

}
