/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk;

import static io.moov.sdk.operations.Operations.RequestOperation;

import io.moov.sdk.models.components.UpsertSchedule;
import io.moov.sdk.models.operations.CancelScheduleRequest;
import io.moov.sdk.models.operations.CancelScheduleRequestBuilder;
import io.moov.sdk.models.operations.CancelScheduleResponse;
import io.moov.sdk.models.operations.CreateScheduleRequest;
import io.moov.sdk.models.operations.CreateScheduleRequestBuilder;
import io.moov.sdk.models.operations.CreateScheduleResponse;
import io.moov.sdk.models.operations.GetScheduledOccurrenceRequest;
import io.moov.sdk.models.operations.GetScheduledOccurrenceRequestBuilder;
import io.moov.sdk.models.operations.GetScheduledOccurrenceResponse;
import io.moov.sdk.models.operations.GetSchedulesRequest;
import io.moov.sdk.models.operations.GetSchedulesRequestBuilder;
import io.moov.sdk.models.operations.GetSchedulesResponse;
import io.moov.sdk.models.operations.Hydrate;
import io.moov.sdk.models.operations.ListSchedulesRequest;
import io.moov.sdk.models.operations.ListSchedulesRequestBuilder;
import io.moov.sdk.models.operations.ListSchedulesResponse;
import io.moov.sdk.models.operations.UpdateScheduleRequest;
import io.moov.sdk.models.operations.UpdateScheduleRequestBuilder;
import io.moov.sdk.models.operations.UpdateScheduleResponse;
import io.moov.sdk.operations.CancelScheduleOperation;
import io.moov.sdk.operations.CreateScheduleOperation;
import io.moov.sdk.operations.GetScheduledOccurrenceOperation;
import io.moov.sdk.operations.GetSchedulesOperation;
import io.moov.sdk.operations.ListSchedulesOperation;
import io.moov.sdk.operations.UpdateScheduleOperation;
import java.lang.Exception;
import java.lang.Long;
import java.lang.String;
import java.util.Optional;


public class Scheduling {
    private final SDKConfiguration sdkConfiguration;

    Scheduling(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    /**
     * Describes the schedule to create or modify.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.write` scope.
     * 
     * @return The call builder
     */
    public CreateScheduleRequestBuilder create() {
        return new CreateScheduleRequestBuilder(sdkConfiguration);
    }

    /**
     * Describes the schedule to create or modify.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.write` scope.
     * 
     * @param accountID 
     * @param upsertSchedule 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public CreateScheduleResponse create(String accountID, UpsertSchedule upsertSchedule) throws Exception {
        CreateScheduleRequest request =
            CreateScheduleRequest
                .builder()
                .accountID(accountID)
                .upsertSchedule(upsertSchedule)
                .build();
        RequestOperation<CreateScheduleRequest, CreateScheduleResponse> operation
              = new CreateScheduleOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Describes a list of schedules associated with an account. Append the `hydrate=accounts` query parameter to include partial account details in the response.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.read` scope.
     * 
     * @return The call builder
     */
    public ListSchedulesRequestBuilder list() {
        return new ListSchedulesRequestBuilder(sdkConfiguration);
    }

    /**
     * Describes a list of schedules associated with an account. Append the `hydrate=accounts` query parameter to include partial account details in the response.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.read` scope.
     * 
     * @param accountID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListSchedulesResponse list(String accountID) throws Exception {
        return list(Optional.empty(), Optional.empty(), Optional.empty(),
            accountID);
    }

    /**
     * Describes a list of schedules associated with an account. Append the `hydrate=accounts` query parameter to include partial account details in the response.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.read` scope.
     * 
     * @param skip 
     * @param count 
     * @param hydrate 
     * @param accountID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListSchedulesResponse list(
            Optional<Long> skip, Optional<Long> count,
            Optional<? extends Hydrate> hydrate, String accountID) throws Exception {
        ListSchedulesRequest request =
            ListSchedulesRequest
                .builder()
                .skip(skip)
                .count(count)
                .hydrate(hydrate)
                .accountID(accountID)
                .build();
        RequestOperation<ListSchedulesRequest, ListSchedulesResponse> operation
              = new ListSchedulesOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Describes the schedule to modify.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.write` scope.
     * 
     * @return The call builder
     */
    public UpdateScheduleRequestBuilder update() {
        return new UpdateScheduleRequestBuilder(sdkConfiguration);
    }

    /**
     * Describes the schedule to modify.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.write` scope.
     * 
     * @param accountID 
     * @param scheduleID 
     * @param upsertSchedule 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public UpdateScheduleResponse update(
            String accountID, String scheduleID,
            UpsertSchedule upsertSchedule) throws Exception {
        UpdateScheduleRequest request =
            UpdateScheduleRequest
                .builder()
                .accountID(accountID)
                .scheduleID(scheduleID)
                .upsertSchedule(upsertSchedule)
                .build();
        RequestOperation<UpdateScheduleRequest, UpdateScheduleResponse> operation
              = new UpdateScheduleOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Describes a schedule associated with an account. Requires at least 1 occurrence or recurTransfer to be specified.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.read` scope.
     * 
     * @return The call builder
     */
    public GetSchedulesRequestBuilder get() {
        return new GetSchedulesRequestBuilder(sdkConfiguration);
    }

    /**
     * Describes a schedule associated with an account. Requires at least 1 occurrence or recurTransfer to be specified.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.read` scope.
     * 
     * @param accountID 
     * @param scheduleID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetSchedulesResponse get(String accountID, String scheduleID) throws Exception {
        GetSchedulesRequest request =
            GetSchedulesRequest
                .builder()
                .accountID(accountID)
                .scheduleID(scheduleID)
                .build();
        RequestOperation<GetSchedulesRequest, GetSchedulesResponse> operation
              = new GetSchedulesOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Describes the schedule to cancel.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.write` scope.
     * 
     * @return The call builder
     */
    public CancelScheduleRequestBuilder cancel() {
        return new CancelScheduleRequestBuilder(sdkConfiguration);
    }

    /**
     * Describes the schedule to cancel.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.write` scope.
     * 
     * @param accountID 
     * @param scheduleID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public CancelScheduleResponse cancel(String accountID, String scheduleID) throws Exception {
        CancelScheduleRequest request =
            CancelScheduleRequest
                .builder()
                .accountID(accountID)
                .scheduleID(scheduleID)
                .build();
        RequestOperation<CancelScheduleRequest, CancelScheduleResponse> operation
              = new CancelScheduleOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Gets a specific occurrence.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.read` scope.
     * 
     * @return The call builder
     */
    public GetScheduledOccurrenceRequestBuilder getOccurrance() {
        return new GetScheduledOccurrenceRequestBuilder(sdkConfiguration);
    }

    /**
     * Gets a specific occurrence.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.read` scope.
     * 
     * @param accountID 
     * @param scheduleID 
     * @param occurrenceFilter Allows the specification of additional filters beyond the UUID.
     *         
     *         Specifying a UUID string returns the exact occurrence.
     *         Specifying a RFC 3339 timestamp returns the latest occurrence at or before that timestamp.
     *         Specifying `latest` returns the latest occurrence at or before now.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetScheduledOccurrenceResponse getOccurrance(
            String accountID, String scheduleID,
            String occurrenceFilter) throws Exception {
        GetScheduledOccurrenceRequest request =
            GetScheduledOccurrenceRequest
                .builder()
                .accountID(accountID)
                .scheduleID(scheduleID)
                .occurrenceFilter(occurrenceFilter)
                .build();
        RequestOperation<GetScheduledOccurrenceRequest, GetScheduledOccurrenceResponse> operation
              = new GetScheduledOccurrenceOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

}
