/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk;

import static io.moov.sdk.operations.Operations.RequestOperation;

import io.moov.sdk.models.components.CreateRepresentative;
import io.moov.sdk.models.components.UpdateRepresentative;
import io.moov.sdk.models.operations.CreateRepresentativeRequest;
import io.moov.sdk.models.operations.CreateRepresentativeRequestBuilder;
import io.moov.sdk.models.operations.CreateRepresentativeResponse;
import io.moov.sdk.models.operations.DeleteRepresentativeRequest;
import io.moov.sdk.models.operations.DeleteRepresentativeRequestBuilder;
import io.moov.sdk.models.operations.DeleteRepresentativeResponse;
import io.moov.sdk.models.operations.GetRepresentativeRequest;
import io.moov.sdk.models.operations.GetRepresentativeRequestBuilder;
import io.moov.sdk.models.operations.GetRepresentativeResponse;
import io.moov.sdk.models.operations.ListRepresentativesRequest;
import io.moov.sdk.models.operations.ListRepresentativesRequestBuilder;
import io.moov.sdk.models.operations.ListRepresentativesResponse;
import io.moov.sdk.models.operations.UpdateRepresentativeRequest;
import io.moov.sdk.models.operations.UpdateRepresentativeRequestBuilder;
import io.moov.sdk.models.operations.UpdateRepresentativeResponse;
import io.moov.sdk.operations.CreateRepresentativeOperation;
import io.moov.sdk.operations.DeleteRepresentativeOperation;
import io.moov.sdk.operations.GetRepresentativeOperation;
import io.moov.sdk.operations.ListRepresentativesOperation;
import io.moov.sdk.operations.UpdateRepresentativeOperation;
import java.lang.Exception;
import java.lang.String;


public class Representatives {
    private final SDKConfiguration sdkConfiguration;

    Representatives(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    /**
     * Moov accounts associated with businesses require information regarding individuals who represent the business. 
     * You can provide this information by creating a representative. Each account is allowed a maximum of 7 representatives. 
     * Read our [business representatives guide](https://docs.moov.io/guides/accounts/requirements/business-representatives/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/representatives.write` scope.
     * 
     * @return The call builder
     */
    public CreateRepresentativeRequestBuilder create() {
        return new CreateRepresentativeRequestBuilder(sdkConfiguration);
    }

    /**
     * Moov accounts associated with businesses require information regarding individuals who represent the business. 
     * You can provide this information by creating a representative. Each account is allowed a maximum of 7 representatives. 
     * Read our [business representatives guide](https://docs.moov.io/guides/accounts/requirements/business-representatives/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/representatives.write` scope.
     * 
     * @param accountID ID of the account.
     * @param createRepresentative Describes a business representative to create.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public CreateRepresentativeResponse create(String accountID, CreateRepresentative createRepresentative) throws Exception {
        CreateRepresentativeRequest request =
            CreateRepresentativeRequest
                .builder()
                .accountID(accountID)
                .createRepresentative(createRepresentative)
                .build();
        RequestOperation<CreateRepresentativeRequest, CreateRepresentativeResponse> operation
              = new CreateRepresentativeOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * A Moov account may have multiple representatives depending on the associated business's ownership and management structure. 
     * You can use this method to list all the representatives for a given Moov account. 
     * Note that Moov accounts associated with an individual do not have representatives. 
     * Read our [business representatives guide](https://docs.moov.io/guides/accounts/requirements/business-representatives/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/representatives.read` scope.
     * 
     * @return The call builder
     */
    public ListRepresentativesRequestBuilder list() {
        return new ListRepresentativesRequestBuilder(sdkConfiguration);
    }

    /**
     * A Moov account may have multiple representatives depending on the associated business's ownership and management structure. 
     * You can use this method to list all the representatives for a given Moov account. 
     * Note that Moov accounts associated with an individual do not have representatives. 
     * Read our [business representatives guide](https://docs.moov.io/guides/accounts/requirements/business-representatives/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/representatives.read` scope.
     * 
     * @param accountID ID of the account.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListRepresentativesResponse list(String accountID) throws Exception {
        ListRepresentativesRequest request =
            ListRepresentativesRequest
                .builder()
                .accountID(accountID)
                .build();
        RequestOperation<ListRepresentativesRequest, ListRepresentativesResponse> operation
              = new ListRepresentativesOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Deletes a business representative associated with a Moov account. Read our [business representatives guide](https://docs.moov.io/guides/accounts/requirements/business-representatives/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/representatives.write` scope.
     * 
     * @return The call builder
     */
    public DeleteRepresentativeRequestBuilder delete() {
        return new DeleteRepresentativeRequestBuilder(sdkConfiguration);
    }

    /**
     * Deletes a business representative associated with a Moov account. Read our [business representatives guide](https://docs.moov.io/guides/accounts/requirements/business-representatives/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/representatives.write` scope.
     * 
     * @param accountID ID of the account.
     * @param representativeID ID of the representative.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public DeleteRepresentativeResponse delete(String accountID, String representativeID) throws Exception {
        DeleteRepresentativeRequest request =
            DeleteRepresentativeRequest
                .builder()
                .accountID(accountID)
                .representativeID(representativeID)
                .build();
        RequestOperation<DeleteRepresentativeRequest, DeleteRepresentativeResponse> operation
              = new DeleteRepresentativeOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Retrieve a specific representative associated with a given Moov account. Read our [business representatives guide](https://docs.moov.io/guides/accounts/requirements/business-representatives/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/representatives.read` scope.
     * 
     * @return The call builder
     */
    public GetRepresentativeRequestBuilder get() {
        return new GetRepresentativeRequestBuilder(sdkConfiguration);
    }

    /**
     * Retrieve a specific representative associated with a given Moov account. Read our [business representatives guide](https://docs.moov.io/guides/accounts/requirements/business-representatives/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/representatives.read` scope.
     * 
     * @param accountID ID of the account.
     * @param representativeID ID of the representative.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetRepresentativeResponse get(String accountID, String representativeID) throws Exception {
        GetRepresentativeRequest request =
            GetRepresentativeRequest
                .builder()
                .accountID(accountID)
                .representativeID(representativeID)
                .build();
        RequestOperation<GetRepresentativeRequest, GetRepresentativeResponse> operation
              = new GetRepresentativeOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * If a representative's information has changed you can patch the information associated with a specific representative ID. 
     * Read our [business representatives guide](https://docs.moov.io/guides/accounts/requirements/business-representatives/) to learn more.
     * 
     * <p>When **can** profile data be updated:
     * 
     * <p>- For unverified representatives, all profile data can be edited.
     * - During the verification process, missing or incomplete profile data can be edited.
     * - Verified representatives can only add missing profile data.
     * 
     * <p>When **can't** profile data be updated:
     * 
     * <p>- Verified representatives cannot change any existing profile data.
     * 
     * <p>If you need to update information in a locked state, please contact Moov support.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/representatives.write` scope.
     * 
     * @return The call builder
     */
    public UpdateRepresentativeRequestBuilder update() {
        return new UpdateRepresentativeRequestBuilder(sdkConfiguration);
    }

    /**
     * If a representative's information has changed you can patch the information associated with a specific representative ID. 
     * Read our [business representatives guide](https://docs.moov.io/guides/accounts/requirements/business-representatives/) to learn more.
     * 
     * <p>When **can** profile data be updated:
     * 
     * <p>- For unverified representatives, all profile data can be edited.
     * - During the verification process, missing or incomplete profile data can be edited.
     * - Verified representatives can only add missing profile data.
     * 
     * <p>When **can't** profile data be updated:
     * 
     * <p>- Verified representatives cannot change any existing profile data.
     * 
     * <p>If you need to update information in a locked state, please contact Moov support.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/representatives.write` scope.
     * 
     * @param accountID ID of the account.
     * @param representativeID ID of the representative.
     * @param updateRepresentative 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public UpdateRepresentativeResponse update(
            String accountID, String representativeID,
            UpdateRepresentative updateRepresentative) throws Exception {
        UpdateRepresentativeRequest request =
            UpdateRepresentativeRequest
                .builder()
                .accountID(accountID)
                .representativeID(representativeID)
                .updateRepresentative(updateRepresentative)
                .build();
        RequestOperation<UpdateRepresentativeRequest, UpdateRepresentativeResponse> operation
              = new UpdateRepresentativeOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

}
