/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk;

import static io.moov.sdk.operations.Operations.RequestOperation;

import io.moov.sdk.models.components.ReceiptRequest;
import io.moov.sdk.models.operations.CreateReceiptsRequestBuilder;
import io.moov.sdk.models.operations.CreateReceiptsResponse;
import io.moov.sdk.models.operations.ListReceiptsRequest;
import io.moov.sdk.models.operations.ListReceiptsRequestBuilder;
import io.moov.sdk.models.operations.ListReceiptsResponse;
import io.moov.sdk.operations.CreateReceiptsOperation;
import io.moov.sdk.operations.ListReceiptsOperation;
import java.lang.Exception;
import java.lang.String;
import java.util.List;


public class Receipts {
    private final SDKConfiguration sdkConfiguration;

    Receipts(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    /**
     * Create receipts for transfers and scheduled transfers.
     * 
     * <p> To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     *  you'll need to specify the `/accounts/{accountID}/transfers.write` scope.
     * 
     * @return The call builder
     */
    public CreateReceiptsRequestBuilder create() {
        return new CreateReceiptsRequestBuilder(sdkConfiguration);
    }

    /**
     * Create receipts for transfers and scheduled transfers.
     * 
     * <p> To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     *  you'll need to specify the `/accounts/{accountID}/transfers.write` scope.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public CreateReceiptsResponse create(List<ReceiptRequest> request) throws Exception {
        RequestOperation<List<ReceiptRequest>, CreateReceiptsResponse> operation
              = new CreateReceiptsOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * List receipts by transferID, scheduleID, or occurrenceID.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.read` scope.
     * 
     * @return The call builder
     */
    public ListReceiptsRequestBuilder list() {
        return new ListReceiptsRequestBuilder(sdkConfiguration);
    }

    /**
     * List receipts by transferID, scheduleID, or occurrenceID.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.read` scope.
     * 
     * @param id The transfer, schedule, or transfer occurrence ID to filter receipts by.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListReceiptsResponse list(String id) throws Exception {
        ListReceiptsRequest request =
            ListReceiptsRequest
                .builder()
                .id(id)
                .build();
        RequestOperation<ListReceiptsRequest, ListReceiptsResponse> operation
              = new ListReceiptsOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

}
