/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk;

import static io.moov.sdk.operations.Operations.RequestOperation;

import io.moov.sdk.models.components.PaymentMethodType;
import io.moov.sdk.models.operations.GetPaymentMethodRequest;
import io.moov.sdk.models.operations.GetPaymentMethodRequestBuilder;
import io.moov.sdk.models.operations.GetPaymentMethodResponse;
import io.moov.sdk.models.operations.ListPaymentMethodsRequest;
import io.moov.sdk.models.operations.ListPaymentMethodsRequestBuilder;
import io.moov.sdk.models.operations.ListPaymentMethodsResponse;
import io.moov.sdk.operations.GetPaymentMethodOperation;
import io.moov.sdk.operations.ListPaymentMethodsOperation;
import java.lang.Exception;
import java.lang.String;
import java.util.Optional;


public class PaymentMethods {
    private final SDKConfiguration sdkConfiguration;

    PaymentMethods(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    /**
     * Retrieve a list of payment methods associated with a Moov account. Read our [payment methods 
     * guide](https://docs.moov.io/guides/money-movement/payment-methods/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/payment-methods.read` scope.
     * 
     * @return The call builder
     */
    public ListPaymentMethodsRequestBuilder list() {
        return new ListPaymentMethodsRequestBuilder(sdkConfiguration);
    }

    /**
     * Retrieve a list of payment methods associated with a Moov account. Read our [payment methods 
     * guide](https://docs.moov.io/guides/money-movement/payment-methods/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/payment-methods.read` scope.
     * 
     * @param accountID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListPaymentMethodsResponse list(String accountID) throws Exception {
        return list(accountID, Optional.empty(), Optional.empty());
    }

    /**
     * Retrieve a list of payment methods associated with a Moov account. Read our [payment methods 
     * guide](https://docs.moov.io/guides/money-movement/payment-methods/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/payment-methods.read` scope.
     * 
     * @param accountID 
     * @param sourceID Optional parameter to filter the account's payment methods by source ID. 
     *         
     *         A source ID can be a [walletID](https://docs.moov.io/api/sources/wallets/list/), [cardID](https://docs.moov.io/api/sources/cards/list/), 
     *         or [bankAccountID](https://docs.moov.io/api/sources/bank-accounts/list/).
     * @param paymentMethodType The payment method type that represents a payment rail and directionality
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListPaymentMethodsResponse list(
            String accountID, Optional<String> sourceID,
            Optional<? extends PaymentMethodType> paymentMethodType) throws Exception {
        ListPaymentMethodsRequest request =
            ListPaymentMethodsRequest
                .builder()
                .accountID(accountID)
                .sourceID(sourceID)
                .paymentMethodType(paymentMethodType)
                .build();
        RequestOperation<ListPaymentMethodsRequest, ListPaymentMethodsResponse> operation
              = new ListPaymentMethodsOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Get the specified payment method associated with a Moov account. Read our [payment methods guide](https://docs.moov.io/guides/money-movement/payment-methods/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/payment-methods.read` scope.
     * 
     * @return The call builder
     */
    public GetPaymentMethodRequestBuilder get() {
        return new GetPaymentMethodRequestBuilder(sdkConfiguration);
    }

    /**
     * Get the specified payment method associated with a Moov account. Read our [payment methods guide](https://docs.moov.io/guides/money-movement/payment-methods/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/payment-methods.read` scope.
     * 
     * @param accountID 
     * @param paymentMethodID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetPaymentMethodResponse get(String accountID, String paymentMethodID) throws Exception {
        GetPaymentMethodRequest request =
            GetPaymentMethodRequest
                .builder()
                .accountID(accountID)
                .paymentMethodID(paymentMethodID)
                .build();
        RequestOperation<GetPaymentMethodRequest, GetPaymentMethodResponse> operation
              = new GetPaymentMethodOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

}
