/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk;

import static io.moov.sdk.operations.Operations.RequestOperation;

import io.moov.sdk.models.components.CreatePaymentLink;
import io.moov.sdk.models.components.UpdatePaymentLink;
import io.moov.sdk.models.operations.CreatePaymentLinkRequest;
import io.moov.sdk.models.operations.CreatePaymentLinkRequestBuilder;
import io.moov.sdk.models.operations.CreatePaymentLinkResponse;
import io.moov.sdk.models.operations.DisablePaymentLinkRequest;
import io.moov.sdk.models.operations.DisablePaymentLinkRequestBuilder;
import io.moov.sdk.models.operations.DisablePaymentLinkResponse;
import io.moov.sdk.models.operations.GetPaymentLinkQRCodeRequest;
import io.moov.sdk.models.operations.GetPaymentLinkQRCodeRequestBuilder;
import io.moov.sdk.models.operations.GetPaymentLinkQRCodeResponse;
import io.moov.sdk.models.operations.GetPaymentLinkRequest;
import io.moov.sdk.models.operations.GetPaymentLinkRequestBuilder;
import io.moov.sdk.models.operations.GetPaymentLinkResponse;
import io.moov.sdk.models.operations.ListPaymentLinksRequest;
import io.moov.sdk.models.operations.ListPaymentLinksRequestBuilder;
import io.moov.sdk.models.operations.ListPaymentLinksResponse;
import io.moov.sdk.models.operations.UpdatePaymentLinkRequest;
import io.moov.sdk.models.operations.UpdatePaymentLinkRequestBuilder;
import io.moov.sdk.models.operations.UpdatePaymentLinkResponse;
import io.moov.sdk.operations.CreatePaymentLinkOperation;
import io.moov.sdk.operations.DisablePaymentLinkOperation;
import io.moov.sdk.operations.GetPaymentLinkOperation;
import io.moov.sdk.operations.GetPaymentLinkQRCodeOperation;
import io.moov.sdk.operations.ListPaymentLinksOperation;
import io.moov.sdk.operations.UpdatePaymentLinkOperation;
import java.lang.Exception;
import java.lang.String;


public class PaymentLinks {
    private final SDKConfiguration sdkConfiguration;

    PaymentLinks(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    /**
     * Create a payment link that allows an end user to make a payment on Moov's hosted payment link page.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.write` scope.
     * 
     * @return The call builder
     */
    public CreatePaymentLinkRequestBuilder create() {
        return new CreatePaymentLinkRequestBuilder(sdkConfiguration);
    }

    /**
     * Create a payment link that allows an end user to make a payment on Moov's hosted payment link page.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.write` scope.
     * 
     * @param accountID 
     * @param createPaymentLink Request to create a new payment link.
     *         
     *         A payment link must include either `payment` or `payout` details, but not both. For payout payment links,
     *         `maxUses` will automatically be set to 1, as these are intended for a one-time disbursement
     *         to a specific recipient.
     *         
     *         **Note:** The `payout` option is currently under development and is not yet available for general use.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public CreatePaymentLinkResponse create(String accountID, CreatePaymentLink createPaymentLink) throws Exception {
        CreatePaymentLinkRequest request =
            CreatePaymentLinkRequest
                .builder()
                .accountID(accountID)
                .createPaymentLink(createPaymentLink)
                .build();
        RequestOperation<CreatePaymentLinkRequest, CreatePaymentLinkResponse> operation
              = new CreatePaymentLinkOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * List all the payment links created under a Moov account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.read` scope.
     * 
     * @return The call builder
     */
    public ListPaymentLinksRequestBuilder list() {
        return new ListPaymentLinksRequestBuilder(sdkConfiguration);
    }

    /**
     * List all the payment links created under a Moov account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.read` scope.
     * 
     * @param accountID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListPaymentLinksResponse list(String accountID) throws Exception {
        ListPaymentLinksRequest request =
            ListPaymentLinksRequest
                .builder()
                .accountID(accountID)
                .build();
        RequestOperation<ListPaymentLinksRequest, ListPaymentLinksResponse> operation
              = new ListPaymentLinksOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Retrieve a payment link by code.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.read` scope.
     * 
     * @return The call builder
     */
    public GetPaymentLinkRequestBuilder get() {
        return new GetPaymentLinkRequestBuilder(sdkConfiguration);
    }

    /**
     * Retrieve a payment link by code.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.read` scope.
     * 
     * @param accountID 
     * @param paymentLinkCode 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetPaymentLinkResponse get(String accountID, String paymentLinkCode) throws Exception {
        GetPaymentLinkRequest request =
            GetPaymentLinkRequest
                .builder()
                .accountID(accountID)
                .paymentLinkCode(paymentLinkCode)
                .build();
        RequestOperation<GetPaymentLinkRequest, GetPaymentLinkResponse> operation
              = new GetPaymentLinkOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Update a payment link.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.write` scope.
     * 
     * @return The call builder
     */
    public UpdatePaymentLinkRequestBuilder update() {
        return new UpdatePaymentLinkRequestBuilder(sdkConfiguration);
    }

    /**
     * Update a payment link.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.write` scope.
     * 
     * @param accountID 
     * @param paymentLinkCode 
     * @param updatePaymentLink 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public UpdatePaymentLinkResponse update(
            String accountID, String paymentLinkCode,
            UpdatePaymentLink updatePaymentLink) throws Exception {
        UpdatePaymentLinkRequest request =
            UpdatePaymentLinkRequest
                .builder()
                .accountID(accountID)
                .paymentLinkCode(paymentLinkCode)
                .updatePaymentLink(updatePaymentLink)
                .build();
        RequestOperation<UpdatePaymentLinkRequest, UpdatePaymentLinkResponse> operation
              = new UpdatePaymentLinkOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Disable a payment link.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.write` scope.
     * 
     * @return The call builder
     */
    public DisablePaymentLinkRequestBuilder disable() {
        return new DisablePaymentLinkRequestBuilder(sdkConfiguration);
    }

    /**
     * Disable a payment link.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.write` scope.
     * 
     * @param accountID 
     * @param paymentLinkCode 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public DisablePaymentLinkResponse disable(String accountID, String paymentLinkCode) throws Exception {
        DisablePaymentLinkRequest request =
            DisablePaymentLinkRequest
                .builder()
                .accountID(accountID)
                .paymentLinkCode(paymentLinkCode)
                .build();
        RequestOperation<DisablePaymentLinkRequest, DisablePaymentLinkResponse> operation
              = new DisablePaymentLinkOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Retrieve the payment link encoded in a QR code. 
     * 
     * <p>Use the `Accept` header to specify the format of the response. Supported formats are `application/json` and `image/png`.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.write` scope.
     * 
     * @return The call builder
     */
    public GetPaymentLinkQRCodeRequestBuilder getQRCode() {
        return new GetPaymentLinkQRCodeRequestBuilder(sdkConfiguration);
    }

    /**
     * Retrieve the payment link encoded in a QR code. 
     * 
     * <p>Use the `Accept` header to specify the format of the response. Supported formats are `application/json` and `image/png`.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.write` scope.
     * 
     * @param accountID 
     * @param paymentLinkCode 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetPaymentLinkQRCodeResponse getQRCode(String accountID, String paymentLinkCode) throws Exception {
        GetPaymentLinkQRCodeRequest request =
            GetPaymentLinkQRCodeRequest
                .builder()
                .accountID(accountID)
                .paymentLinkCode(paymentLinkCode)
                .build();
        RequestOperation<GetPaymentLinkQRCodeRequest, GetPaymentLinkQRCodeResponse> operation
              = new GetPaymentLinkQRCodeOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

}
