/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk;

import static io.moov.sdk.operations.Operations.RequestOperation;

import io.moov.sdk.models.components.OnboardingInviteRequest;
import io.moov.sdk.models.operations.CreateOnboardingInviteRequestBuilder;
import io.moov.sdk.models.operations.CreateOnboardingInviteResponse;
import io.moov.sdk.models.operations.GetOnboardingInviteRequest;
import io.moov.sdk.models.operations.GetOnboardingInviteRequestBuilder;
import io.moov.sdk.models.operations.GetOnboardingInviteResponse;
import io.moov.sdk.models.operations.ListOnboardingInvitesRequest;
import io.moov.sdk.models.operations.ListOnboardingInvitesRequestBuilder;
import io.moov.sdk.models.operations.ListOnboardingInvitesResponse;
import io.moov.sdk.models.operations.RevokeOnboardingInviteRequest;
import io.moov.sdk.models.operations.RevokeOnboardingInviteRequestBuilder;
import io.moov.sdk.models.operations.RevokeOnboardingInviteResponse;
import io.moov.sdk.operations.CreateOnboardingInviteOperation;
import io.moov.sdk.operations.GetOnboardingInviteOperation;
import io.moov.sdk.operations.ListOnboardingInvitesOperation;
import io.moov.sdk.operations.RevokeOnboardingInviteOperation;
import java.lang.Exception;
import java.lang.String;


public class Onboarding {
    private final SDKConfiguration sdkConfiguration;

    Onboarding(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    /**
     * Create an invitation containing a unique link that allows the recipient to onboard their organization with Moov.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts.write` scope.
     * 
     * @return The call builder
     */
    public CreateOnboardingInviteRequestBuilder createInvite() {
        return new CreateOnboardingInviteRequestBuilder(sdkConfiguration);
    }

    /**
     * Create an invitation containing a unique link that allows the recipient to onboard their organization with Moov.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts.write` scope.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public CreateOnboardingInviteResponse createInvite(OnboardingInviteRequest request) throws Exception {
        RequestOperation<OnboardingInviteRequest, CreateOnboardingInviteResponse> operation
              = new CreateOnboardingInviteOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * List all the onboarding invites created by the caller's account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts.read` scope.
     * 
     * @return The call builder
     */
    public ListOnboardingInvitesRequestBuilder listInvites() {
        return new ListOnboardingInvitesRequestBuilder(sdkConfiguration);
    }

    /**
     * List all the onboarding invites created by the caller's account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts.read` scope.
     * 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListOnboardingInvitesResponse listInvitesDirect() throws Exception {
        ListOnboardingInvitesRequest request =
            ListOnboardingInvitesRequest
                .builder()
                .build();
        RequestOperation<ListOnboardingInvitesRequest, ListOnboardingInvitesResponse> operation
              = new ListOnboardingInvitesOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Retrieve details about an onboarding invite.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts.read` scope.
     * 
     * @return The call builder
     */
    public GetOnboardingInviteRequestBuilder getInvite() {
        return new GetOnboardingInviteRequestBuilder(sdkConfiguration);
    }

    /**
     * Retrieve details about an onboarding invite.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts.read` scope.
     * 
     * @param code 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetOnboardingInviteResponse getInvite(String code) throws Exception {
        GetOnboardingInviteRequest request =
            GetOnboardingInviteRequest
                .builder()
                .code(code)
                .build();
        RequestOperation<GetOnboardingInviteRequest, GetOnboardingInviteResponse> operation
              = new GetOnboardingInviteOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Revoke an onboarding invite, rendering the invitation link unusable.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts.write` scope.
     * 
     * @return The call builder
     */
    public RevokeOnboardingInviteRequestBuilder revokeInvite() {
        return new RevokeOnboardingInviteRequestBuilder(sdkConfiguration);
    }

    /**
     * Revoke an onboarding invite, rendering the invitation link unusable.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts.write` scope.
     * 
     * @param code 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public RevokeOnboardingInviteResponse revokeInvite(String code) throws Exception {
        RevokeOnboardingInviteRequest request =
            RevokeOnboardingInviteRequest
                .builder()
                .code(code)
                .build();
        RequestOperation<RevokeOnboardingInviteRequest, RevokeOnboardingInviteResponse> operation
              = new RevokeOnboardingInviteOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

}
