/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk;

import io.moov.sdk.utils.HTTPClient;
import io.moov.sdk.utils.Hook.SdkInitData;
import io.moov.sdk.utils.RetryConfig;
import io.moov.sdk.utils.SpeakeasyHTTPClient;
import io.moov.sdk.utils.Utils;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;

/**
 * Moov API: Moov is a platform that enables developers to integrate all aspects of money movement with ease and speed.
 * The Moov API makes it simple for platforms to send, receive, and store money. Our API is based upon REST
 * principles, returns JSON responses, and uses standard HTTP response codes. To learn more about how Moov
 * works at a high level, read our [concepts](https://docs.moov.io/guides/get-started/glossary/) guide.
 */
public class Moov {


    /**
     * SERVERS contains the list of server urls available to the SDK.
     */
    public static final String[] SERVERS = {
        /**
         * Production API host
         */
        "https://api.moov.io",
    };


    private final Accounts accounts;


    private final Adjustments adjustments;


    private final ApplePay applePay;


    private final BankAccounts bankAccounts;


    private final Branding branding;


    private final Capabilities capabilities;


    private final Cards cards;


    private final Disputes disputes;


    private final FeePlans feePlans;


    private final Files files;


    private final PaymentLinks paymentLinks;


    private final PaymentMethods paymentMethods;


    private final Representatives representatives;


    private final Scheduling scheduling;


    private final Sweeps sweeps;


    private final AccountTerminalApplications accountTerminalApplications;


    private final Support support;


    private final Transfers transfers;


    private final Underwriting underwriting;


    private final Wallets wallets;


    private final WalletTransactions walletTransactions;


    private final Avatars avatars;


    private final EndToEndEncryption endToEndEncryption;


    private final EnrichedAddress enrichedAddress;


    private final EnrichedProfile enrichedProfile;


    private final Industries industries;


    private final Institutions institutions;


    private final IssuingTransactions issuingTransactions;


    private final CardIssuing cardIssuing;


    private final Authentication authentication;


    private final Onboarding onboarding;


    private final Ping ping;


    private final Receipts receipts;


    private final TerminalApplications terminalApplications;


    public Accounts accounts() {
        return accounts;
    }


    public Adjustments adjustments() {
        return adjustments;
    }


    public ApplePay applePay() {
        return applePay;
    }


    public BankAccounts bankAccounts() {
        return bankAccounts;
    }


    public Branding branding() {
        return branding;
    }


    public Capabilities capabilities() {
        return capabilities;
    }


    public Cards cards() {
        return cards;
    }


    public Disputes disputes() {
        return disputes;
    }


    public FeePlans feePlans() {
        return feePlans;
    }


    public Files files() {
        return files;
    }


    public PaymentLinks paymentLinks() {
        return paymentLinks;
    }


    public PaymentMethods paymentMethods() {
        return paymentMethods;
    }


    public Representatives representatives() {
        return representatives;
    }


    public Scheduling scheduling() {
        return scheduling;
    }


    public Sweeps sweeps() {
        return sweeps;
    }


    public AccountTerminalApplications accountTerminalApplications() {
        return accountTerminalApplications;
    }


    public Support support() {
        return support;
    }


    public Transfers transfers() {
        return transfers;
    }


    public Underwriting underwriting() {
        return underwriting;
    }


    public Wallets wallets() {
        return wallets;
    }


    public WalletTransactions walletTransactions() {
        return walletTransactions;
    }


    public Avatars avatars() {
        return avatars;
    }


    public EndToEndEncryption endToEndEncryption() {
        return endToEndEncryption;
    }


    public EnrichedAddress enrichedAddress() {
        return enrichedAddress;
    }


    public EnrichedProfile enrichedProfile() {
        return enrichedProfile;
    }


    public Industries industries() {
        return industries;
    }


    public Institutions institutions() {
        return institutions;
    }


    public IssuingTransactions issuingTransactions() {
        return issuingTransactions;
    }


    public CardIssuing cardIssuing() {
        return cardIssuing;
    }


    public Authentication authentication() {
        return authentication;
    }


    public Onboarding onboarding() {
        return onboarding;
    }


    public Ping ping() {
        return ping;
    }


    public Receipts receipts() {
        return receipts;
    }


    public TerminalApplications terminalApplications() {
        return terminalApplications;
    }

    private final SDKConfiguration sdkConfiguration;

    /**
     * The Builder class allows the configuration of a new instance of the SDK.
     */
    public static class Builder {

        private final SDKConfiguration sdkConfiguration = new SDKConfiguration();
        private String serverUrl;
        private String server;
        

        private Builder() {
        }

        /**
         * Allows the default HTTP client to be overridden with a custom implementation.
         *
         * @param client The HTTP client to use for all requests.
         * @return The builder instance.
         */
        public Builder client(HTTPClient client) {
            this.sdkConfiguration.setClient(client);
            return this;
        }
        
        /**
         * Configures the SDK to use the provided security details.
         *
         * @param security The security details to use for all requests. Can be {@code null}.
         * @return The builder instance.
         */
        public Builder security(io.moov.sdk.models.components.Security security) {
            this.sdkConfiguration.setSecuritySource(SecuritySource.of(security));
            return this;
        }

        /**
         * Configures the SDK to use a custom security source.
         *
         * @param securitySource The security source to use for all requests.
         * @return The builder instance.
         */
        public Builder securitySource(SecuritySource securitySource) {
            Utils.checkNotNull(securitySource, "securitySource");
            this.sdkConfiguration.setSecuritySource(securitySource);
            return this;
        }
        
        /**
         * Overrides the default server URL.
         *
         * @param serverUrl The server URL to use for all requests.
         * @return The builder instance.
         */
        public Builder serverURL(String serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        /**
         * Overrides the default server URL  with a templated URL populated with the provided parameters.
         *
         * @param serverUrl The server URL to use for all requests.
         * @param params The parameters to use when templating the URL.
         * @return The builder instance.
         */
        public Builder serverURL(String serverUrl, Map<String, String> params) {
            this.serverUrl = Utils.templateUrl(serverUrl, params);
            return this;
        }
        
        /**
         * Overrides the default server by index.
         *
         * @param serverIdx The server to use for all requests.
         * @return The builder instance.
         */
        public Builder serverIndex(int serverIdx) {
            this.sdkConfiguration.setServerIdx(serverIdx);
            this.serverUrl= SERVERS[serverIdx];
            return this;
        }
        
        /**
         * Overrides the default configuration for retries
         *
         * @param retryConfig The retry configuration to use for all requests.
         * @return The builder instance.
         */
        public Builder retryConfig(RetryConfig retryConfig) {
            this.sdkConfiguration.setRetryConfig(Optional.of(retryConfig));
            return this;
        }

        /**
         * Enables debug logging for HTTP requests and responses, including JSON body content.
         * <p>
         * Convenience method that calls {@link HTTPClient#enableDebugLogging(boolean)}.
         * {@link SpeakeasyHTTPClient} honors this setting. If you are using a custom HTTP client,
         * it is up to the custom client to honor this setting.
         * </p>
         *
         * @param enabled Whether to enable debug logging.
         * @return The builder instance.
         */
        public Builder enableHTTPDebugLogging(boolean enabled) {
            this.sdkConfiguration.client().enableDebugLogging(enabled);
            return this;
        }

        /**
         * Allows setting the xMoovVersion parameter for all supported operations.
         *
         * @param xMoovVersion The value to set.
         * @return The builder instance.
         */
        public Builder xMoovVersion(String xMoovVersion) {
            this.sdkConfiguration.globals.putParam("header", "xMoovVersion", xMoovVersion);
            return this;
        }
        
        // Visible for testing, may be accessed via reflection in tests
        Builder _hooks(io.moov.sdk.utils.Hooks hooks) {
            sdkConfiguration.setHooks(hooks);  
            return this;  
        }
        
        // Visible for testing, may be accessed via reflection in tests
        Builder _hooks(Consumer<? super io.moov.sdk.utils.Hooks> consumer) {
            consumer.accept(sdkConfiguration.hooks());
            return this;    
        }
        
        /**
         * Builds a new instance of the SDK.
         *
         * @return The SDK instance.
         */
        public Moov build() {
            if (serverUrl == null || serverUrl.isBlank()) {
                serverUrl = SERVERS[0];
                sdkConfiguration.setServerIdx(0);
            }
            sdkConfiguration.setServerUrl(serverUrl);
            return new Moov(sdkConfiguration);
        }
    }
    
    /**
     * Get a new instance of the SDK builder to configure a new instance of the SDK.
     *
     * @return The SDK builder instance.
     */
    public static Builder builder() {
        return new Builder();
    }

    private Moov(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.sdkConfiguration.initialize();
        this.accounts = new Accounts(sdkConfiguration);
        this.adjustments = new Adjustments(sdkConfiguration);
        this.applePay = new ApplePay(sdkConfiguration);
        this.bankAccounts = new BankAccounts(sdkConfiguration);
        this.branding = new Branding(sdkConfiguration);
        this.capabilities = new Capabilities(sdkConfiguration);
        this.cards = new Cards(sdkConfiguration);
        this.disputes = new Disputes(sdkConfiguration);
        this.feePlans = new FeePlans(sdkConfiguration);
        this.files = new Files(sdkConfiguration);
        this.paymentLinks = new PaymentLinks(sdkConfiguration);
        this.paymentMethods = new PaymentMethods(sdkConfiguration);
        this.representatives = new Representatives(sdkConfiguration);
        this.scheduling = new Scheduling(sdkConfiguration);
        this.sweeps = new Sweeps(sdkConfiguration);
        this.accountTerminalApplications = new AccountTerminalApplications(sdkConfiguration);
        this.support = new Support(sdkConfiguration);
        this.transfers = new Transfers(sdkConfiguration);
        this.underwriting = new Underwriting(sdkConfiguration);
        this.wallets = new Wallets(sdkConfiguration);
        this.walletTransactions = new WalletTransactions(sdkConfiguration);
        this.avatars = new Avatars(sdkConfiguration);
        this.endToEndEncryption = new EndToEndEncryption(sdkConfiguration);
        this.enrichedAddress = new EnrichedAddress(sdkConfiguration);
        this.enrichedProfile = new EnrichedProfile(sdkConfiguration);
        this.industries = new Industries(sdkConfiguration);
        this.institutions = new Institutions(sdkConfiguration);
        this.issuingTransactions = new IssuingTransactions(sdkConfiguration);
        this.cardIssuing = new CardIssuing(sdkConfiguration);
        this.authentication = new Authentication(sdkConfiguration);
        this.onboarding = new Onboarding(sdkConfiguration);
        this.ping = new Ping(sdkConfiguration);
        this.receipts = new Receipts(sdkConfiguration);
        this.terminalApplications = new TerminalApplications(sdkConfiguration);
        SdkInitData data = this.sdkConfiguration.hooks().sdkInit(
                new SdkInitData(
                        this.sdkConfiguration.resolvedServerUrl(), 
                        this.sdkConfiguration.client()));
        this.sdkConfiguration.setServerUrl(data.baseUrl());
        this.sdkConfiguration.setClient(data.client());
    }
}
