/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk;

import static io.moov.sdk.operations.Operations.RequestOperation;

import io.moov.sdk.models.operations.GetIssuedCardAuthorizationRequest;
import io.moov.sdk.models.operations.GetIssuedCardAuthorizationRequestBuilder;
import io.moov.sdk.models.operations.GetIssuedCardAuthorizationResponse;
import io.moov.sdk.models.operations.GetIssuedCardTransactionRequest;
import io.moov.sdk.models.operations.GetIssuedCardTransactionRequestBuilder;
import io.moov.sdk.models.operations.GetIssuedCardTransactionResponse;
import io.moov.sdk.models.operations.ListIssuedCardAuthorizationEventsRequest;
import io.moov.sdk.models.operations.ListIssuedCardAuthorizationEventsRequestBuilder;
import io.moov.sdk.models.operations.ListIssuedCardAuthorizationEventsResponse;
import io.moov.sdk.models.operations.ListIssuedCardAuthorizationsRequest;
import io.moov.sdk.models.operations.ListIssuedCardAuthorizationsRequestBuilder;
import io.moov.sdk.models.operations.ListIssuedCardAuthorizationsResponse;
import io.moov.sdk.models.operations.ListIssuedCardTransactionsRequest;
import io.moov.sdk.models.operations.ListIssuedCardTransactionsRequestBuilder;
import io.moov.sdk.models.operations.ListIssuedCardTransactionsResponse;
import io.moov.sdk.operations.GetIssuedCardAuthorizationOperation;
import io.moov.sdk.operations.GetIssuedCardTransactionOperation;
import io.moov.sdk.operations.ListIssuedCardAuthorizationEventsOperation;
import io.moov.sdk.operations.ListIssuedCardAuthorizationsOperation;
import io.moov.sdk.operations.ListIssuedCardTransactionsOperation;
import java.lang.Exception;
import java.lang.Long;
import java.lang.String;
import java.util.Optional;


public class IssuingTransactions {
    private final SDKConfiguration sdkConfiguration;

    IssuingTransactions(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    /**
     * List issued card authorizations associated with a Moov account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/issued-cards.read` scope.
     * 
     * @return The call builder
     */
    public ListIssuedCardAuthorizationsRequestBuilder listAuthorizations() {
        return new ListIssuedCardAuthorizationsRequestBuilder(sdkConfiguration);
    }

    /**
     * List issued card authorizations associated with a Moov account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/issued-cards.read` scope.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListIssuedCardAuthorizationsResponse listAuthorizations(ListIssuedCardAuthorizationsRequest request) throws Exception {
        RequestOperation<ListIssuedCardAuthorizationsRequest, ListIssuedCardAuthorizationsResponse> operation
              = new ListIssuedCardAuthorizationsOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Retrieves details of an authorization associated with a specific Moov account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/issued-cards.read` scope.
     * 
     * @return The call builder
     */
    public GetIssuedCardAuthorizationRequestBuilder getAuthorization() {
        return new GetIssuedCardAuthorizationRequestBuilder(sdkConfiguration);
    }

    /**
     * Retrieves details of an authorization associated with a specific Moov account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/issued-cards.read` scope.
     * 
     * @param accountID The Moov business account for which cards have been issued.
     * @param authorizationID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetIssuedCardAuthorizationResponse getAuthorization(String accountID, String authorizationID) throws Exception {
        GetIssuedCardAuthorizationRequest request =
            GetIssuedCardAuthorizationRequest
                .builder()
                .accountID(accountID)
                .authorizationID(authorizationID)
                .build();
        RequestOperation<GetIssuedCardAuthorizationRequest, GetIssuedCardAuthorizationResponse> operation
              = new GetIssuedCardAuthorizationOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * List card network and Moov platform events that affect the authorization and its hold on a wallet balance.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/issued-cards.read` scope.
     * 
     * @return The call builder
     */
    public ListIssuedCardAuthorizationEventsRequestBuilder listAuthorizationEvents() {
        return new ListIssuedCardAuthorizationEventsRequestBuilder(sdkConfiguration);
    }

    /**
     * List card network and Moov platform events that affect the authorization and its hold on a wallet balance.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/issued-cards.read` scope.
     * 
     * @param accountID The Moov business account for which cards have been issued.
     * @param authorizationID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListIssuedCardAuthorizationEventsResponse listAuthorizationEvents(String accountID, String authorizationID) throws Exception {
        return listAuthorizationEvents(accountID, authorizationID, Optional.empty(),
            Optional.empty());
    }

    /**
     * List card network and Moov platform events that affect the authorization and its hold on a wallet balance.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/issued-cards.read` scope.
     * 
     * @param accountID The Moov business account for which cards have been issued.
     * @param authorizationID 
     * @param skip 
     * @param count 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListIssuedCardAuthorizationEventsResponse listAuthorizationEvents(
            String accountID, String authorizationID,
            Optional<Long> skip, Optional<Long> count) throws Exception {
        ListIssuedCardAuthorizationEventsRequest request =
            ListIssuedCardAuthorizationEventsRequest
                .builder()
                .accountID(accountID)
                .authorizationID(authorizationID)
                .skip(skip)
                .count(count)
                .build();
        RequestOperation<ListIssuedCardAuthorizationEventsRequest, ListIssuedCardAuthorizationEventsResponse> operation
              = new ListIssuedCardAuthorizationEventsOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * List issued card transactions associated with a Moov account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/issued-cards.read` scope.
     * 
     * @return The call builder
     */
    public ListIssuedCardTransactionsRequestBuilder list() {
        return new ListIssuedCardTransactionsRequestBuilder(sdkConfiguration);
    }

    /**
     * List issued card transactions associated with a Moov account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/issued-cards.read` scope.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListIssuedCardTransactionsResponse list(ListIssuedCardTransactionsRequest request) throws Exception {
        RequestOperation<ListIssuedCardTransactionsRequest, ListIssuedCardTransactionsResponse> operation
              = new ListIssuedCardTransactionsOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Retrieves details of an issued card transaction associated with a specific Moov account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/issued-cards.read` scope.
     * 
     * @return The call builder
     */
    public GetIssuedCardTransactionRequestBuilder get() {
        return new GetIssuedCardTransactionRequestBuilder(sdkConfiguration);
    }

    /**
     * Retrieves details of an issued card transaction associated with a specific Moov account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/issued-cards.read` scope.
     * 
     * @param accountID The Moov business account for which cards have been issued.
     * @param cardTransactionID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetIssuedCardTransactionResponse get(String accountID, String cardTransactionID) throws Exception {
        GetIssuedCardTransactionRequest request =
            GetIssuedCardTransactionRequest
                .builder()
                .accountID(accountID)
                .cardTransactionID(cardTransactionID)
                .build();
        RequestOperation<GetIssuedCardTransactionRequest, GetIssuedCardTransactionResponse> operation
              = new GetIssuedCardTransactionOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

}
