/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk;

import static io.moov.sdk.operations.Operations.RequestOperation;

import io.moov.sdk.models.operations.ListInstitutionsRequest;
import io.moov.sdk.models.operations.ListInstitutionsRequestBuilder;
import io.moov.sdk.models.operations.ListInstitutionsResponse;
import io.moov.sdk.models.operations.SearchInstitutionsRequest;
import io.moov.sdk.models.operations.SearchInstitutionsRequestBuilder;
import io.moov.sdk.models.operations.SearchInstitutionsResponse;
import io.moov.sdk.operations.ListInstitutionsOperation;
import io.moov.sdk.operations.SearchInstitutionsOperation;
import java.lang.Exception;
import java.lang.Long;
import java.lang.String;
import java.util.Optional;


public class Institutions {
    private final SDKConfiguration sdkConfiguration;

    Institutions(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    /**
     * Search for financial institutions by name or routing number.
     * 
     * <p>This endpoint returns metadata about each matched institution, including basic identifying details (such as name, routing number, and address) and information about which payment services they support (e.g., ACH, RTP, and Wire).
     * 
     * <p>This can be used to validate a financial institution before initiating payment activity, or to check which payment rails are available for a given routing number.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/)
     * you'll need to specify the `/institutions.read` scope.
     * 
     * @return The call builder
     */
    public SearchInstitutionsRequestBuilder searchInstitutions() {
        return new SearchInstitutionsRequestBuilder(sdkConfiguration);
    }

    /**
     * Search for financial institutions by name or routing number.
     * 
     * <p>This endpoint returns metadata about each matched institution, including basic identifying details (such as name, routing number, and address) and information about which payment services they support (e.g., ACH, RTP, and Wire).
     * 
     * <p>This can be used to validate a financial institution before initiating payment activity, or to check which payment rails are available for a given routing number.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/)
     * you'll need to specify the `/institutions.read` scope.
     * 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public SearchInstitutionsResponse searchInstitutionsDirect() throws Exception {
        return searchInstitutions(Optional.empty(), Optional.empty(), Optional.empty());
    }

    /**
     * Search for financial institutions by name or routing number.
     * 
     * <p>This endpoint returns metadata about each matched institution, including basic identifying details (such as name, routing number, and address) and information about which payment services they support (e.g., ACH, RTP, and Wire).
     * 
     * <p>This can be used to validate a financial institution before initiating payment activity, or to check which payment rails are available for a given routing number.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/)
     * you'll need to specify the `/institutions.read` scope.
     * 
     * @param name Name of the financial institution. Either `name` or `routingNumber` is required.
     * @param routingNumber Routing number for a financial institution. Either `routingNumber` or `name` is required.
     * @param limit Maximum results returned by a search.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public SearchInstitutionsResponse searchInstitutions(
            Optional<String> name, Optional<String> routingNumber,
            Optional<Long> limit) throws Exception {
        SearchInstitutionsRequest request =
            SearchInstitutionsRequest
                .builder()
                .name(name)
                .routingNumber(routingNumber)
                .limit(limit)
                .build();
        RequestOperation<SearchInstitutionsRequest, SearchInstitutionsResponse> operation
              = new SearchInstitutionsOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Search for institutions by either their name or routing number.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/fed.read` scope.
     * 
     * @return The call builder
     */
    public ListInstitutionsRequestBuilder search() {
        return new ListInstitutionsRequestBuilder(sdkConfiguration);
    }

    /**
     * Search for institutions by either their name or routing number.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/fed.read` scope.
     * 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListInstitutionsResponse searchDirect() throws Exception {
        return search(Optional.empty(), Optional.empty(), Optional.empty(),
            Optional.empty());
    }

    /**
     * Search for institutions by either their name or routing number.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/fed.read` scope.
     * 
     * @param name Name of the financial institution. Either `name` or `routingNumber` is required.
     * @param routingNumber Routing number for a financial institution. Either `routingNumber` or `name` is required.
     * @param state The state where a financial institution is based.
     * @param limit Maximum results returned by a search.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListInstitutionsResponse search(
            Optional<String> name, Optional<String> routingNumber,
            Optional<String> state, Optional<Long> limit) throws Exception {
        ListInstitutionsRequest request =
            ListInstitutionsRequest
                .builder()
                .name(name)
                .routingNumber(routingNumber)
                .state(state)
                .limit(limit)
                .build();
        RequestOperation<ListInstitutionsRequest, ListInstitutionsResponse> operation
              = new ListInstitutionsOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

}
