/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk;

import static io.moov.sdk.operations.Operations.RequestOperation;

import io.moov.sdk.models.operations.ListIndustriesRequest;
import io.moov.sdk.models.operations.ListIndustriesRequestBuilder;
import io.moov.sdk.models.operations.ListIndustriesResponse;
import io.moov.sdk.operations.ListIndustriesOperation;
import java.lang.Exception;


public class Industries {
    private final SDKConfiguration sdkConfiguration;

    Industries(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    /**
     * Returns a list of industries relevant to merchant profile enrichment.  Results are ordered by industry name.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/),
     * you'll need to specify the `/profile-enrichment.read` scope.
     * 
     * @return The call builder
     */
    public ListIndustriesRequestBuilder list() {
        return new ListIndustriesRequestBuilder(sdkConfiguration);
    }

    /**
     * Returns a list of industries relevant to merchant profile enrichment.  Results are ordered by industry name.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/),
     * you'll need to specify the `/profile-enrichment.read` scope.
     * 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListIndustriesResponse listDirect() throws Exception {
        ListIndustriesRequest request =
            ListIndustriesRequest
                .builder()
                .build();
        RequestOperation<ListIndustriesRequest, ListIndustriesResponse> operation
              = new ListIndustriesOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

}
