/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk;

import static io.moov.sdk.operations.Operations.RequestOperation;

import io.moov.sdk.models.components.FileUploadRequestMultiPart;
import io.moov.sdk.models.operations.GetFileDetailsRequest;
import io.moov.sdk.models.operations.GetFileDetailsRequestBuilder;
import io.moov.sdk.models.operations.GetFileDetailsResponse;
import io.moov.sdk.models.operations.ListFilesRequest;
import io.moov.sdk.models.operations.ListFilesRequestBuilder;
import io.moov.sdk.models.operations.ListFilesResponse;
import io.moov.sdk.models.operations.UploadFileRequest;
import io.moov.sdk.models.operations.UploadFileRequestBuilder;
import io.moov.sdk.models.operations.UploadFileResponse;
import io.moov.sdk.operations.GetFileDetailsOperation;
import io.moov.sdk.operations.ListFilesOperation;
import io.moov.sdk.operations.UploadFileOperation;
import java.lang.Exception;
import java.lang.String;


public class Files {
    private final SDKConfiguration sdkConfiguration;

    Files(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    /**
     * Upload a file and link it to the specified Moov account. 
     * 
     * <p>The maximum file size is 20MB. Each account is allowed a maximum of 50 files. Acceptable file types include csv, jpg, pdf, 
     * and png. 
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/files.write` scope.
     * 
     * @return The call builder
     */
    public UploadFileRequestBuilder upload() {
        return new UploadFileRequestBuilder(sdkConfiguration);
    }

    /**
     * Upload a file and link it to the specified Moov account. 
     * 
     * <p>The maximum file size is 20MB. Each account is allowed a maximum of 50 files. Acceptable file types include csv, jpg, pdf, 
     * and png. 
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/files.write` scope.
     * 
     * @param accountID 
     * @param fileUploadRequestMultiPart Request to upload a file for an account.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public UploadFileResponse upload(String accountID, FileUploadRequestMultiPart fileUploadRequestMultiPart) throws Exception {
        UploadFileRequest request =
            UploadFileRequest
                .builder()
                .accountID(accountID)
                .fileUploadRequestMultiPart(fileUploadRequestMultiPart)
                .build();
        RequestOperation<UploadFileRequest, UploadFileResponse> operation
              = new UploadFileOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * List all the files associated with a particular Moov account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/files.read` scope.
     * 
     * @return The call builder
     */
    public ListFilesRequestBuilder list() {
        return new ListFilesRequestBuilder(sdkConfiguration);
    }

    /**
     * List all the files associated with a particular Moov account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/files.read` scope.
     * 
     * @param accountID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListFilesResponse list(String accountID) throws Exception {
        ListFilesRequest request =
            ListFilesRequest
                .builder()
                .accountID(accountID)
                .build();
        RequestOperation<ListFilesRequest, ListFilesResponse> operation
              = new ListFilesOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Retrieve file details associated with a specific Moov account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/files.read` scope.
     * 
     * @return The call builder
     */
    public GetFileDetailsRequestBuilder get() {
        return new GetFileDetailsRequestBuilder(sdkConfiguration);
    }

    /**
     * Retrieve file details associated with a specific Moov account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/files.read` scope.
     * 
     * @param accountID 
     * @param fileID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetFileDetailsResponse get(String accountID, String fileID) throws Exception {
        GetFileDetailsRequest request =
            GetFileDetailsRequest
                .builder()
                .accountID(accountID)
                .fileID(fileID)
                .build();
        RequestOperation<GetFileDetailsRequest, GetFileDetailsResponse> operation
              = new GetFileDetailsOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

}
