/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk;

import static io.moov.sdk.operations.Operations.RequestOperation;

import io.moov.sdk.models.components.CreateFeePlanAgreement;
import io.moov.sdk.models.components.ListFeesFetchRequest;
import io.moov.sdk.models.operations.CreateFeePlanAgreementsRequest;
import io.moov.sdk.models.operations.CreateFeePlanAgreementsRequestBuilder;
import io.moov.sdk.models.operations.CreateFeePlanAgreementsResponse;
import io.moov.sdk.models.operations.ListFeePlanAgreementsRequest;
import io.moov.sdk.models.operations.ListFeePlanAgreementsRequestBuilder;
import io.moov.sdk.models.operations.ListFeePlanAgreementsResponse;
import io.moov.sdk.models.operations.ListFeePlansRequest;
import io.moov.sdk.models.operations.ListFeePlansRequestBuilder;
import io.moov.sdk.models.operations.ListFeePlansResponse;
import io.moov.sdk.models.operations.ListFeesFetchRequestBuilder;
import io.moov.sdk.models.operations.ListFeesFetchResponse;
import io.moov.sdk.models.operations.ListPartnerPricingAgreementsRequest;
import io.moov.sdk.models.operations.ListPartnerPricingAgreementsRequestBuilder;
import io.moov.sdk.models.operations.ListPartnerPricingAgreementsResponse;
import io.moov.sdk.models.operations.ListPartnerPricingRequest;
import io.moov.sdk.models.operations.ListPartnerPricingRequestBuilder;
import io.moov.sdk.models.operations.ListPartnerPricingResponse;
import io.moov.sdk.models.operations.RetrieveFeesRequest;
import io.moov.sdk.models.operations.RetrieveFeesRequestBuilder;
import io.moov.sdk.models.operations.RetrieveFeesResponse;
import io.moov.sdk.operations.CreateFeePlanAgreementsOperation;
import io.moov.sdk.operations.ListFeePlanAgreementsOperation;
import io.moov.sdk.operations.ListFeePlansOperation;
import io.moov.sdk.operations.ListFeesFetchOperation;
import io.moov.sdk.operations.ListPartnerPricingAgreementsOperation;
import io.moov.sdk.operations.ListPartnerPricingOperation;
import io.moov.sdk.operations.RetrieveFeesOperation;
import java.lang.Exception;
import java.lang.String;
import java.util.List;
import java.util.Optional;


public class FeePlans {
    private final SDKConfiguration sdkConfiguration;

    FeePlans(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    /**
     * List all fee plan agreements associated with an account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/profile.read` scope.
     * 
     * @return The call builder
     */
    public ListFeePlanAgreementsRequestBuilder listFeePlanAgreements() {
        return new ListFeePlanAgreementsRequestBuilder(sdkConfiguration);
    }

    /**
     * List all fee plan agreements associated with an account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/profile.read` scope.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListFeePlanAgreementsResponse listFeePlanAgreements(ListFeePlanAgreementsRequest request) throws Exception {
        RequestOperation<ListFeePlanAgreementsRequest, ListFeePlanAgreementsResponse> operation
              = new ListFeePlanAgreementsOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Creates the subscription of a fee plan to a merchant account. Merchants are required to accept the fee plan terms prior to activation.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/profile.write` scope.
     * 
     * @return The call builder
     */
    public CreateFeePlanAgreementsRequestBuilder createFeePlanAgreements() {
        return new CreateFeePlanAgreementsRequestBuilder(sdkConfiguration);
    }

    /**
     * Creates the subscription of a fee plan to a merchant account. Merchants are required to accept the fee plan terms prior to activation.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/profile.write` scope.
     * 
     * @param accountID 
     * @param createFeePlanAgreement 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public CreateFeePlanAgreementsResponse createFeePlanAgreements(String accountID, CreateFeePlanAgreement createFeePlanAgreement) throws Exception {
        CreateFeePlanAgreementsRequest request =
            CreateFeePlanAgreementsRequest
                .builder()
                .accountID(accountID)
                .createFeePlanAgreement(createFeePlanAgreement)
                .build();
        RequestOperation<CreateFeePlanAgreementsRequest, CreateFeePlanAgreementsResponse> operation
              = new CreateFeePlanAgreementsOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * List all fee plans available for use by an account. This is intended to be used by an account when 
     * selecting a fee plan to apply to a connected account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/profile.read` scope.
     * 
     * @return The call builder
     */
    public ListFeePlansRequestBuilder listFeePlans() {
        return new ListFeePlansRequestBuilder(sdkConfiguration);
    }

    /**
     * List all fee plans available for use by an account. This is intended to be used by an account when 
     * selecting a fee plan to apply to a connected account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/profile.read` scope.
     * 
     * @param accountID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListFeePlansResponse listFeePlans(String accountID) throws Exception {
        return listFeePlans(accountID, Optional.empty());
    }

    /**
     * List all fee plans available for use by an account. This is intended to be used by an account when 
     * selecting a fee plan to apply to a connected account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/profile.read` scope.
     * 
     * @param accountID 
     * @param planIDs A comma-separated list of plan IDs to filter the results by.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListFeePlansResponse listFeePlans(String accountID, Optional<? extends List<String>> planIDs) throws Exception {
        ListFeePlansRequest request =
            ListFeePlansRequest
                .builder()
                .accountID(accountID)
                .planIDs(planIDs)
                .build();
        RequestOperation<ListFeePlansRequest, ListFeePlansResponse> operation
              = new ListFeePlansOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Retrieve fees associated with an account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.read` scope.
     * 
     * @return The call builder
     */
    public RetrieveFeesRequestBuilder retrieveFees() {
        return new RetrieveFeesRequestBuilder(sdkConfiguration);
    }

    /**
     * Retrieve fees associated with an account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.read` scope.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public RetrieveFeesResponse retrieveFees(RetrieveFeesRequest request) throws Exception {
        RequestOperation<RetrieveFeesRequest, RetrieveFeesResponse> operation
              = new RetrieveFeesOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * List fees associated with an account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.read` scope.
     * 
     * @return The call builder
     */
    public ListFeesFetchRequestBuilder listFeesFetch() {
        return new ListFeesFetchRequestBuilder(sdkConfiguration);
    }

    /**
     * List fees associated with an account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.read` scope.
     * 
     * @param accountID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListFeesFetchResponse listFeesFetch(String accountID) throws Exception {
        return listFeesFetch(accountID, Optional.empty());
    }

    /**
     * List fees associated with an account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.read` scope.
     * 
     * @param accountID 
     * @param listFeesFetchRequest Array of fee IDs to fetch.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListFeesFetchResponse listFeesFetch(String accountID, Optional<? extends ListFeesFetchRequest> listFeesFetchRequest) throws Exception {
        io.moov.sdk.models.operations.ListFeesFetchRequest request =
            io.moov.sdk.models.operations.ListFeesFetchRequest
                .builder()
                .accountID(accountID)
                .listFeesFetchRequest(listFeesFetchRequest)
                .build();
        RequestOperation<io.moov.sdk.models.operations.ListFeesFetchRequest, ListFeesFetchResponse> operation
              = new ListFeesFetchOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * List all partner pricing plans available for use by an account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/profile.read` scope.
     * 
     * @return The call builder
     */
    public ListPartnerPricingRequestBuilder listPartnerPricing() {
        return new ListPartnerPricingRequestBuilder(sdkConfiguration);
    }

    /**
     * List all partner pricing plans available for use by an account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/profile.read` scope.
     * 
     * @param accountID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListPartnerPricingResponse listPartnerPricing(String accountID) throws Exception {
        return listPartnerPricing(accountID, Optional.empty());
    }

    /**
     * List all partner pricing plans available for use by an account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/profile.read` scope.
     * 
     * @param accountID 
     * @param planIDs A comma-separated list of plan IDs to filter the results by.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListPartnerPricingResponse listPartnerPricing(String accountID, Optional<? extends List<String>> planIDs) throws Exception {
        ListPartnerPricingRequest request =
            ListPartnerPricingRequest
                .builder()
                .accountID(accountID)
                .planIDs(planIDs)
                .build();
        RequestOperation<ListPartnerPricingRequest, ListPartnerPricingResponse> operation
              = new ListPartnerPricingOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * List all partner pricing agreements associated with an account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/profile.read` scope.
     * 
     * @return The call builder
     */
    public ListPartnerPricingAgreementsRequestBuilder listPartnerPricingAgreements() {
        return new ListPartnerPricingAgreementsRequestBuilder(sdkConfiguration);
    }

    /**
     * List all partner pricing agreements associated with an account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/profile.read` scope.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListPartnerPricingAgreementsResponse listPartnerPricingAgreements(ListPartnerPricingAgreementsRequest request) throws Exception {
        RequestOperation<ListPartnerPricingAgreementsRequest, ListPartnerPricingAgreementsResponse> operation
              = new ListPartnerPricingAgreementsOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

}
