/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk;

import static io.moov.sdk.operations.Operations.RequestOperation;

import io.moov.sdk.models.components.E2EEToken;
import io.moov.sdk.models.operations.GenerateEndToEndKeyRequest;
import io.moov.sdk.models.operations.GenerateEndToEndKeyRequestBuilder;
import io.moov.sdk.models.operations.GenerateEndToEndKeyResponse;
import io.moov.sdk.models.operations.TestEndToEndTokenRequestBuilder;
import io.moov.sdk.models.operations.TestEndToEndTokenResponse;
import io.moov.sdk.operations.GenerateEndToEndKeyOperation;
import io.moov.sdk.operations.TestEndToEndTokenOperation;
import java.lang.Exception;
import java.lang.String;


public class EndToEndEncryption {
    private final SDKConfiguration sdkConfiguration;

    EndToEndEncryption(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    /**
     * Allows for testing a JWE token to ensure it's acceptable by Moov. 
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/ping.read` scope.
     * 
     * @return The call builder
     */
    public TestEndToEndTokenRequestBuilder testEncryptedToken() {
        return new TestEndToEndTokenRequestBuilder(sdkConfiguration);
    }

    /**
     * Allows for testing a JWE token to ensure it's acceptable by Moov. 
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/ping.read` scope.
     * 
     * @param token 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public TestEndToEndTokenResponse testEncryptedToken(String token) throws Exception {
        E2EEToken request =
            E2EEToken
                .builder()
                .token(token)
                .build();
        RequestOperation<E2EEToken, TestEndToEndTokenResponse> operation
              = new TestEndToEndTokenOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Generates a public key used to create a JWE token for passing secure authentication data through non-PCI compliant intermediaries.
     * 
     * @return The call builder
     */
    public GenerateEndToEndKeyRequestBuilder generateKey() {
        return new GenerateEndToEndKeyRequestBuilder(sdkConfiguration);
    }

    /**
     * Generates a public key used to create a JWE token for passing secure authentication data through non-PCI compliant intermediaries.
     * 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GenerateEndToEndKeyResponse generateKeyDirect() throws Exception {
        GenerateEndToEndKeyRequest request =
            GenerateEndToEndKeyRequest
                .builder()
                .build();
        RequestOperation<GenerateEndToEndKeyRequest, GenerateEndToEndKeyResponse> operation
              = new GenerateEndToEndKeyOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

}
