/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk;

import static io.moov.sdk.operations.Operations.RequestOperation;

import io.moov.sdk.models.components.CreateEvidenceFileMultiPart;
import io.moov.sdk.models.components.CreateEvidenceText;
import io.moov.sdk.models.components.UpdateEvidence;
import io.moov.sdk.models.operations.AcceptDisputeRequest;
import io.moov.sdk.models.operations.AcceptDisputeRequestBuilder;
import io.moov.sdk.models.operations.AcceptDisputeResponse;
import io.moov.sdk.models.operations.DeleteDisputeEvidenceFileRequest;
import io.moov.sdk.models.operations.DeleteDisputeEvidenceFileRequestBuilder;
import io.moov.sdk.models.operations.DeleteDisputeEvidenceFileResponse;
import io.moov.sdk.models.operations.GetDisputeEvidenceDataRequest;
import io.moov.sdk.models.operations.GetDisputeEvidenceDataRequestBuilder;
import io.moov.sdk.models.operations.GetDisputeEvidenceDataResponse;
import io.moov.sdk.models.operations.GetDisputeEvidenceRequest;
import io.moov.sdk.models.operations.GetDisputeEvidenceRequestBuilder;
import io.moov.sdk.models.operations.GetDisputeEvidenceResponse;
import io.moov.sdk.models.operations.GetDisputeRequest;
import io.moov.sdk.models.operations.GetDisputeRequestBuilder;
import io.moov.sdk.models.operations.GetDisputeResponse;
import io.moov.sdk.models.operations.ListDisputeEvidenceRequest;
import io.moov.sdk.models.operations.ListDisputeEvidenceRequestBuilder;
import io.moov.sdk.models.operations.ListDisputeEvidenceResponse;
import io.moov.sdk.models.operations.ListDisputesRequest;
import io.moov.sdk.models.operations.ListDisputesRequestBuilder;
import io.moov.sdk.models.operations.ListDisputesResponse;
import io.moov.sdk.models.operations.SubmitDisputeEvidenceRequest;
import io.moov.sdk.models.operations.SubmitDisputeEvidenceRequestBuilder;
import io.moov.sdk.models.operations.SubmitDisputeEvidenceResponse;
import io.moov.sdk.models.operations.UpdateDisputeEvidenceRequest;
import io.moov.sdk.models.operations.UpdateDisputeEvidenceRequestBuilder;
import io.moov.sdk.models.operations.UpdateDisputeEvidenceResponse;
import io.moov.sdk.models.operations.UploadDisputeEvidenceFileRequest;
import io.moov.sdk.models.operations.UploadDisputeEvidenceFileRequestBuilder;
import io.moov.sdk.models.operations.UploadDisputeEvidenceFileResponse;
import io.moov.sdk.models.operations.UploadDisputeEvidenceTextRequest;
import io.moov.sdk.models.operations.UploadDisputeEvidenceTextRequestBuilder;
import io.moov.sdk.models.operations.UploadDisputeEvidenceTextResponse;
import io.moov.sdk.operations.AcceptDisputeOperation;
import io.moov.sdk.operations.DeleteDisputeEvidenceFileOperation;
import io.moov.sdk.operations.GetDisputeEvidenceDataOperation;
import io.moov.sdk.operations.GetDisputeEvidenceOperation;
import io.moov.sdk.operations.GetDisputeOperation;
import io.moov.sdk.operations.ListDisputeEvidenceOperation;
import io.moov.sdk.operations.ListDisputesOperation;
import io.moov.sdk.operations.SubmitDisputeEvidenceOperation;
import io.moov.sdk.operations.UpdateDisputeEvidenceOperation;
import io.moov.sdk.operations.UploadDisputeEvidenceFileOperation;
import io.moov.sdk.operations.UploadDisputeEvidenceTextOperation;
import java.lang.Exception;
import java.lang.String;


public class Disputes {
    private final SDKConfiguration sdkConfiguration;

    Disputes(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    /**
     * Returns the list of disputes. 
     * 
     * <p>Read our [disputes guide](https://docs.moov.io/guides/money-movement/accept-payments/card-acceptance/disputes/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.read` scope.
     * 
     * @return The call builder
     */
    public ListDisputesRequestBuilder list() {
        return new ListDisputesRequestBuilder(sdkConfiguration);
    }

    /**
     * Returns the list of disputes. 
     * 
     * <p>Read our [disputes guide](https://docs.moov.io/guides/money-movement/accept-payments/card-acceptance/disputes/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.read` scope.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListDisputesResponse list(ListDisputesRequest request) throws Exception {
        RequestOperation<ListDisputesRequest, ListDisputesResponse> operation
              = new ListDisputesOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Get a dispute by ID. 
     * 
     * <p>Read our [disputes guide](https://docs.moov.io/guides/money-movement/accept-payments/card-acceptance/disputes/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.read` scope.
     * 
     * @return The call builder
     */
    public GetDisputeRequestBuilder get() {
        return new GetDisputeRequestBuilder(sdkConfiguration);
    }

    /**
     * Get a dispute by ID. 
     * 
     * <p>Read our [disputes guide](https://docs.moov.io/guides/money-movement/accept-payments/card-acceptance/disputes/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.read` scope.
     * 
     * @param accountID 
     * @param disputeID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetDisputeResponse get(String accountID, String disputeID) throws Exception {
        GetDisputeRequest request =
            GetDisputeRequest
                .builder()
                .accountID(accountID)
                .disputeID(disputeID)
                .build();
        RequestOperation<GetDisputeRequest, GetDisputeResponse> operation
              = new GetDisputeOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Accepts liability for a dispute. 
     * 
     * <p>Read our [disputes guide](https://docs.moov.io/guides/money-movement/accept-payments/card-acceptance/disputes/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.read` scope.
     * 
     * @return The call builder
     */
    public AcceptDisputeRequestBuilder accept() {
        return new AcceptDisputeRequestBuilder(sdkConfiguration);
    }

    /**
     * Accepts liability for a dispute. 
     * 
     * <p>Read our [disputes guide](https://docs.moov.io/guides/money-movement/accept-payments/card-acceptance/disputes/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.read` scope.
     * 
     * @param accountID 
     * @param disputeID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public AcceptDisputeResponse accept(String accountID, String disputeID) throws Exception {
        AcceptDisputeRequest request =
            AcceptDisputeRequest
                .builder()
                .accountID(accountID)
                .disputeID(disputeID)
                .build();
        RequestOperation<AcceptDisputeRequest, AcceptDisputeResponse> operation
              = new AcceptDisputeOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Returns a dispute's public evidence by its ID. 
     * 
     * <p>Read our [disputes guide](https://docs.moov.io/guides/money-movement/accept-payments/card-acceptance/disputes/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.read` scope.
     * 
     * @return The call builder
     */
    public ListDisputeEvidenceRequestBuilder listEvidence() {
        return new ListDisputeEvidenceRequestBuilder(sdkConfiguration);
    }

    /**
     * Returns a dispute's public evidence by its ID. 
     * 
     * <p>Read our [disputes guide](https://docs.moov.io/guides/money-movement/accept-payments/card-acceptance/disputes/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.read` scope.
     * 
     * @param accountID 
     * @param disputeID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListDisputeEvidenceResponse listEvidence(String accountID, String disputeID) throws Exception {
        ListDisputeEvidenceRequest request =
            ListDisputeEvidenceRequest
                .builder()
                .accountID(accountID)
                .disputeID(disputeID)
                .build();
        RequestOperation<ListDisputeEvidenceRequest, ListDisputeEvidenceResponse> operation
              = new ListDisputeEvidenceOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Uploads a file as evidence for a dispute. 
     * 
     * <p>Read our [disputes guide](https://docs.moov.io/guides/money-movement/accept-payments/card-acceptance/disputes/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.write` scope.
     * 
     * @return The call builder
     */
    public UploadDisputeEvidenceFileRequestBuilder uploadEvidenceFile() {
        return new UploadDisputeEvidenceFileRequestBuilder(sdkConfiguration);
    }

    /**
     * Uploads a file as evidence for a dispute. 
     * 
     * <p>Read our [disputes guide](https://docs.moov.io/guides/money-movement/accept-payments/card-acceptance/disputes/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.write` scope.
     * 
     * @param accountID 
     * @param disputeID 
     * @param createEvidenceFileMultiPart 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public UploadDisputeEvidenceFileResponse uploadEvidenceFile(
            String accountID, String disputeID,
            CreateEvidenceFileMultiPart createEvidenceFileMultiPart) throws Exception {
        UploadDisputeEvidenceFileRequest request =
            UploadDisputeEvidenceFileRequest
                .builder()
                .accountID(accountID)
                .disputeID(disputeID)
                .createEvidenceFileMultiPart(createEvidenceFileMultiPart)
                .build();
        RequestOperation<UploadDisputeEvidenceFileRequest, UploadDisputeEvidenceFileResponse> operation
              = new UploadDisputeEvidenceFileOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Uploads text as evidence for a dispute.
     * 
     * <p>Read our [disputes guide](https://docs.moov.io/guides/money-movement/accept-payments/card-acceptance/disputes/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.write` scope.
     * 
     * @return The call builder
     */
    public UploadDisputeEvidenceTextRequestBuilder uploadEvidenceText() {
        return new UploadDisputeEvidenceTextRequestBuilder(sdkConfiguration);
    }

    /**
     * Uploads text as evidence for a dispute.
     * 
     * <p>Read our [disputes guide](https://docs.moov.io/guides/money-movement/accept-payments/card-acceptance/disputes/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.write` scope.
     * 
     * @param accountID 
     * @param disputeID 
     * @param createEvidenceText 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public UploadDisputeEvidenceTextResponse uploadEvidenceText(
            String accountID, String disputeID,
            CreateEvidenceText createEvidenceText) throws Exception {
        UploadDisputeEvidenceTextRequest request =
            UploadDisputeEvidenceTextRequest
                .builder()
                .accountID(accountID)
                .disputeID(disputeID)
                .createEvidenceText(createEvidenceText)
                .build();
        RequestOperation<UploadDisputeEvidenceTextRequest, UploadDisputeEvidenceTextResponse> operation
              = new UploadDisputeEvidenceTextOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Submit the evidence associated with a dispute.
     * 
     * <p>Evidence items must be uploaded using the appropriate endpoint(s) prior to calling this endpoint to submit it. **Evidence can only
     * be submitted once per dispute.**
     * 
     * <p>Read our [disputes guide](https://docs.moov.io/guides/money-movement/accept-payments/card-acceptance/disputes/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.write` scope.
     * 
     * @return The call builder
     */
    public SubmitDisputeEvidenceRequestBuilder submitEvidence() {
        return new SubmitDisputeEvidenceRequestBuilder(sdkConfiguration);
    }

    /**
     * Submit the evidence associated with a dispute.
     * 
     * <p>Evidence items must be uploaded using the appropriate endpoint(s) prior to calling this endpoint to submit it. **Evidence can only
     * be submitted once per dispute.**
     * 
     * <p>Read our [disputes guide](https://docs.moov.io/guides/money-movement/accept-payments/card-acceptance/disputes/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.write` scope.
     * 
     * @param accountID 
     * @param disputeID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public SubmitDisputeEvidenceResponse submitEvidence(String accountID, String disputeID) throws Exception {
        SubmitDisputeEvidenceRequest request =
            SubmitDisputeEvidenceRequest
                .builder()
                .accountID(accountID)
                .disputeID(disputeID)
                .build();
        RequestOperation<SubmitDisputeEvidenceRequest, SubmitDisputeEvidenceResponse> operation
              = new SubmitDisputeEvidenceOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Get dispute evidence by ID.
     * 
     * <p>Read our [disputes guide](https://docs.moov.io/guides/money-movement/accept-payments/card-acceptance/disputes/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.read` scope.
     * 
     * @return The call builder
     */
    public GetDisputeEvidenceRequestBuilder getEvidence() {
        return new GetDisputeEvidenceRequestBuilder(sdkConfiguration);
    }

    /**
     * Get dispute evidence by ID.
     * 
     * <p>Read our [disputes guide](https://docs.moov.io/guides/money-movement/accept-payments/card-acceptance/disputes/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.read` scope.
     * 
     * @param accountID 
     * @param disputeID 
     * @param evidenceID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetDisputeEvidenceResponse getEvidence(
            String accountID, String disputeID,
            String evidenceID) throws Exception {
        GetDisputeEvidenceRequest request =
            GetDisputeEvidenceRequest
                .builder()
                .accountID(accountID)
                .disputeID(disputeID)
                .evidenceID(evidenceID)
                .build();
        RequestOperation<GetDisputeEvidenceRequest, GetDisputeEvidenceResponse> operation
              = new GetDisputeEvidenceOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Updates dispute evidence by ID.
     * 
     * <p>Read our [disputes guide](https://docs.moov.io/guides/money-movement/accept-payments/card-acceptance/disputes/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.write` scope.
     * 
     * @return The call builder
     */
    public UpdateDisputeEvidenceRequestBuilder updateEvidence() {
        return new UpdateDisputeEvidenceRequestBuilder(sdkConfiguration);
    }

    /**
     * Updates dispute evidence by ID.
     * 
     * <p>Read our [disputes guide](https://docs.moov.io/guides/money-movement/accept-payments/card-acceptance/disputes/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.write` scope.
     * 
     * @param accountID 
     * @param disputeID 
     * @param evidenceID 
     * @param updateEvidence 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public UpdateDisputeEvidenceResponse updateEvidence(
            String accountID, String disputeID,
            String evidenceID, UpdateEvidence updateEvidence) throws Exception {
        UpdateDisputeEvidenceRequest request =
            UpdateDisputeEvidenceRequest
                .builder()
                .accountID(accountID)
                .disputeID(disputeID)
                .evidenceID(evidenceID)
                .updateEvidence(updateEvidence)
                .build();
        RequestOperation<UpdateDisputeEvidenceRequest, UpdateDisputeEvidenceResponse> operation
              = new UpdateDisputeEvidenceOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Deletes dispute evidence by ID. 
     * 
     * <p>Read our [disputes guide](https://docs.moov.io/guides/money-movement/accept-payments/card-acceptance/disputes/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.write` scope.
     * 
     * @return The call builder
     */
    public DeleteDisputeEvidenceFileRequestBuilder deleteEvidence() {
        return new DeleteDisputeEvidenceFileRequestBuilder(sdkConfiguration);
    }

    /**
     * Deletes dispute evidence by ID. 
     * 
     * <p>Read our [disputes guide](https://docs.moov.io/guides/money-movement/accept-payments/card-acceptance/disputes/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.write` scope.
     * 
     * @param accountID 
     * @param disputeID 
     * @param evidenceID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public DeleteDisputeEvidenceFileResponse deleteEvidence(
            String accountID, String disputeID,
            String evidenceID) throws Exception {
        DeleteDisputeEvidenceFileRequest request =
            DeleteDisputeEvidenceFileRequest
                .builder()
                .accountID(accountID)
                .disputeID(disputeID)
                .evidenceID(evidenceID)
                .build();
        RequestOperation<DeleteDisputeEvidenceFileRequest, DeleteDisputeEvidenceFileResponse> operation
              = new DeleteDisputeEvidenceFileOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Downloads dispute evidence data by ID.
     * 
     * <p>Read our [disputes guide](https://docs.moov.io/guides/money-movement/accept-payments/card-acceptance/disputes/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.read` scope.
     * 
     * @return The call builder
     */
    public GetDisputeEvidenceDataRequestBuilder getEvidenceData() {
        return new GetDisputeEvidenceDataRequestBuilder(sdkConfiguration);
    }

    /**
     * Downloads dispute evidence data by ID.
     * 
     * <p>Read our [disputes guide](https://docs.moov.io/guides/money-movement/accept-payments/card-acceptance/disputes/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/transfers.read` scope.
     * 
     * @param accountID 
     * @param disputeID 
     * @param evidenceID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetDisputeEvidenceDataResponse getEvidenceData(
            String accountID, String disputeID,
            String evidenceID) throws Exception {
        GetDisputeEvidenceDataRequest request =
            GetDisputeEvidenceDataRequest
                .builder()
                .accountID(accountID)
                .disputeID(disputeID)
                .evidenceID(evidenceID)
                .build();
        RequestOperation<GetDisputeEvidenceDataRequest, GetDisputeEvidenceDataResponse> operation
              = new GetDisputeEvidenceDataOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

}
