/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk;

import static io.moov.sdk.operations.Operations.RequestOperation;

import io.moov.sdk.models.components.LinkCard;
import io.moov.sdk.models.components.LinkCardWaitFor;
import io.moov.sdk.models.components.UpdateCard;
import io.moov.sdk.models.operations.DisableCardRequest;
import io.moov.sdk.models.operations.DisableCardRequestBuilder;
import io.moov.sdk.models.operations.DisableCardResponse;
import io.moov.sdk.models.operations.GetCardRequest;
import io.moov.sdk.models.operations.GetCardRequestBuilder;
import io.moov.sdk.models.operations.GetCardResponse;
import io.moov.sdk.models.operations.LinkCardRequest;
import io.moov.sdk.models.operations.LinkCardRequestBuilder;
import io.moov.sdk.models.operations.LinkCardResponse;
import io.moov.sdk.models.operations.ListCardsRequest;
import io.moov.sdk.models.operations.ListCardsRequestBuilder;
import io.moov.sdk.models.operations.ListCardsResponse;
import io.moov.sdk.models.operations.UpdateCardRequest;
import io.moov.sdk.models.operations.UpdateCardRequestBuilder;
import io.moov.sdk.models.operations.UpdateCardResponse;
import io.moov.sdk.operations.DisableCardOperation;
import io.moov.sdk.operations.GetCardOperation;
import io.moov.sdk.operations.LinkCardOperation;
import io.moov.sdk.operations.ListCardsOperation;
import io.moov.sdk.operations.UpdateCardOperation;
import java.lang.Exception;
import java.lang.String;
import java.util.Optional;


public class Cards {
    private final SDKConfiguration sdkConfiguration;

    Cards(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    /**
     * Link a card to an existing Moov account. 
     * 
     * <p>Read our [accept card payments guide](https://docs.moov.io/guides/sources/cards/accept-card-payments/#link-a-card) to learn more.
     * 
     * <p>Only use this endpoint if you have provided Moov with a copy of your PCI attestation of compliance. 
     * 
     * <p>During card linking, the provided data will be verified by submitting a $0 authorization (account verification) request. 
     * If `merchantAccountID` is provided, the authorization request will contain that account's statement descriptor and address. 
     * Otherwise, the platform account's profile will be used. If no statement descriptor has been set, the authorization will 
     * use the account's name instead.
     * 
     * <p>It is strongly recommended that callers include the `X-Wait-For` header, set to `payment-method`, if the newly linked 
     * card is intended to be used right away. If this header is not included, the caller will need to poll the [List Payment 
     * Methods](https://docs.moov.io/api/sources/payment-methods/list/)
     * endpoint to wait for the new payment methods to be available for use.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/cards.write` scope.
     * 
     * @return The call builder
     */
    public LinkCardRequestBuilder link() {
        return new LinkCardRequestBuilder(sdkConfiguration);
    }

    /**
     * Link a card to an existing Moov account. 
     * 
     * <p>Read our [accept card payments guide](https://docs.moov.io/guides/sources/cards/accept-card-payments/#link-a-card) to learn more.
     * 
     * <p>Only use this endpoint if you have provided Moov with a copy of your PCI attestation of compliance. 
     * 
     * <p>During card linking, the provided data will be verified by submitting a $0 authorization (account verification) request. 
     * If `merchantAccountID` is provided, the authorization request will contain that account's statement descriptor and address. 
     * Otherwise, the platform account's profile will be used. If no statement descriptor has been set, the authorization will 
     * use the account's name instead.
     * 
     * <p>It is strongly recommended that callers include the `X-Wait-For` header, set to `payment-method`, if the newly linked 
     * card is intended to be used right away. If this header is not included, the caller will need to poll the [List Payment 
     * Methods](https://docs.moov.io/api/sources/payment-methods/list/)
     * endpoint to wait for the new payment methods to be available for use.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/cards.write` scope.
     * 
     * @param accountID 
     * @param linkCard 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public LinkCardResponse link(String accountID, LinkCard linkCard) throws Exception {
        return link(Optional.empty(), accountID, linkCard);
    }

    /**
     * Link a card to an existing Moov account. 
     * 
     * <p>Read our [accept card payments guide](https://docs.moov.io/guides/sources/cards/accept-card-payments/#link-a-card) to learn more.
     * 
     * <p>Only use this endpoint if you have provided Moov with a copy of your PCI attestation of compliance. 
     * 
     * <p>During card linking, the provided data will be verified by submitting a $0 authorization (account verification) request. 
     * If `merchantAccountID` is provided, the authorization request will contain that account's statement descriptor and address. 
     * Otherwise, the platform account's profile will be used. If no statement descriptor has been set, the authorization will 
     * use the account's name instead.
     * 
     * <p>It is strongly recommended that callers include the `X-Wait-For` header, set to `payment-method`, if the newly linked 
     * card is intended to be used right away. If this header is not included, the caller will need to poll the [List Payment 
     * Methods](https://docs.moov.io/api/sources/payment-methods/list/)
     * endpoint to wait for the new payment methods to be available for use.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/cards.write` scope.
     * 
     * @param xWaitFor 
     * @param accountID 
     * @param linkCard 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public LinkCardResponse link(
            Optional<? extends LinkCardWaitFor> xWaitFor, String accountID,
            LinkCard linkCard) throws Exception {
        LinkCardRequest request =
            LinkCardRequest
                .builder()
                .xWaitFor(xWaitFor)
                .accountID(accountID)
                .linkCard(linkCard)
                .build();
        RequestOperation<LinkCardRequest, LinkCardResponse> operation
              = new LinkCardOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * List all the active cards associated with a Moov account. 
     * 
     * <p>Read our [accept card payments guide](https://docs.moov.io/guides/sources/cards/accept-card-payments/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/cards.read` scope.
     * 
     * @return The call builder
     */
    public ListCardsRequestBuilder list() {
        return new ListCardsRequestBuilder(sdkConfiguration);
    }

    /**
     * List all the active cards associated with a Moov account. 
     * 
     * <p>Read our [accept card payments guide](https://docs.moov.io/guides/sources/cards/accept-card-payments/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/cards.read` scope.
     * 
     * @param accountID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListCardsResponse list(String accountID) throws Exception {
        ListCardsRequest request =
            ListCardsRequest
                .builder()
                .accountID(accountID)
                .build();
        RequestOperation<ListCardsRequest, ListCardsResponse> operation
              = new ListCardsOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Fetch a specific card associated with a Moov account. 
     * 
     * <p>Read our [accept card payments guide](https://docs.moov.io/guides/sources/cards/accept-card-payments/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/cards.read` scope.
     * 
     * @return The call builder
     */
    public GetCardRequestBuilder get() {
        return new GetCardRequestBuilder(sdkConfiguration);
    }

    /**
     * Fetch a specific card associated with a Moov account. 
     * 
     * <p>Read our [accept card payments guide](https://docs.moov.io/guides/sources/cards/accept-card-payments/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/cards.read` scope.
     * 
     * @param accountID 
     * @param cardID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetCardResponse get(String accountID, String cardID) throws Exception {
        GetCardRequest request =
            GetCardRequest
                .builder()
                .accountID(accountID)
                .cardID(cardID)
                .build();
        RequestOperation<GetCardRequest, GetCardResponse> operation
              = new GetCardOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Update a linked card and/or resubmit it for verification. 
     * 
     * <p>If a value is provided for CVV, a new verification ($0 authorization) will be submitted for the card. Updating the expiration 
     * date or 
     * address will update the information stored on file for the card but will not be verified.
     * 
     * <p>Read our [accept card payments guide](https://docs.moov.io/guides/sources/cards/accept-card-payments/#reverify-a-card) to learn 
     * more.
     * 
     * <p>Only use this endpoint if you have provided Moov with a copy of your PCI attestation of compliance. 
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/cards.write` scope.
     * 
     * @return The call builder
     */
    public UpdateCardRequestBuilder update() {
        return new UpdateCardRequestBuilder(sdkConfiguration);
    }

    /**
     * Update a linked card and/or resubmit it for verification. 
     * 
     * <p>If a value is provided for CVV, a new verification ($0 authorization) will be submitted for the card. Updating the expiration 
     * date or 
     * address will update the information stored on file for the card but will not be verified.
     * 
     * <p>Read our [accept card payments guide](https://docs.moov.io/guides/sources/cards/accept-card-payments/#reverify-a-card) to learn 
     * more.
     * 
     * <p>Only use this endpoint if you have provided Moov with a copy of your PCI attestation of compliance. 
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/cards.write` scope.
     * 
     * @param accountID 
     * @param cardID 
     * @param updateCard 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public UpdateCardResponse update(
            String accountID, String cardID,
            UpdateCard updateCard) throws Exception {
        UpdateCardRequest request =
            UpdateCardRequest
                .builder()
                .accountID(accountID)
                .cardID(cardID)
                .updateCard(updateCard)
                .build();
        RequestOperation<UpdateCardRequest, UpdateCardResponse> operation
              = new UpdateCardOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Disables a card associated with a Moov account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/cards.write` scope.
     * 
     * @return The call builder
     */
    public DisableCardRequestBuilder disable() {
        return new DisableCardRequestBuilder(sdkConfiguration);
    }

    /**
     * Disables a card associated with a Moov account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/cards.write` scope.
     * 
     * @param accountID 
     * @param cardID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public DisableCardResponse disable(String accountID, String cardID) throws Exception {
        DisableCardRequest request =
            DisableCardRequest
                .builder()
                .accountID(accountID)
                .cardID(cardID)
                .build();
        RequestOperation<DisableCardRequest, DisableCardResponse> operation
              = new DisableCardOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

}
