/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk;

import static io.moov.sdk.operations.Operations.RequestOperation;

import io.moov.sdk.models.components.IssuedCardState;
import io.moov.sdk.models.components.RequestCard;
import io.moov.sdk.models.components.UpdateIssuedCard;
import io.moov.sdk.models.operations.GetFullIssuedCardRequest;
import io.moov.sdk.models.operations.GetFullIssuedCardRequestBuilder;
import io.moov.sdk.models.operations.GetFullIssuedCardResponse;
import io.moov.sdk.models.operations.GetIssuedCardRequest;
import io.moov.sdk.models.operations.GetIssuedCardRequestBuilder;
import io.moov.sdk.models.operations.GetIssuedCardResponse;
import io.moov.sdk.models.operations.ListIssuedCardsRequest;
import io.moov.sdk.models.operations.ListIssuedCardsRequestBuilder;
import io.moov.sdk.models.operations.ListIssuedCardsResponse;
import io.moov.sdk.models.operations.RequestCardRequest;
import io.moov.sdk.models.operations.RequestCardRequestBuilder;
import io.moov.sdk.models.operations.RequestCardResponse;
import io.moov.sdk.models.operations.UpdateIssuedCardRequest;
import io.moov.sdk.models.operations.UpdateIssuedCardRequestBuilder;
import io.moov.sdk.models.operations.UpdateIssuedCardResponse;
import io.moov.sdk.operations.GetFullIssuedCardOperation;
import io.moov.sdk.operations.GetIssuedCardOperation;
import io.moov.sdk.operations.ListIssuedCardsOperation;
import io.moov.sdk.operations.RequestCardOperation;
import io.moov.sdk.operations.UpdateIssuedCardOperation;
import java.lang.Exception;
import java.lang.Long;
import java.lang.String;
import java.util.List;
import java.util.Optional;


public class CardIssuing {
    private final SDKConfiguration sdkConfiguration;

    CardIssuing(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    /**
     * Request a virtual card be issued.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/issued-cards.write` scope.
     * 
     * @return The call builder
     */
    public RequestCardRequestBuilder request() {
        return new RequestCardRequestBuilder(sdkConfiguration);
    }

    /**
     * Request a virtual card be issued.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/issued-cards.write` scope.
     * 
     * @param accountID The Moov business account for which the card is to be issued.
     * @param requestCard 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public RequestCardResponse request(String accountID, RequestCard requestCard) throws Exception {
        RequestCardRequest request =
            RequestCardRequest
                .builder()
                .accountID(accountID)
                .requestCard(requestCard)
                .build();
        RequestOperation<RequestCardRequest, RequestCardResponse> operation
              = new RequestCardOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * List Moov issued cards existing for the account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/issued-cards.read` scope.
     * 
     * @return The call builder
     */
    public ListIssuedCardsRequestBuilder list() {
        return new ListIssuedCardsRequestBuilder(sdkConfiguration);
    }

    /**
     * List Moov issued cards existing for the account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/issued-cards.read` scope.
     * 
     * @param accountID The Moov business account for which the cards have been issued.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListIssuedCardsResponse list(String accountID) throws Exception {
        return list(accountID, Optional.empty(), Optional.empty(),
            Optional.empty());
    }

    /**
     * List Moov issued cards existing for the account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/issued-cards.read` scope.
     * 
     * @param accountID The Moov business account for which the cards have been issued.
     * @param skip 
     * @param count 
     * @param states Optional, comma-separated states to filter the Moov list issued cards response. For example `active,pending-verification`
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListIssuedCardsResponse list(
            String accountID, Optional<Long> skip,
            Optional<Long> count, Optional<? extends List<IssuedCardState>> states) throws Exception {
        ListIssuedCardsRequest request =
            ListIssuedCardsRequest
                .builder()
                .accountID(accountID)
                .skip(skip)
                .count(count)
                .states(states)
                .build();
        RequestOperation<ListIssuedCardsRequest, ListIssuedCardsResponse> operation
              = new ListIssuedCardsOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Retrieve a single issued card associated with a Moov account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/issued-cards.read` scope.
     * 
     * @return The call builder
     */
    public GetIssuedCardRequestBuilder get() {
        return new GetIssuedCardRequestBuilder(sdkConfiguration);
    }

    /**
     * Retrieve a single issued card associated with a Moov account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/issued-cards.read` scope.
     * 
     * @param accountID The Moov business account for which the card was issued.
     * @param issuedCardID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetIssuedCardResponse get(String accountID, String issuedCardID) throws Exception {
        GetIssuedCardRequest request =
            GetIssuedCardRequest
                .builder()
                .accountID(accountID)
                .issuedCardID(issuedCardID)
                .build();
        RequestOperation<GetIssuedCardRequest, GetIssuedCardResponse> operation
              = new GetIssuedCardOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Update a Moov issued card.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/issued-cards.write` scope.
     * 
     * @return The call builder
     */
    public UpdateIssuedCardRequestBuilder update() {
        return new UpdateIssuedCardRequestBuilder(sdkConfiguration);
    }

    /**
     * Update a Moov issued card.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/issued-cards.write` scope.
     * 
     * @param accountID The Moov business account for which the card was issued.
     * @param issuedCardID 
     * @param updateIssuedCard 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public UpdateIssuedCardResponse update(
            String accountID, String issuedCardID,
            UpdateIssuedCard updateIssuedCard) throws Exception {
        UpdateIssuedCardRequest request =
            UpdateIssuedCardRequest
                .builder()
                .accountID(accountID)
                .issuedCardID(issuedCardID)
                .updateIssuedCard(updateIssuedCard)
                .build();
        RequestOperation<UpdateIssuedCardRequest, UpdateIssuedCardResponse> operation
              = new UpdateIssuedCardOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Get issued card with PAN, CVV, and expiration. 
     * 
     * <p>Only use this endpoint if you have provided Moov with a copy of your PCI attestation of compliance.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/issued-cards.read-secure` scope.
     * 
     * @return The call builder
     */
    public GetFullIssuedCardRequestBuilder getFull() {
        return new GetFullIssuedCardRequestBuilder(sdkConfiguration);
    }

    /**
     * Get issued card with PAN, CVV, and expiration. 
     * 
     * <p>Only use this endpoint if you have provided Moov with a copy of your PCI attestation of compliance.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/issued-cards.read-secure` scope.
     * 
     * @param accountID The Moov business account for which the card was issued.
     * @param issuedCardID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetFullIssuedCardResponse getFull(String accountID, String issuedCardID) throws Exception {
        GetFullIssuedCardRequest request =
            GetFullIssuedCardRequest
                .builder()
                .accountID(accountID)
                .issuedCardID(issuedCardID)
                .build();
        RequestOperation<GetFullIssuedCardRequest, GetFullIssuedCardResponse> operation
              = new GetFullIssuedCardOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

}
