/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk;

import static io.moov.sdk.operations.Operations.RequestOperation;

import io.moov.sdk.models.components.AddCapabilities;
import io.moov.sdk.models.components.CapabilityID;
import io.moov.sdk.models.operations.DisableCapabilityRequest;
import io.moov.sdk.models.operations.DisableCapabilityRequestBuilder;
import io.moov.sdk.models.operations.DisableCapabilityResponse;
import io.moov.sdk.models.operations.GetCapabilityRequest;
import io.moov.sdk.models.operations.GetCapabilityRequestBuilder;
import io.moov.sdk.models.operations.GetCapabilityResponse;
import io.moov.sdk.models.operations.ListCapabilitiesRequest;
import io.moov.sdk.models.operations.ListCapabilitiesRequestBuilder;
import io.moov.sdk.models.operations.ListCapabilitiesResponse;
import io.moov.sdk.models.operations.RequestCapabilitiesRequest;
import io.moov.sdk.models.operations.RequestCapabilitiesRequestBuilder;
import io.moov.sdk.models.operations.RequestCapabilitiesResponse;
import io.moov.sdk.operations.DisableCapabilityOperation;
import io.moov.sdk.operations.GetCapabilityOperation;
import io.moov.sdk.operations.ListCapabilitiesOperation;
import io.moov.sdk.operations.RequestCapabilitiesOperation;
import java.lang.Exception;
import java.lang.String;


public class Capabilities {
    private final SDKConfiguration sdkConfiguration;

    Capabilities(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    /**
     * Retrieve all the capabilities an account has requested.
     * 
     * <p>Read our [capabilities guide](https://docs.moov.io/guides/accounts/capabilities/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/capabilities.read` scope.
     * 
     * @return The call builder
     */
    public ListCapabilitiesRequestBuilder list() {
        return new ListCapabilitiesRequestBuilder(sdkConfiguration);
    }

    /**
     * Retrieve all the capabilities an account has requested.
     * 
     * <p>Read our [capabilities guide](https://docs.moov.io/guides/accounts/capabilities/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/capabilities.read` scope.
     * 
     * @param accountID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListCapabilitiesResponse list(String accountID) throws Exception {
        ListCapabilitiesRequest request =
            ListCapabilitiesRequest
                .builder()
                .accountID(accountID)
                .build();
        RequestOperation<ListCapabilitiesRequest, ListCapabilitiesResponse> operation
              = new ListCapabilitiesOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Request capabilities for a specific account. Read our [capabilities guide](https://docs.moov.io/guides/accounts/capabilities/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/capabilities.write` scope.
     * 
     * @return The call builder
     */
    public RequestCapabilitiesRequestBuilder request() {
        return new RequestCapabilitiesRequestBuilder(sdkConfiguration);
    }

    /**
     * Request capabilities for a specific account. Read our [capabilities guide](https://docs.moov.io/guides/accounts/capabilities/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/capabilities.write` scope.
     * 
     * @param accountID 
     * @param addCapabilities 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public RequestCapabilitiesResponse request(String accountID, AddCapabilities addCapabilities) throws Exception {
        RequestCapabilitiesRequest request =
            RequestCapabilitiesRequest
                .builder()
                .accountID(accountID)
                .addCapabilities(addCapabilities)
                .build();
        RequestOperation<RequestCapabilitiesRequest, RequestCapabilitiesResponse> operation
              = new RequestCapabilitiesOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Retrieve a specific capability that an account has requested. Read our [capabilities guide](https://docs.moov.io/guides/accounts/capabilities/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/capabilities.read` scope.
     * 
     * @return The call builder
     */
    public GetCapabilityRequestBuilder get() {
        return new GetCapabilityRequestBuilder(sdkConfiguration);
    }

    /**
     * Retrieve a specific capability that an account has requested. Read our [capabilities guide](https://docs.moov.io/guides/accounts/capabilities/) to learn more.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/capabilities.read` scope.
     * 
     * @param accountID 
     * @param capabilityID Moov account capabilities.
     *         
     *         The `production-app`, `platform.production-app`, and / or `platform.wallet-transfers` capabilities might appear in your list. These are read-only capabilities that Moov requests and uses for account verification purposes. These capabilities remains active with your account and require no additional action.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetCapabilityResponse get(String accountID, CapabilityID capabilityID) throws Exception {
        GetCapabilityRequest request =
            GetCapabilityRequest
                .builder()
                .accountID(accountID)
                .capabilityID(capabilityID)
                .build();
        RequestOperation<GetCapabilityRequest, GetCapabilityResponse> operation
              = new GetCapabilityOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Disable a specific capability that an account has requested. Read our [capabilities guide](https://docs.moov.io/guides/accounts/capabilities/) to learn more.
     * 
     * <p>  To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/capabilities.write` scope.
     * 
     * @return The call builder
     */
    public DisableCapabilityRequestBuilder disable() {
        return new DisableCapabilityRequestBuilder(sdkConfiguration);
    }

    /**
     * Disable a specific capability that an account has requested. Read our [capabilities guide](https://docs.moov.io/guides/accounts/capabilities/) to learn more.
     * 
     * <p>  To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/capabilities.write` scope.
     * 
     * @param accountID 
     * @param capabilityID Moov account capabilities.
     *         
     *         The `production-app`, `platform.production-app`, and / or `platform.wallet-transfers` capabilities might appear in your list. These are read-only capabilities that Moov requests and uses for account verification purposes. These capabilities remains active with your account and require no additional action.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public DisableCapabilityResponse disable(String accountID, CapabilityID capabilityID) throws Exception {
        DisableCapabilityRequest request =
            DisableCapabilityRequest
                .builder()
                .accountID(accountID)
                .capabilityID(capabilityID)
                .build();
        RequestOperation<DisableCapabilityRequest, DisableCapabilityResponse> operation
              = new DisableCapabilityOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

}
