/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk;

import static io.moov.sdk.operations.Operations.RequestOperation;

import io.moov.sdk.models.components.BrandProperties;
import io.moov.sdk.models.components.UpdateBrand;
import io.moov.sdk.models.operations.CreateBrandRequest;
import io.moov.sdk.models.operations.CreateBrandRequestBuilder;
import io.moov.sdk.models.operations.CreateBrandResponse;
import io.moov.sdk.models.operations.GetBrandRequest;
import io.moov.sdk.models.operations.GetBrandRequestBuilder;
import io.moov.sdk.models.operations.GetBrandResponse;
import io.moov.sdk.models.operations.UpdateBrandRequest;
import io.moov.sdk.models.operations.UpdateBrandRequestBuilder;
import io.moov.sdk.models.operations.UpdateBrandResponse;
import io.moov.sdk.models.operations.UpsertBrandRequest;
import io.moov.sdk.models.operations.UpsertBrandRequestBuilder;
import io.moov.sdk.models.operations.UpsertBrandResponse;
import io.moov.sdk.operations.CreateBrandOperation;
import io.moov.sdk.operations.GetBrandOperation;
import io.moov.sdk.operations.UpdateBrandOperation;
import io.moov.sdk.operations.UpsertBrandOperation;
import java.lang.Exception;
import java.lang.String;


public class Branding {
    private final SDKConfiguration sdkConfiguration;

    Branding(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    /**
     * Create brand properties for the specified account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/branding.write` scope.
     * 
     * @return The call builder
     */
    public CreateBrandRequestBuilder create() {
        return new CreateBrandRequestBuilder(sdkConfiguration);
    }

    /**
     * Create brand properties for the specified account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/branding.write` scope.
     * 
     * @param accountID 
     * @param brandProperties 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public CreateBrandResponse create(String accountID, BrandProperties brandProperties) throws Exception {
        CreateBrandRequest request =
            CreateBrandRequest
                .builder()
                .accountID(accountID)
                .brandProperties(brandProperties)
                .build();
        RequestOperation<CreateBrandRequest, CreateBrandResponse> operation
              = new CreateBrandOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Create or replace brand properties for the specified account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/branding.write` scope.
     * 
     * @return The call builder
     */
    public UpsertBrandRequestBuilder upsert() {
        return new UpsertBrandRequestBuilder(sdkConfiguration);
    }

    /**
     * Create or replace brand properties for the specified account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/branding.write` scope.
     * 
     * @param accountID 
     * @param brandProperties 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public UpsertBrandResponse upsert(String accountID, BrandProperties brandProperties) throws Exception {
        UpsertBrandRequest request =
            UpsertBrandRequest
                .builder()
                .accountID(accountID)
                .brandProperties(brandProperties)
                .build();
        RequestOperation<UpsertBrandRequest, UpsertBrandResponse> operation
              = new UpsertBrandOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Get brand properties for the specified account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/branding.read` scope.
     * 
     * @return The call builder
     */
    public GetBrandRequestBuilder get() {
        return new GetBrandRequestBuilder(sdkConfiguration);
    }

    /**
     * Get brand properties for the specified account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/branding.read` scope.
     * 
     * @param accountID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetBrandResponse get(String accountID) throws Exception {
        GetBrandRequest request =
            GetBrandRequest
                .builder()
                .accountID(accountID)
                .build();
        RequestOperation<GetBrandRequest, GetBrandResponse> operation
              = new GetBrandOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Updates the brand properties for the specified account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/branding.write` scope.
     * 
     * @return The call builder
     */
    public UpdateBrandRequestBuilder update() {
        return new UpdateBrandRequestBuilder(sdkConfiguration);
    }

    /**
     * Updates the brand properties for the specified account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/branding.write` scope.
     * 
     * @param accountID 
     * @param updateBrand 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public UpdateBrandResponse update(String accountID, UpdateBrand updateBrand) throws Exception {
        UpdateBrandRequest request =
            UpdateBrandRequest
                .builder()
                .accountID(accountID)
                .updateBrand(updateBrand)
                .build();
        RequestOperation<UpdateBrandRequest, UpdateBrandResponse> operation
              = new UpdateBrandOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

}
