/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk;

import static io.moov.sdk.operations.Operations.RequestOperation;

import io.moov.sdk.models.components.BankAccountWaitFor;
import io.moov.sdk.models.components.CompleteBankAccountVerification;
import io.moov.sdk.models.components.CompleteMicroDeposits;
import io.moov.sdk.models.components.LinkBankAccount;
import io.moov.sdk.models.operations.CompleteBankAccountVerificationRequest;
import io.moov.sdk.models.operations.CompleteBankAccountVerificationRequestBuilder;
import io.moov.sdk.models.operations.CompleteBankAccountVerificationResponse;
import io.moov.sdk.models.operations.CompleteMicroDepositsRequest;
import io.moov.sdk.models.operations.CompleteMicroDepositsRequestBuilder;
import io.moov.sdk.models.operations.CompleteMicroDepositsResponse;
import io.moov.sdk.models.operations.DisableBankAccountRequest;
import io.moov.sdk.models.operations.DisableBankAccountRequestBuilder;
import io.moov.sdk.models.operations.DisableBankAccountResponse;
import io.moov.sdk.models.operations.GetBankAccountRequest;
import io.moov.sdk.models.operations.GetBankAccountRequestBuilder;
import io.moov.sdk.models.operations.GetBankAccountResponse;
import io.moov.sdk.models.operations.GetBankAccountVerificationRequest;
import io.moov.sdk.models.operations.GetBankAccountVerificationRequestBuilder;
import io.moov.sdk.models.operations.GetBankAccountVerificationResponse;
import io.moov.sdk.models.operations.InitiateBankAccountVerificationRequest;
import io.moov.sdk.models.operations.InitiateBankAccountVerificationRequestBuilder;
import io.moov.sdk.models.operations.InitiateBankAccountVerificationResponse;
import io.moov.sdk.models.operations.InitiateMicroDepositsRequest;
import io.moov.sdk.models.operations.InitiateMicroDepositsRequestBuilder;
import io.moov.sdk.models.operations.InitiateMicroDepositsResponse;
import io.moov.sdk.models.operations.LinkBankAccountRequest;
import io.moov.sdk.models.operations.LinkBankAccountRequestBuilder;
import io.moov.sdk.models.operations.LinkBankAccountResponse;
import io.moov.sdk.models.operations.ListBankAccountsRequest;
import io.moov.sdk.models.operations.ListBankAccountsRequestBuilder;
import io.moov.sdk.models.operations.ListBankAccountsResponse;
import io.moov.sdk.operations.CompleteBankAccountVerificationOperation;
import io.moov.sdk.operations.CompleteMicroDepositsOperation;
import io.moov.sdk.operations.DisableBankAccountOperation;
import io.moov.sdk.operations.GetBankAccountOperation;
import io.moov.sdk.operations.GetBankAccountVerificationOperation;
import io.moov.sdk.operations.InitiateBankAccountVerificationOperation;
import io.moov.sdk.operations.InitiateMicroDepositsOperation;
import io.moov.sdk.operations.LinkBankAccountOperation;
import io.moov.sdk.operations.ListBankAccountsOperation;
import java.lang.Exception;
import java.lang.String;
import java.util.Optional;


public class BankAccounts {
    private final SDKConfiguration sdkConfiguration;

    BankAccounts(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    /**
     * Link a bank account to an existing Moov account. Read our [bank accounts guide](https://docs.moov.io/guides/sources/bank-accounts/) to learn more.
     * 
     * <p>It is strongly recommended that callers include the `X-Wait-For` header, set to `payment-method`, if the newly linked
     * bank-account is intended to be used right away. If this header is not included, the caller will need to poll the [List Payment
     * Methods](https://docs.moov.io/api/sources/payment-methods/list/)
     * endpoint to wait for the new payment methods to be available for use.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/bank-accounts.write` scope.
     * 
     * @return The call builder
     */
    public LinkBankAccountRequestBuilder link() {
        return new LinkBankAccountRequestBuilder(sdkConfiguration);
    }

    /**
     * Link a bank account to an existing Moov account. Read our [bank accounts guide](https://docs.moov.io/guides/sources/bank-accounts/) to learn more.
     * 
     * <p>It is strongly recommended that callers include the `X-Wait-For` header, set to `payment-method`, if the newly linked
     * bank-account is intended to be used right away. If this header is not included, the caller will need to poll the [List Payment
     * Methods](https://docs.moov.io/api/sources/payment-methods/list/)
     * endpoint to wait for the new payment methods to be available for use.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/bank-accounts.write` scope.
     * 
     * @param accountID 
     * @param linkBankAccount 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public LinkBankAccountResponse link(String accountID, LinkBankAccount linkBankAccount) throws Exception {
        return link(Optional.empty(), accountID, linkBankAccount);
    }

    /**
     * Link a bank account to an existing Moov account. Read our [bank accounts guide](https://docs.moov.io/guides/sources/bank-accounts/) to learn more.
     * 
     * <p>It is strongly recommended that callers include the `X-Wait-For` header, set to `payment-method`, if the newly linked
     * bank-account is intended to be used right away. If this header is not included, the caller will need to poll the [List Payment
     * Methods](https://docs.moov.io/api/sources/payment-methods/list/)
     * endpoint to wait for the new payment methods to be available for use.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/bank-accounts.write` scope.
     * 
     * @param xWaitFor 
     * @param accountID 
     * @param linkBankAccount 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public LinkBankAccountResponse link(
            Optional<? extends BankAccountWaitFor> xWaitFor, String accountID,
            LinkBankAccount linkBankAccount) throws Exception {
        LinkBankAccountRequest request =
            LinkBankAccountRequest
                .builder()
                .xWaitFor(xWaitFor)
                .accountID(accountID)
                .linkBankAccount(linkBankAccount)
                .build();
        RequestOperation<LinkBankAccountRequest, LinkBankAccountResponse> operation
              = new LinkBankAccountOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * List all the bank accounts associated with a particular Moov account. 
     * 
     * <p>Read our [bank accounts guide](https://docs.moov.io/guides/sources/bank-accounts/) to learn more. 
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/bank-accounts.read` scope.
     * 
     * @return The call builder
     */
    public ListBankAccountsRequestBuilder list() {
        return new ListBankAccountsRequestBuilder(sdkConfiguration);
    }

    /**
     * List all the bank accounts associated with a particular Moov account. 
     * 
     * <p>Read our [bank accounts guide](https://docs.moov.io/guides/sources/bank-accounts/) to learn more. 
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/bank-accounts.read` scope.
     * 
     * @param accountID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListBankAccountsResponse list(String accountID) throws Exception {
        ListBankAccountsRequest request =
            ListBankAccountsRequest
                .builder()
                .accountID(accountID)
                .build();
        RequestOperation<ListBankAccountsRequest, ListBankAccountsResponse> operation
              = new ListBankAccountsOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Retrieve bank account details (i.e. routing number or account type) associated with a specific Moov account. 
     * 
     * <p>Read our [bank accounts guide](https://docs.moov.io/guides/sources/bank-accounts/) to learn more. 
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/bank-accounts.read` scope.
     * 
     * @return The call builder
     */
    public GetBankAccountRequestBuilder get() {
        return new GetBankAccountRequestBuilder(sdkConfiguration);
    }

    /**
     * Retrieve bank account details (i.e. routing number or account type) associated with a specific Moov account. 
     * 
     * <p>Read our [bank accounts guide](https://docs.moov.io/guides/sources/bank-accounts/) to learn more. 
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/bank-accounts.read` scope.
     * 
     * @param accountID 
     * @param bankAccountID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetBankAccountResponse get(String accountID, String bankAccountID) throws Exception {
        GetBankAccountRequest request =
            GetBankAccountRequest
                .builder()
                .accountID(accountID)
                .bankAccountID(bankAccountID)
                .build();
        RequestOperation<GetBankAccountRequest, GetBankAccountResponse> operation
              = new GetBankAccountOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Discontinue using a specified bank account linked to a Moov account. 
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/bank-accounts.write` scope.
     * 
     * @return The call builder
     */
    public DisableBankAccountRequestBuilder disable() {
        return new DisableBankAccountRequestBuilder(sdkConfiguration);
    }

    /**
     * Discontinue using a specified bank account linked to a Moov account. 
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/bank-accounts.write` scope.
     * 
     * @param accountID 
     * @param bankAccountID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public DisableBankAccountResponse disable(String accountID, String bankAccountID) throws Exception {
        DisableBankAccountRequest request =
            DisableBankAccountRequest
                .builder()
                .accountID(accountID)
                .bankAccountID(bankAccountID)
                .build();
        RequestOperation<DisableBankAccountRequest, DisableBankAccountResponse> operation
              = new DisableBankAccountOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Micro-deposits help confirm bank account ownership, helping reduce fraud and the risk of unauthorized activity. 
     * Use this method to initiate the micro-deposit verification, sending two small credit transfers to the bank account 
     * you want to confirm.
     * 
     * <p>If you request micro-deposits before 4:15PM ET, they will appear that same day. If you request micro-deposits any 
     * time after 4:15PM ET, they will appear the next banking day. When the two credits are initiated, Moov simultaneously
     * initiates a debit to recoup the micro-deposits. 
     * 
     * <p>Micro-deposits initiated for a `sandbox` bank account will always be `$0.00` / `$0.00` and instantly verifiable once initiated.
     * 
     * <p>You can simulate micro-deposit verification in test mode. See our [test mode](https://docs.moov.io/guides/get-started/test-mode/#micro-deposits)
     * guide for more information.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/bank-accounts.write` scope.
     * 
     * @return The call builder
     */
    public InitiateMicroDepositsRequestBuilder initiateMicroDeposits() {
        return new InitiateMicroDepositsRequestBuilder(sdkConfiguration);
    }

    /**
     * Micro-deposits help confirm bank account ownership, helping reduce fraud and the risk of unauthorized activity. 
     * Use this method to initiate the micro-deposit verification, sending two small credit transfers to the bank account 
     * you want to confirm.
     * 
     * <p>If you request micro-deposits before 4:15PM ET, they will appear that same day. If you request micro-deposits any 
     * time after 4:15PM ET, they will appear the next banking day. When the two credits are initiated, Moov simultaneously
     * initiates a debit to recoup the micro-deposits. 
     * 
     * <p>Micro-deposits initiated for a `sandbox` bank account will always be `$0.00` / `$0.00` and instantly verifiable once initiated.
     * 
     * <p>You can simulate micro-deposit verification in test mode. See our [test mode](https://docs.moov.io/guides/get-started/test-mode/#micro-deposits)
     * guide for more information.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/bank-accounts.write` scope.
     * 
     * @param accountID 
     * @param bankAccountID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public InitiateMicroDepositsResponse initiateMicroDeposits(String accountID, String bankAccountID) throws Exception {
        InitiateMicroDepositsRequest request =
            InitiateMicroDepositsRequest
                .builder()
                .accountID(accountID)
                .bankAccountID(bankAccountID)
                .build();
        RequestOperation<InitiateMicroDepositsRequest, InitiateMicroDepositsResponse> operation
              = new InitiateMicroDepositsOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Complete the micro-deposit validation process by passing the amounts of the two transfers within three tries.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/bank-accounts.write` scope.
     * 
     * @return The call builder
     */
    public CompleteMicroDepositsRequestBuilder completeMicroDeposits() {
        return new CompleteMicroDepositsRequestBuilder(sdkConfiguration);
    }

    /**
     * Complete the micro-deposit validation process by passing the amounts of the two transfers within three tries.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/bank-accounts.write` scope.
     * 
     * @param accountID 
     * @param bankAccountID 
     * @param completeMicroDeposits Request to complete the micro-deposit verification workflow.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public CompleteMicroDepositsResponse completeMicroDeposits(
            String accountID, String bankAccountID,
            CompleteMicroDeposits completeMicroDeposits) throws Exception {
        CompleteMicroDepositsRequest request =
            CompleteMicroDepositsRequest
                .builder()
                .accountID(accountID)
                .bankAccountID(bankAccountID)
                .completeMicroDeposits(completeMicroDeposits)
                .build();
        RequestOperation<CompleteMicroDepositsRequest, CompleteMicroDepositsResponse> operation
              = new CompleteMicroDepositsOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Retrieve the current status and details of an instant verification, including whether the verification method was instant or same-day 
     * ACH. This helps track the verification process in real-time and provides details in case of exceptions.
     * 
     * <p>The status will indicate the following:
     * 
     * <p>- `new`: Verification initiated, credit pending to the payment network
     * - `sent-credit`: Credit sent, available for verification
     * - `failed`: Verification failed, description provided, user needs to add a new bank account
     * - `expired`: Verification expired after 14 days, initiate another verification
     * - `max-attempts-exceeded`: Five incorrect code attempts exhausted, initiate another verification
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/bank-accounts.read` scope.
     * 
     * @return The call builder
     */
    public GetBankAccountVerificationRequestBuilder getVerification() {
        return new GetBankAccountVerificationRequestBuilder(sdkConfiguration);
    }

    /**
     * Retrieve the current status and details of an instant verification, including whether the verification method was instant or same-day 
     * ACH. This helps track the verification process in real-time and provides details in case of exceptions.
     * 
     * <p>The status will indicate the following:
     * 
     * <p>- `new`: Verification initiated, credit pending to the payment network
     * - `sent-credit`: Credit sent, available for verification
     * - `failed`: Verification failed, description provided, user needs to add a new bank account
     * - `expired`: Verification expired after 14 days, initiate another verification
     * - `max-attempts-exceeded`: Five incorrect code attempts exhausted, initiate another verification
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/bank-accounts.read` scope.
     * 
     * @param accountID 
     * @param bankAccountID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetBankAccountVerificationResponse getVerification(String accountID, String bankAccountID) throws Exception {
        GetBankAccountVerificationRequest request =
            GetBankAccountVerificationRequest
                .builder()
                .accountID(accountID)
                .bankAccountID(bankAccountID)
                .build();
        RequestOperation<GetBankAccountVerificationRequest, GetBankAccountVerificationResponse> operation
              = new GetBankAccountVerificationOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Instant micro-deposit verification offers a quick and efficient way to verify bank account ownership. 
     * 
     * <p>Send a $0.01 credit with a unique verification code via RTP or same-day ACH, depending on the receiving bank's capabilities. This
     * feature provides a faster alternative to traditional methods, allowing verification in a single session.
     * 
     * <p>It is recommended to use the `X-Wait-For: rail-response` header to synchronously receive the outcome of the instant credit in the
     *   response payload.
     * 
     * <p>Possible verification methods:
     *   - `instant`: Real-time verification credit sent via RTP
     *   - `ach`: Verification credit sent via same-day ACH
     * 
     * <p>Possible statuses:
     *   - `new`: Verification initiated, credit pending
     *   - `sent-credit`: Credit sent, available for verification in the external bank account
     *   - `failed`: Verification failed due to credit rejection/return, details in `exceptionDetails`
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/bank-accounts.write` scope.
     * 
     * @return The call builder
     */
    public InitiateBankAccountVerificationRequestBuilder initiateVerification() {
        return new InitiateBankAccountVerificationRequestBuilder(sdkConfiguration);
    }

    /**
     * Instant micro-deposit verification offers a quick and efficient way to verify bank account ownership. 
     * 
     * <p>Send a $0.01 credit with a unique verification code via RTP or same-day ACH, depending on the receiving bank's capabilities. This
     * feature provides a faster alternative to traditional methods, allowing verification in a single session.
     * 
     * <p>It is recommended to use the `X-Wait-For: rail-response` header to synchronously receive the outcome of the instant credit in the
     *   response payload.
     * 
     * <p>Possible verification methods:
     *   - `instant`: Real-time verification credit sent via RTP
     *   - `ach`: Verification credit sent via same-day ACH
     * 
     * <p>Possible statuses:
     *   - `new`: Verification initiated, credit pending
     *   - `sent-credit`: Credit sent, available for verification in the external bank account
     *   - `failed`: Verification failed due to credit rejection/return, details in `exceptionDetails`
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/bank-accounts.write` scope.
     * 
     * @param accountID 
     * @param bankAccountID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public InitiateBankAccountVerificationResponse initiateVerification(String accountID, String bankAccountID) throws Exception {
        return initiateVerification(Optional.empty(), accountID, bankAccountID);
    }

    /**
     * Instant micro-deposit verification offers a quick and efficient way to verify bank account ownership. 
     * 
     * <p>Send a $0.01 credit with a unique verification code via RTP or same-day ACH, depending on the receiving bank's capabilities. This
     * feature provides a faster alternative to traditional methods, allowing verification in a single session.
     * 
     * <p>It is recommended to use the `X-Wait-For: rail-response` header to synchronously receive the outcome of the instant credit in the
     *   response payload.
     * 
     * <p>Possible verification methods:
     *   - `instant`: Real-time verification credit sent via RTP
     *   - `ach`: Verification credit sent via same-day ACH
     * 
     * <p>Possible statuses:
     *   - `new`: Verification initiated, credit pending
     *   - `sent-credit`: Credit sent, available for verification in the external bank account
     *   - `failed`: Verification failed due to credit rejection/return, details in `exceptionDetails`
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/bank-accounts.write` scope.
     * 
     * @param xWaitFor 
     * @param accountID 
     * @param bankAccountID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public InitiateBankAccountVerificationResponse initiateVerification(
            Optional<? extends BankAccountWaitFor> xWaitFor, String accountID,
            String bankAccountID) throws Exception {
        InitiateBankAccountVerificationRequest request =
            InitiateBankAccountVerificationRequest
                .builder()
                .xWaitFor(xWaitFor)
                .accountID(accountID)
                .bankAccountID(bankAccountID)
                .build();
        RequestOperation<InitiateBankAccountVerificationRequest, InitiateBankAccountVerificationResponse> operation
              = new InitiateBankAccountVerificationOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Finalize the instant micro-deposit verification by submitting the verification code displayed in the user's bank account. 
     * 
     * <p>Upon successful verification, the bank account status will be updated to `verified` and eligible for ACH debit transactions.
     * 
     * <p>The following formats are accepted:
     * - `MV0000`
     * - `mv0000`
     * - `0000`
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/bank-accounts.write` scope.
     * 
     * @return The call builder
     */
    public CompleteBankAccountVerificationRequestBuilder completeVerification() {
        return new CompleteBankAccountVerificationRequestBuilder(sdkConfiguration);
    }

    /**
     * Finalize the instant micro-deposit verification by submitting the verification code displayed in the user's bank account. 
     * 
     * <p>Upon successful verification, the bank account status will be updated to `verified` and eligible for ACH debit transactions.
     * 
     * <p>The following formats are accepted:
     * - `MV0000`
     * - `mv0000`
     * - `0000`
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/bank-accounts.write` scope.
     * 
     * @param accountID 
     * @param bankAccountID 
     * @param completeBankAccountVerification 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public CompleteBankAccountVerificationResponse completeVerification(
            String accountID, String bankAccountID,
            CompleteBankAccountVerification completeBankAccountVerification) throws Exception {
        CompleteBankAccountVerificationRequest request =
            CompleteBankAccountVerificationRequest
                .builder()
                .accountID(accountID)
                .bankAccountID(bankAccountID)
                .completeBankAccountVerification(completeBankAccountVerification)
                .build();
        RequestOperation<CompleteBankAccountVerificationRequest, CompleteBankAccountVerificationResponse> operation
              = new CompleteBankAccountVerificationOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

}
