/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk;

import static io.moov.sdk.operations.Operations.RequestOperation;

import io.moov.sdk.models.operations.GetAvatarRequest;
import io.moov.sdk.models.operations.GetAvatarRequestBuilder;
import io.moov.sdk.models.operations.GetAvatarResponse;
import io.moov.sdk.operations.GetAvatarOperation;
import java.lang.Exception;
import java.lang.String;


public class Avatars {
    private final SDKConfiguration sdkConfiguration;

    Avatars(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    /**
     * Get avatar image for an account using a unique ID.    
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/profile-enrichment.read` scope.
     * 
     * @return The call builder
     */
    public GetAvatarRequestBuilder get() {
        return new GetAvatarRequestBuilder(sdkConfiguration);
    }

    /**
     * Get avatar image for an account using a unique ID.    
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/profile-enrichment.read` scope.
     * 
     * @param uniqueID Any unique ID associated with an account such as accountID, representativeID, routing number, or userID.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetAvatarResponse get(String uniqueID) throws Exception {
        GetAvatarRequest request =
            GetAvatarRequest
                .builder()
                .uniqueID(uniqueID)
                .build();
        RequestOperation<GetAvatarRequest, GetAvatarResponse> operation
              = new GetAvatarOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

}
