/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk;

import static io.moov.sdk.operations.Operations.RequestOperation;

import io.moov.sdk.models.components.AuthTokenRequest;
import io.moov.sdk.models.components.RevokeTokenRequest;
import io.moov.sdk.models.components.TokenTypeHint;
import io.moov.sdk.models.operations.CreateAccessTokenRequestBuilder;
import io.moov.sdk.models.operations.CreateAccessTokenResponse;
import io.moov.sdk.models.operations.RevokeAccessTokenRequestBuilder;
import io.moov.sdk.models.operations.RevokeAccessTokenResponse;
import io.moov.sdk.operations.CreateAccessTokenOperation;
import io.moov.sdk.operations.RevokeAccessTokenOperation;
import java.lang.Exception;
import java.lang.String;
import java.util.Optional;


public class Authentication {
    private final SDKConfiguration sdkConfiguration;

    Authentication(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    /**
     * Revoke an auth token.
     * 
     * <p>Allows clients to notify the authorization server that a previously obtained refresh or access token is no longer needed.
     * 
     * @return The call builder
     */
    public RevokeAccessTokenRequestBuilder revokeAccessToken() {
        return new RevokeAccessTokenRequestBuilder(sdkConfiguration);
    }

    /**
     * Revoke an auth token.
     * 
     * <p>Allows clients to notify the authorization server that a previously obtained refresh or access token is no longer needed.
     * 
     * @param token 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public RevokeAccessTokenResponse revokeAccessToken(String token) throws Exception {
        return revokeAccessToken(token, Optional.empty(), Optional.empty(),
            Optional.empty());
    }

    /**
     * Revoke an auth token.
     * 
     * <p>Allows clients to notify the authorization server that a previously obtained refresh or access token is no longer needed.
     * 
     * @param token 
     * @param tokenTypeHint The type of token being revoked.
     * @param clientId 
     * @param clientSecret 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public RevokeAccessTokenResponse revokeAccessToken(
            String token, Optional<? extends TokenTypeHint> tokenTypeHint,
            Optional<String> clientId, Optional<String> clientSecret) throws Exception {
        RevokeTokenRequest request =
            RevokeTokenRequest
                .builder()
                .token(token)
                .tokenTypeHint(tokenTypeHint)
                .clientId(clientId)
                .clientSecret(clientSecret)
                .build();
        RequestOperation<RevokeTokenRequest, RevokeAccessTokenResponse> operation
              = new RevokeAccessTokenOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Create or refresh an access token.
     * 
     * @return The call builder
     */
    public CreateAccessTokenRequestBuilder createAccessToken() {
        return new CreateAccessTokenRequestBuilder(sdkConfiguration);
    }

    /**
     * Create or refresh an access token.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public CreateAccessTokenResponse createAccessToken(AuthTokenRequest request) throws Exception {
        RequestOperation<AuthTokenRequest, CreateAccessTokenResponse> operation
              = new CreateAccessTokenOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

}
