/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk;

import static io.moov.sdk.operations.Operations.RequestOperation;

import io.moov.sdk.models.components.CreateApplePaySession;
import io.moov.sdk.models.components.LinkApplePay;
import io.moov.sdk.models.components.RegisterApplePayMerchantDomains;
import io.moov.sdk.models.components.UpdateApplePayMerchantDomains;
import io.moov.sdk.models.operations.CreateApplePaySessionRequest;
import io.moov.sdk.models.operations.CreateApplePaySessionRequestBuilder;
import io.moov.sdk.models.operations.CreateApplePaySessionResponse;
import io.moov.sdk.models.operations.GetApplePayMerchantDomainsRequest;
import io.moov.sdk.models.operations.GetApplePayMerchantDomainsRequestBuilder;
import io.moov.sdk.models.operations.GetApplePayMerchantDomainsResponse;
import io.moov.sdk.models.operations.LinkApplePayTokenRequest;
import io.moov.sdk.models.operations.LinkApplePayTokenRequestBuilder;
import io.moov.sdk.models.operations.LinkApplePayTokenResponse;
import io.moov.sdk.models.operations.RegisterApplePayMerchantDomainsRequest;
import io.moov.sdk.models.operations.RegisterApplePayMerchantDomainsRequestBuilder;
import io.moov.sdk.models.operations.RegisterApplePayMerchantDomainsResponse;
import io.moov.sdk.models.operations.UpdateApplePayMerchantDomainsRequest;
import io.moov.sdk.models.operations.UpdateApplePayMerchantDomainsRequestBuilder;
import io.moov.sdk.models.operations.UpdateApplePayMerchantDomainsResponse;
import io.moov.sdk.operations.CreateApplePaySessionOperation;
import io.moov.sdk.operations.GetApplePayMerchantDomainsOperation;
import io.moov.sdk.operations.LinkApplePayTokenOperation;
import io.moov.sdk.operations.RegisterApplePayMerchantDomainsOperation;
import io.moov.sdk.operations.UpdateApplePayMerchantDomainsOperation;
import java.lang.Exception;
import java.lang.String;


public class ApplePay {
    private final SDKConfiguration sdkConfiguration;

    ApplePay(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    /**
     * Add domains to be registered with Apple Pay.
     * 
     * <p>Any domains that will be used to accept payments must first be [verified](https://docs.moov.io/guides/sources/cards/apple-pay/#register-your-domains) 
     * with Apple.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/apple-pay.write` scope.
     * 
     * @return The call builder
     */
    public RegisterApplePayMerchantDomainsRequestBuilder registerMerchantDomains() {
        return new RegisterApplePayMerchantDomainsRequestBuilder(sdkConfiguration);
    }

    /**
     * Add domains to be registered with Apple Pay.
     * 
     * <p>Any domains that will be used to accept payments must first be [verified](https://docs.moov.io/guides/sources/cards/apple-pay/#register-your-domains) 
     * with Apple.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/apple-pay.write` scope.
     * 
     * @param accountID ID of the Moov account representing the merchant.
     * @param registerApplePayMerchantDomains 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public RegisterApplePayMerchantDomainsResponse registerMerchantDomains(String accountID, RegisterApplePayMerchantDomains registerApplePayMerchantDomains) throws Exception {
        RegisterApplePayMerchantDomainsRequest request =
            RegisterApplePayMerchantDomainsRequest
                .builder()
                .accountID(accountID)
                .registerApplePayMerchantDomains(registerApplePayMerchantDomains)
                .build();
        RequestOperation<RegisterApplePayMerchantDomainsRequest, RegisterApplePayMerchantDomainsResponse> operation
              = new RegisterApplePayMerchantDomainsOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Add or remove domains to be registered with Apple Pay. 
     * 
     * <p>Any domains that will be used to accept payments must first be [verified](https://docs.moov.io/guides/sources/cards/apple-pay/#register-your-domains) 
     * with Apple.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/apple-pay.write` scope.
     * 
     * @return The call builder
     */
    public UpdateApplePayMerchantDomainsRequestBuilder updateMerchantDomains() {
        return new UpdateApplePayMerchantDomainsRequestBuilder(sdkConfiguration);
    }

    /**
     * Add or remove domains to be registered with Apple Pay. 
     * 
     * <p>Any domains that will be used to accept payments must first be [verified](https://docs.moov.io/guides/sources/cards/apple-pay/#register-your-domains) 
     * with Apple.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/apple-pay.write` scope.
     * 
     * @param accountID ID of the Moov account representing the merchant.
     * @param updateApplePayMerchantDomains 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public UpdateApplePayMerchantDomainsResponse updateMerchantDomains(String accountID, UpdateApplePayMerchantDomains updateApplePayMerchantDomains) throws Exception {
        UpdateApplePayMerchantDomainsRequest request =
            UpdateApplePayMerchantDomainsRequest
                .builder()
                .accountID(accountID)
                .updateApplePayMerchantDomains(updateApplePayMerchantDomains)
                .build();
        RequestOperation<UpdateApplePayMerchantDomainsRequest, UpdateApplePayMerchantDomainsResponse> operation
              = new UpdateApplePayMerchantDomainsOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Get domains registered with Apple Pay. 
     * 
     * <p>Read our [Apple Pay tutorial](https://docs.moov.io/guides/sources/cards/apple-pay/#register-your-domains) to learn more. 
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/apple-pay.read` scope.
     * 
     * @return The call builder
     */
    public GetApplePayMerchantDomainsRequestBuilder getMerchantDomains() {
        return new GetApplePayMerchantDomainsRequestBuilder(sdkConfiguration);
    }

    /**
     * Get domains registered with Apple Pay. 
     * 
     * <p>Read our [Apple Pay tutorial](https://docs.moov.io/guides/sources/cards/apple-pay/#register-your-domains) to learn more. 
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/apple-pay.read` scope.
     * 
     * @param accountID ID of the Moov account representing the merchant.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetApplePayMerchantDomainsResponse getMerchantDomains(String accountID) throws Exception {
        GetApplePayMerchantDomainsRequest request =
            GetApplePayMerchantDomainsRequest
                .builder()
                .accountID(accountID)
                .build();
        RequestOperation<GetApplePayMerchantDomainsRequest, GetApplePayMerchantDomainsResponse> operation
              = new GetApplePayMerchantDomainsOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Create a session with Apple Pay to facilitate a payment. 
     * 
     * <p>Read our [Apple Pay tutorial](https://docs.moov.io/guides/sources/cards/apple-pay/#register-your-domains) to learn more. 
     * A successful response from this endpoint should be passed through to Apple Pay unchanged. 
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/apple-pay.write` scope.
     * 
     * @return The call builder
     */
    public CreateApplePaySessionRequestBuilder createSession() {
        return new CreateApplePaySessionRequestBuilder(sdkConfiguration);
    }

    /**
     * Create a session with Apple Pay to facilitate a payment. 
     * 
     * <p>Read our [Apple Pay tutorial](https://docs.moov.io/guides/sources/cards/apple-pay/#register-your-domains) to learn more. 
     * A successful response from this endpoint should be passed through to Apple Pay unchanged. 
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/apple-pay.write` scope.
     * 
     * @param accountID ID of the Moov account representing the merchant.
     * @param createApplePaySession 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public CreateApplePaySessionResponse createSession(String accountID, CreateApplePaySession createApplePaySession) throws Exception {
        CreateApplePaySessionRequest request =
            CreateApplePaySessionRequest
                .builder()
                .accountID(accountID)
                .createApplePaySession(createApplePaySession)
                .build();
        RequestOperation<CreateApplePaySessionRequest, CreateApplePaySessionResponse> operation
              = new CreateApplePaySessionOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Connect an Apple Pay token to the specified account. 
     * 
     * <p>Read our [Apple Pay tutorial](https://docs.moov.io/guides/sources/cards/apple-pay/#register-your-domains) to learn more. 
     * The `token` data is defined by Apple Pay and should be passed through from Apple Pay's response unmodified.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/cards.write` scope.
     * 
     * @return The call builder
     */
    public LinkApplePayTokenRequestBuilder linkToken() {
        return new LinkApplePayTokenRequestBuilder(sdkConfiguration);
    }

    /**
     * Connect an Apple Pay token to the specified account. 
     * 
     * <p>Read our [Apple Pay tutorial](https://docs.moov.io/guides/sources/cards/apple-pay/#register-your-domains) to learn more. 
     * The `token` data is defined by Apple Pay and should be passed through from Apple Pay's response unmodified.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/cards.write` scope.
     * 
     * @param accountID ID of the Moov account representing the cardholder.
     * @param linkApplePay   The JSON structure returned from Apple Pay when authorizing a payment session.
     *         
     *           Refer to [Apple's documentation](https://developer.apple.com/documentation/apple_pay_on_the_web/applepaypayment) 
     *           for more information.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public LinkApplePayTokenResponse linkToken(String accountID, LinkApplePay linkApplePay) throws Exception {
        LinkApplePayTokenRequest request =
            LinkApplePayTokenRequest
                .builder()
                .accountID(accountID)
                .linkApplePay(linkApplePay)
                .build();
        RequestOperation<LinkApplePayTokenRequest, LinkApplePayTokenResponse> operation
              = new LinkApplePayTokenOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

}
