/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk;

import static io.moov.sdk.operations.Operations.RequestOperation;

import io.moov.sdk.models.operations.GetAdjustmentRequest;
import io.moov.sdk.models.operations.GetAdjustmentRequestBuilder;
import io.moov.sdk.models.operations.GetAdjustmentResponse;
import io.moov.sdk.models.operations.ListAdjustmentsRequest;
import io.moov.sdk.models.operations.ListAdjustmentsRequestBuilder;
import io.moov.sdk.models.operations.ListAdjustmentsResponse;
import io.moov.sdk.operations.GetAdjustmentOperation;
import io.moov.sdk.operations.ListAdjustmentsOperation;
import java.lang.Exception;
import java.lang.String;
import java.util.Optional;


public class Adjustments {
    private final SDKConfiguration sdkConfiguration;

    Adjustments(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    /**
     * List adjustments associated with a Moov account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/wallets.read` scope.
     * 
     * @return The call builder
     */
    public ListAdjustmentsRequestBuilder list() {
        return new ListAdjustmentsRequestBuilder(sdkConfiguration);
    }

    /**
     * List adjustments associated with a Moov account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/wallets.read` scope.
     * 
     * @param accountID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListAdjustmentsResponse list(String accountID) throws Exception {
        return list(accountID, Optional.empty());
    }

    /**
     * List adjustments associated with a Moov account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/wallets.read` scope.
     * 
     * @param accountID 
     * @param walletID A wallet ID to filter adjustments by.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListAdjustmentsResponse list(String accountID, Optional<String> walletID) throws Exception {
        ListAdjustmentsRequest request =
            ListAdjustmentsRequest
                .builder()
                .accountID(accountID)
                .walletID(walletID)
                .build();
        RequestOperation<ListAdjustmentsRequest, ListAdjustmentsResponse> operation
              = new ListAdjustmentsOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Retrieve a specific adjustment associated with a Moov account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/wallets.read` scope.
     * 
     * @return The call builder
     */
    public GetAdjustmentRequestBuilder get() {
        return new GetAdjustmentRequestBuilder(sdkConfiguration);
    }

    /**
     * Retrieve a specific adjustment associated with a Moov account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/wallets.read` scope.
     * 
     * @param accountID 
     * @param adjustmentID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetAdjustmentResponse get(String accountID, String adjustmentID) throws Exception {
        GetAdjustmentRequest request =
            GetAdjustmentRequest
                .builder()
                .accountID(accountID)
                .adjustmentID(adjustmentID)
                .build();
        RequestOperation<GetAdjustmentRequest, GetAdjustmentResponse> operation
              = new GetAdjustmentOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

}
