/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk;

import static io.moov.sdk.operations.Operations.RequestOperation;

import io.moov.sdk.models.components.AccountCountries;
import io.moov.sdk.models.components.CreateAccount;
import io.moov.sdk.models.components.PatchAccount;
import io.moov.sdk.models.operations.AssignAccountCountriesRequest;
import io.moov.sdk.models.operations.AssignAccountCountriesRequestBuilder;
import io.moov.sdk.models.operations.AssignAccountCountriesResponse;
import io.moov.sdk.models.operations.CreateAccountRequestBuilder;
import io.moov.sdk.models.operations.CreateAccountResponse;
import io.moov.sdk.models.operations.DisconnectAccountRequest;
import io.moov.sdk.models.operations.DisconnectAccountRequestBuilder;
import io.moov.sdk.models.operations.DisconnectAccountResponse;
import io.moov.sdk.models.operations.GetAccountCountriesRequest;
import io.moov.sdk.models.operations.GetAccountCountriesRequestBuilder;
import io.moov.sdk.models.operations.GetAccountCountriesResponse;
import io.moov.sdk.models.operations.GetAccountRequest;
import io.moov.sdk.models.operations.GetAccountRequestBuilder;
import io.moov.sdk.models.operations.GetAccountResponse;
import io.moov.sdk.models.operations.GetMerchantProcessingAgreementRequest;
import io.moov.sdk.models.operations.GetMerchantProcessingAgreementRequestBuilder;
import io.moov.sdk.models.operations.GetMerchantProcessingAgreementResponse;
import io.moov.sdk.models.operations.GetTermsOfServiceTokenRequest;
import io.moov.sdk.models.operations.GetTermsOfServiceTokenRequestBuilder;
import io.moov.sdk.models.operations.GetTermsOfServiceTokenResponse;
import io.moov.sdk.models.operations.ListAccountsRequest;
import io.moov.sdk.models.operations.ListAccountsRequestBuilder;
import io.moov.sdk.models.operations.ListAccountsResponse;
import io.moov.sdk.models.operations.UpdateAccountRequest;
import io.moov.sdk.models.operations.UpdateAccountRequestBuilder;
import io.moov.sdk.models.operations.UpdateAccountResponse;
import io.moov.sdk.operations.AssignAccountCountriesOperation;
import io.moov.sdk.operations.CreateAccountOperation;
import io.moov.sdk.operations.DisconnectAccountOperation;
import io.moov.sdk.operations.GetAccountCountriesOperation;
import io.moov.sdk.operations.GetAccountOperation;
import io.moov.sdk.operations.GetMerchantProcessingAgreementOperation;
import io.moov.sdk.operations.GetTermsOfServiceTokenOperation;
import io.moov.sdk.operations.ListAccountsOperation;
import io.moov.sdk.operations.UpdateAccountOperation;
import java.lang.Exception;
import java.lang.String;
import java.util.Optional;


public class Accounts {
    private final SDKConfiguration sdkConfiguration;

    Accounts(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    /**
     * You can create **business** or **individual** accounts for your users (i.e., customers, merchants) by passing the required
     * information to Moov. Requirements differ per account type and requested [capabilities](https://docs.moov.io/guides/accounts/capabilities/requirements/).
     * 
     * <p>If you're requesting the `wallet`, `send-funds`, `collect-funds`, or `card-issuing` capabilities, you'll need to:
     *   + Send Moov the user [platform terms of service agreement](https://docs.moov.io/guides/accounts/requirements/platform-agreement/) acceptance.
     *     This can be done upon account creation, or by [patching](https://docs.moov.io/api/moov-accounts/accounts/patch/) the account using the `termsOfService` field.
     * If you're creating a business account with the business type `llc`, `partnership`, or `privateCorporation`, you'll need to:
     *   + Provide [business representatives](https://docs.moov.io/api/moov-accounts/representatives/) after creating the account.
     *   + [Patch](https://docs.moov.io/api/moov-accounts/accounts/patch/) the account to indicate that business representative ownership information is complete.
     * 
     * <p>Visit our documentation to read more about [creating accounts](https://docs.moov.io/guides/accounts/create-accounts/) and [verification requirements](https://docs.moov.io/guides/accounts/requirements/identity-verification/).
     * Note that the `mode` field (for production or sandbox) is only required when creating a _facilitator_ account. All non-facilitator account requests will ignore the mode field and be set to the calling facilitator's mode.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) you'll need 
     * to specify the `/accounts.write` scope.
     * 
     * @return The call builder
     */
    public CreateAccountRequestBuilder create() {
        return new CreateAccountRequestBuilder(sdkConfiguration);
    }

    /**
     * You can create **business** or **individual** accounts for your users (i.e., customers, merchants) by passing the required
     * information to Moov. Requirements differ per account type and requested [capabilities](https://docs.moov.io/guides/accounts/capabilities/requirements/).
     * 
     * <p>If you're requesting the `wallet`, `send-funds`, `collect-funds`, or `card-issuing` capabilities, you'll need to:
     *   + Send Moov the user [platform terms of service agreement](https://docs.moov.io/guides/accounts/requirements/platform-agreement/) acceptance.
     *     This can be done upon account creation, or by [patching](https://docs.moov.io/api/moov-accounts/accounts/patch/) the account using the `termsOfService` field.
     * If you're creating a business account with the business type `llc`, `partnership`, or `privateCorporation`, you'll need to:
     *   + Provide [business representatives](https://docs.moov.io/api/moov-accounts/representatives/) after creating the account.
     *   + [Patch](https://docs.moov.io/api/moov-accounts/accounts/patch/) the account to indicate that business representative ownership information is complete.
     * 
     * <p>Visit our documentation to read more about [creating accounts](https://docs.moov.io/guides/accounts/create-accounts/) and [verification requirements](https://docs.moov.io/guides/accounts/requirements/identity-verification/).
     * Note that the `mode` field (for production or sandbox) is only required when creating a _facilitator_ account. All non-facilitator account requests will ignore the mode field and be set to the calling facilitator's mode.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) you'll need 
     * to specify the `/accounts.write` scope.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public CreateAccountResponse create(CreateAccount request) throws Exception {
        RequestOperation<CreateAccount, CreateAccountResponse> operation
              = new CreateAccountOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * List or search accounts to which the caller is connected.
     * 
     * <p>All supported query parameters are optional. If none are provided the response will include all connected accounts.
     * Pagination is supported via the `skip` and `count` query parameters. Searching by name and email will overlap and 
     * return results based on relevance.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) you'll need 
     * to specify the `/accounts.read` scope.
     * 
     * @return The call builder
     */
    public ListAccountsRequestBuilder list() {
        return new ListAccountsRequestBuilder(sdkConfiguration);
    }

    /**
     * List or search accounts to which the caller is connected.
     * 
     * <p>All supported query parameters are optional. If none are provided the response will include all connected accounts.
     * Pagination is supported via the `skip` and `count` query parameters. Searching by name and email will overlap and 
     * return results based on relevance.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) you'll need 
     * to specify the `/accounts.read` scope.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListAccountsResponse list(ListAccountsRequest request) throws Exception {
        RequestOperation<ListAccountsRequest, ListAccountsResponse> operation
              = new ListAccountsOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Retrieves details for the account with the specified ID.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) you'll need 
     * to specify the `/accounts/{accountID}/profile.read` scope.
     * 
     * @return The call builder
     */
    public GetAccountRequestBuilder get() {
        return new GetAccountRequestBuilder(sdkConfiguration);
    }

    /**
     * Retrieves details for the account with the specified ID.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) you'll need 
     * to specify the `/accounts/{accountID}/profile.read` scope.
     * 
     * @param accountID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetAccountResponse get(String accountID) throws Exception {
        GetAccountRequest request =
            GetAccountRequest
                .builder()
                .accountID(accountID)
                .build();
        RequestOperation<GetAccountRequest, GetAccountResponse> operation
              = new GetAccountOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * When **can** profile data be updated:
     *   + For unverified accounts, all profile data can be edited.
     *   + During the verification process, missing or incomplete profile data can be edited.
     *   + Verified accounts can only add missing profile data.
     * 
     * <p>  When **can't** profile data be updated:
     *   + Verified accounts cannot change any existing profile data.
     * 
     * <p>If you need to update information in a locked state, please contact Moov support.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) you'll need 
     * to specify the `/accounts/{accountID}/profile.write` scope.
     * 
     * @return The call builder
     */
    public UpdateAccountRequestBuilder update() {
        return new UpdateAccountRequestBuilder(sdkConfiguration);
    }

    /**
     * When **can** profile data be updated:
     *   + For unverified accounts, all profile data can be edited.
     *   + During the verification process, missing or incomplete profile data can be edited.
     *   + Verified accounts can only add missing profile data.
     * 
     * <p>  When **can't** profile data be updated:
     *   + Verified accounts cannot change any existing profile data.
     * 
     * <p>If you need to update information in a locked state, please contact Moov support.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) you'll need 
     * to specify the `/accounts/{accountID}/profile.write` scope.
     * 
     * @param accountID 
     * @param patchAccount Describes the fields available when patching a Moov account.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public UpdateAccountResponse update(String accountID, PatchAccount patchAccount) throws Exception {
        UpdateAccountRequest request =
            UpdateAccountRequest
                .builder()
                .accountID(accountID)
                .patchAccount(patchAccount)
                .build();
        RequestOperation<UpdateAccountRequest, UpdateAccountResponse> operation
              = new UpdateAccountOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * This will sever the connection between you and the account specified and it will no longer be listed as 
     * active in the list of accounts. This also means you'll only have read-only access to the account going 
     * forward for reporting purposes.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/profile.disconnect` scope.
     * 
     * @return The call builder
     */
    public DisconnectAccountRequestBuilder disconnect() {
        return new DisconnectAccountRequestBuilder(sdkConfiguration);
    }

    /**
     * This will sever the connection between you and the account specified and it will no longer be listed as 
     * active in the list of accounts. This also means you'll only have read-only access to the account going 
     * forward for reporting purposes.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/profile.disconnect` scope.
     * 
     * @param accountID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public DisconnectAccountResponse disconnect(String accountID) throws Exception {
        DisconnectAccountRequest request =
            DisconnectAccountRequest
                .builder()
                .accountID(accountID)
                .build();
        RequestOperation<DisconnectAccountRequest, DisconnectAccountResponse> operation
              = new DisconnectAccountOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Retrieve the specified countries of operation for an account. 
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/profile.read` scope.
     * 
     * @return The call builder
     */
    public GetAccountCountriesRequestBuilder getCountries() {
        return new GetAccountCountriesRequestBuilder(sdkConfiguration);
    }

    /**
     * Retrieve the specified countries of operation for an account. 
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/profile.read` scope.
     * 
     * @param accountID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetAccountCountriesResponse getCountries(String accountID) throws Exception {
        GetAccountCountriesRequest request =
            GetAccountCountriesRequest
                .builder()
                .accountID(accountID)
                .build();
        RequestOperation<GetAccountCountriesRequest, GetAccountCountriesResponse> operation
              = new GetAccountCountriesOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Assign the countries of operation for an account.
     * 
     * <p>This endpoint will always overwrite the previously assigned values. 
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/profile.write` scope.
     * 
     * @return The call builder
     */
    public AssignAccountCountriesRequestBuilder assignCountries() {
        return new AssignAccountCountriesRequestBuilder(sdkConfiguration);
    }

    /**
     * Assign the countries of operation for an account.
     * 
     * <p>This endpoint will always overwrite the previously assigned values. 
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/profile.write` scope.
     * 
     * @param accountID 
     * @param accountCountries The countries in which an account operates.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public AssignAccountCountriesResponse assignCountries(String accountID, AccountCountries accountCountries) throws Exception {
        AssignAccountCountriesRequest request =
            AssignAccountCountriesRequest
                .builder()
                .accountID(accountID)
                .accountCountries(accountCountries)
                .build();
        RequestOperation<AssignAccountCountriesRequest, AssignAccountCountriesResponse> operation
              = new AssignAccountCountriesOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Retrieve a merchant account's processing agreement.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/profile.read` scope.
     * 
     * @return The call builder
     */
    public GetMerchantProcessingAgreementRequestBuilder getMerchantProcessingAgreement() {
        return new GetMerchantProcessingAgreementRequestBuilder(sdkConfiguration);
    }

    /**
     * Retrieve a merchant account's processing agreement.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/profile.read` scope.
     * 
     * @param accountID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetMerchantProcessingAgreementResponse getMerchantProcessingAgreement(String accountID) throws Exception {
        GetMerchantProcessingAgreementRequest request =
            GetMerchantProcessingAgreementRequest
                .builder()
                .accountID(accountID)
                .build();
        RequestOperation<GetMerchantProcessingAgreementRequest, GetMerchantProcessingAgreementResponse> operation
              = new GetMerchantProcessingAgreementOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Generates a non-expiring token that can then be used to accept Moov's terms of service. 
     * 
     * <p>This token can only be generated via API. Any Moov account requesting the collect funds, send funds, wallet, 
     * or card issuing capabilities must accept Moov's terms of service, then have the generated terms of service 
     * token patched to the account. Read more in our [documentation](https://docs.moov.io/guides/accounts/requirements/platform-agreement/).
     * 
     * @return The call builder
     */
    public GetTermsOfServiceTokenRequestBuilder getTermsOfServiceToken() {
        return new GetTermsOfServiceTokenRequestBuilder(sdkConfiguration);
    }

    /**
     * Generates a non-expiring token that can then be used to accept Moov's terms of service. 
     * 
     * <p>This token can only be generated via API. Any Moov account requesting the collect funds, send funds, wallet, 
     * or card issuing capabilities must accept Moov's terms of service, then have the generated terms of service 
     * token patched to the account. Read more in our [documentation](https://docs.moov.io/guides/accounts/requirements/platform-agreement/).
     * 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetTermsOfServiceTokenResponse getTermsOfServiceTokenDirect() throws Exception {
        return getTermsOfServiceToken(Optional.empty(), Optional.empty());
    }

    /**
     * Generates a non-expiring token that can then be used to accept Moov's terms of service. 
     * 
     * <p>This token can only be generated via API. Any Moov account requesting the collect funds, send funds, wallet, 
     * or card issuing capabilities must accept Moov's terms of service, then have the generated terms of service 
     * token patched to the account. Read more in our [documentation](https://docs.moov.io/guides/accounts/requirements/platform-agreement/).
     * 
     * @param origin Indicates the domain from which the request originated. Required if referer header is not present.
     * @param referer Specifies the URL of the resource from which the request originated. Required if origin header is not present.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetTermsOfServiceTokenResponse getTermsOfServiceToken(Optional<String> origin, Optional<String> referer) throws Exception {
        GetTermsOfServiceTokenRequest request =
            GetTermsOfServiceTokenRequest
                .builder()
                .origin(origin)
                .referer(referer)
                .build();
        RequestOperation<GetTermsOfServiceTokenRequest, GetTermsOfServiceTokenResponse> operation
              = new GetTermsOfServiceTokenOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

}
