/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk;

import static io.moov.sdk.operations.Operations.RequestOperation;

import io.moov.sdk.models.components.LinkAccountTerminalApplication;
import io.moov.sdk.models.operations.GetAccountTerminalApplicationRequest;
import io.moov.sdk.models.operations.GetAccountTerminalApplicationRequestBuilder;
import io.moov.sdk.models.operations.GetAccountTerminalApplicationResponse;
import io.moov.sdk.models.operations.GetTerminalConfigurationRequest;
import io.moov.sdk.models.operations.GetTerminalConfigurationRequestBuilder;
import io.moov.sdk.models.operations.GetTerminalConfigurationResponse;
import io.moov.sdk.models.operations.LinkAccountTerminalApplicationRequest;
import io.moov.sdk.models.operations.LinkAccountTerminalApplicationRequestBuilder;
import io.moov.sdk.models.operations.LinkAccountTerminalApplicationResponse;
import io.moov.sdk.models.operations.ListAccountTerminalApplicationsRequest;
import io.moov.sdk.models.operations.ListAccountTerminalApplicationsRequestBuilder;
import io.moov.sdk.models.operations.ListAccountTerminalApplicationsResponse;
import io.moov.sdk.operations.GetAccountTerminalApplicationOperation;
import io.moov.sdk.operations.GetTerminalConfigurationOperation;
import io.moov.sdk.operations.LinkAccountTerminalApplicationOperation;
import io.moov.sdk.operations.ListAccountTerminalApplicationsOperation;
import java.lang.Exception;
import java.lang.String;


public class AccountTerminalApplications {
    private final SDKConfiguration sdkConfiguration;

    AccountTerminalApplications(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    /**
     * Link an account with a terminal application.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/terminal-applications.write` scope.
     * 
     * @return The call builder
     */
    public LinkAccountTerminalApplicationRequestBuilder link() {
        return new LinkAccountTerminalApplicationRequestBuilder(sdkConfiguration);
    }

    /**
     * Link an account with a terminal application.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/terminal-applications.write` scope.
     * 
     * @param accountID 
     * @param linkAccountTerminalApplication Describes a request to link an account with a terminal application.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public LinkAccountTerminalApplicationResponse link(String accountID, LinkAccountTerminalApplication linkAccountTerminalApplication) throws Exception {
        LinkAccountTerminalApplicationRequest request =
            LinkAccountTerminalApplicationRequest
                .builder()
                .accountID(accountID)
                .linkAccountTerminalApplication(linkAccountTerminalApplication)
                .build();
        RequestOperation<LinkAccountTerminalApplicationRequest, LinkAccountTerminalApplicationResponse> operation
              = new LinkAccountTerminalApplicationOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Retrieve all terminal applications linked to a specific account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/terminal-applications.read` scope.
     * 
     * @return The call builder
     */
    public ListAccountTerminalApplicationsRequestBuilder list() {
        return new ListAccountTerminalApplicationsRequestBuilder(sdkConfiguration);
    }

    /**
     * Retrieve all terminal applications linked to a specific account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/terminal-applications.read` scope.
     * 
     * @param accountID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public ListAccountTerminalApplicationsResponse list(String accountID) throws Exception {
        ListAccountTerminalApplicationsRequest request =
            ListAccountTerminalApplicationsRequest
                .builder()
                .accountID(accountID)
                .build();
        RequestOperation<ListAccountTerminalApplicationsRequest, ListAccountTerminalApplicationsResponse> operation
              = new ListAccountTerminalApplicationsOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Verifies if a specific Terminal Application is linked to an Account. This endpoint acts as a validation check for the link's existence.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/terminal-applications.read` scope.
     * 
     * @return The call builder
     */
    public GetAccountTerminalApplicationRequestBuilder get() {
        return new GetAccountTerminalApplicationRequestBuilder(sdkConfiguration);
    }

    /**
     * Verifies if a specific Terminal Application is linked to an Account. This endpoint acts as a validation check for the link's existence.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/terminal-applications.read` scope.
     * 
     * @param accountID 
     * @param terminalApplicationID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetAccountTerminalApplicationResponse get(String accountID, String terminalApplicationID) throws Exception {
        GetAccountTerminalApplicationRequest request =
            GetAccountTerminalApplicationRequest
                .builder()
                .accountID(accountID)
                .terminalApplicationID(terminalApplicationID)
                .build();
        RequestOperation<GetAccountTerminalApplicationRequest, GetAccountTerminalApplicationResponse> operation
              = new GetAccountTerminalApplicationOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Fetch the configuration for a given Terminal Application linked to a specific Account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/terminal-configuration.read` scope.
     * 
     * @return The call builder
     */
    public GetTerminalConfigurationRequestBuilder getConfiguration() {
        return new GetTerminalConfigurationRequestBuilder(sdkConfiguration);
    }

    /**
     * Fetch the configuration for a given Terminal Application linked to a specific Account.
     * 
     * <p>To access this endpoint using an [access token](https://docs.moov.io/api/authentication/access-tokens/) 
     * you'll need to specify the `/accounts/{accountID}/terminal-configuration.read` scope.
     * 
     * @param accountID 
     * @param terminalApplicationID 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public GetTerminalConfigurationResponse getConfiguration(String accountID, String terminalApplicationID) throws Exception {
        GetTerminalConfigurationRequest request =
            GetTerminalConfigurationRequest
                .builder()
                .accountID(accountID)
                .terminalApplicationID(terminalApplicationID)
                .build();
        RequestOperation<GetTerminalConfigurationRequest, GetTerminalConfigurationResponse> operation
              = new GetTerminalConfigurationOperation(sdkConfiguration);
        return operation.handleResponse(operation.doRequest(request));
    }

}
