/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.http.HttpRequest;
import java.net.http.HttpRequest.BodyPublisher;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;

public final class Multipart {

    private final static String DASHES = "--";
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";

    private final BodyPublisher bodyPublisher;
    private final String boundary;

    private Multipart(BodyPublisher bodyPublisher, String boundary) {
        this.bodyPublisher = bodyPublisher;
        this.boundary = boundary;
    }

    public BodyPublisher bodyPublisher() {
        return bodyPublisher;
    }

    public String contentType() {
        return "multipart/form-data; charset=" + StandardCharsets.ISO_8859_1.name() + "; boundary=" + boundary;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {

        private final List<Part> parts = new ArrayList<>();
        private final String boundary = UUID.randomUUID().toString();

        public Builder addPart(String name, String value) {
            Utils.checkNotNull(name, "name");
            Utils.checkNotNull(value, "value");
            Part p = new Part();
            p.type = PartType.STRING;
            p.name = name;
            p.value = value;
            parts.add(p);
            return this;
        }

        public Builder addPart(String name, String value, String contentType) {
            Utils.checkNotNull(name, "name");
            Utils.checkNotNull(value, "value");
            Utils.checkNotNull(contentType, "contentType");
            Part p = new Part();
            p.type = PartType.STRING;
            p.name = name;
            p.value = value;
            p.contentType = contentType;
            parts.add(p);
            return this;
        }

        public Builder addPart(String name, Supplier<InputStream> stream, String filename,
                Optional<String> contentType) {
            Utils.checkNotNull(name, "name");
            Utils.checkNotNull(stream, "stream");
            Utils.checkNotNull(filename, "filename");
            Utils.checkNotNull(contentType, "contentType");
            Part p = new Part();
            p.type = PartType.STREAM;
            p.name = name;
            p.stream = stream;
            p.filename = filename;
            p.contentType = contentType.orElse(null);
            parts.add(p);
            return this;
        }

        private void addFinalBoundaryPart() {
            Part p = new Part();
            p.type = PartType.FINAL_BOUNDARY;
            p.value = DASHES + boundary + DASHES;
            parts.add(p);
        }

        public Multipart build() {
            if (parts.size() == 0) {
                throw new IllegalStateException("Must have at least one part to build multipart message.");
            }
            addFinalBoundaryPart();
            BodyPublisher bp = HttpRequest.BodyPublishers.ofByteArrays( //
                    () -> new PartsIterator(parts, boundary));
            return new Multipart(bp, boundary);
        }
    }

    public enum PartType {
        STRING, STREAM, FINAL_BOUNDARY
    }

    static final class Part {

        // type is the only mandatory field. Not keen on
        // a whole bunch of nullable fields but not public api
        // so will forego the noise of chained builders and
        // Optional use

        PartType type;
        String name;
        String value;
        Supplier<InputStream> stream;
        String filename;
        String contentType;

    }

    private static final class PartsIterator implements Iterator<byte[]> {

        private final Iterator<Part> iter;
        private final String boundary;

        private InputStream currentFileInput;
        private boolean done;
        private byte[] next;

        PartsIterator(List<Part> parts, String boundary) {
            this.iter = parts.iterator();
            this.boundary = boundary;
        }

        @Override
        public boolean hasNext() {
            if (done)
                return false;
            if (next != null)
                return true;
            try {
                next = computeNext();
            } catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            if (next == null) {
                done = true;
                return false;
            }
            return true;
        }

        @Override
        public byte[] next() {
            if (!hasNext())
                throw new NoSuchElementException();
            byte[] res = next;
            next = null;
            return res;
        }

        private byte[] computeNext() throws IOException {
            if (currentFileInput == null) {
                if (!iter.hasNext())
                    return null;
                Part nextPart = iter.next();
                if (PartType.STRING.equals(nextPart.type)) {
                    String part = DASHES + boundary + "\r\n" + "Content-Disposition: form-data; name=" + nextPart.name
                            + "\r\n" + "Content-Type: text/plain; charset=UTF-8\r\n\r\n" + nextPart.value + "\r\n";
                    return part.getBytes(StandardCharsets.UTF_8);
                } else if (PartType.FINAL_BOUNDARY.equals(nextPart.type)) {
                    return nextPart.value.getBytes(StandardCharsets.UTF_8);
                } else {
                    String filename = nextPart.filename;
                    String contentType = nextPart.contentType;
                    if (contentType == null) {
                        contentType = APPLICATION_OCTET_STREAM;
                    }
                    currentFileInput = nextPart.stream.get();
                    String partHeader = DASHES + boundary + "\r\n" + "Content-Disposition: form-data; name="
                            + nextPart.name + "; filename=" + filename + "\r\n" + "Content-Type: " + contentType
                            + "\r\n\r\n";
                    return partHeader.getBytes(StandardCharsets.UTF_8);
                }
            } else {
                byte[] buf = new byte[8192];
                int r = currentFileInput.read(buf);
                if (r > 0) {
                    byte[] actualBytes = new byte[r];
                    System.arraycopy(buf, 0, actualBytes, 0, r);
                    return actualBytes;
                } else {
                    currentFileInput.close();
                    currentFileInput = null;
                    return "\r\n".getBytes(StandardCharsets.UTF_8);
                }
            }
        }
    }
}
