/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import io.moov.sdk.models.components.WalletTransactionSourceType;
import io.moov.sdk.models.components.WalletTransactionStatus;
import io.moov.sdk.models.components.WalletTransactionType;
import io.moov.sdk.utils.LazySingletonValue;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ListWalletTransactionsRequest {

    /**
     * Specify an API version.
     * 
     * <p>API versioning follows the format `vYYYY.QQ.BB`, where 
     *   - `YYYY` is the year
     *   - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
     *   - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter. 
     *     - For example, `v2024.01.00` is the initial release of the first quarter of 2024.
     * 
     * <p>The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-moov-version")
    private Optional<String> xMoovVersion;

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;

    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=skip")
    private Optional<Long> skip;

    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=count")
    private Optional<Long> count;

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=walletID")
    private String walletID;

    /**
     * Optional parameter to filter by transaction type.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=transactionType")
    private Optional<? extends WalletTransactionType> transactionType;

    /**
     * Optional, comma-separated parameter to filter by transaction types.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=transactionTypes")
    private Optional<? extends List<WalletTransactionType>> transactionTypes;

    /**
     * Optional parameter to filter by source type (i.e. transfer, dispute, issuing-transaction).
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=sourceType")
    private Optional<? extends WalletTransactionSourceType> sourceType;

    /**
     * Optional parameter to filter by source ID.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=sourceID")
    private Optional<String> sourceID;

    /**
     * Optional parameter to filter by status (`pending` or `completed`).
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=status")
    private Optional<? extends WalletTransactionStatus> status;

    /**
     * Optional date-time which inclusively filters all transactions created after this date-time.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=createdStartDateTime")
    private Optional<OffsetDateTime> createdStartDateTime;

    /**
     * Optional date-time which exclusively filters all transactions created before this date-time.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=createdEndDateTime")
    private Optional<OffsetDateTime> createdEndDateTime;

    /**
     * Optional date-time which inclusively filters all transactions completed after this date-time.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=completedStartDateTime")
    private Optional<OffsetDateTime> completedStartDateTime;

    /**
     * Optional date-time which exclusively filters all transactions completed before this date-time.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=completedEndDateTime")
    private Optional<OffsetDateTime> completedEndDateTime;

    /**
     * Optional ID to filter for transactions accrued in a sweep.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=sweepID")
    private Optional<String> sweepID;

    @JsonCreator
    public ListWalletTransactionsRequest(
            Optional<String> xMoovVersion,
            String accountID,
            Optional<Long> skip,
            Optional<Long> count,
            String walletID,
            Optional<? extends WalletTransactionType> transactionType,
            Optional<? extends List<WalletTransactionType>> transactionTypes,
            Optional<? extends WalletTransactionSourceType> sourceType,
            Optional<String> sourceID,
            Optional<? extends WalletTransactionStatus> status,
            Optional<OffsetDateTime> createdStartDateTime,
            Optional<OffsetDateTime> createdEndDateTime,
            Optional<OffsetDateTime> completedStartDateTime,
            Optional<OffsetDateTime> completedEndDateTime,
            Optional<String> sweepID) {
        Utils.checkNotNull(xMoovVersion, "xMoovVersion");
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(skip, "skip");
        Utils.checkNotNull(count, "count");
        Utils.checkNotNull(walletID, "walletID");
        Utils.checkNotNull(transactionType, "transactionType");
        Utils.checkNotNull(transactionTypes, "transactionTypes");
        Utils.checkNotNull(sourceType, "sourceType");
        Utils.checkNotNull(sourceID, "sourceID");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(createdStartDateTime, "createdStartDateTime");
        Utils.checkNotNull(createdEndDateTime, "createdEndDateTime");
        Utils.checkNotNull(completedStartDateTime, "completedStartDateTime");
        Utils.checkNotNull(completedEndDateTime, "completedEndDateTime");
        Utils.checkNotNull(sweepID, "sweepID");
        this.xMoovVersion = xMoovVersion;
        this.accountID = accountID;
        this.skip = skip;
        this.count = count;
        this.walletID = walletID;
        this.transactionType = transactionType;
        this.transactionTypes = transactionTypes;
        this.sourceType = sourceType;
        this.sourceID = sourceID;
        this.status = status;
        this.createdStartDateTime = createdStartDateTime;
        this.createdEndDateTime = createdEndDateTime;
        this.completedStartDateTime = completedStartDateTime;
        this.completedEndDateTime = completedEndDateTime;
        this.sweepID = sweepID;
    }
    
    public ListWalletTransactionsRequest(
            String accountID,
            String walletID) {
        this(Optional.empty(), accountID, Optional.empty(), Optional.empty(), walletID, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    /**
     * Specify an API version.
     * 
     * <p>API versioning follows the format `vYYYY.QQ.BB`, where 
     *   - `YYYY` is the year
     *   - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
     *   - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter. 
     *     - For example, `v2024.01.00` is the initial release of the first quarter of 2024.
     * 
     * <p>The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
     */
    @JsonIgnore
    public Optional<String> xMoovVersion() {
        return xMoovVersion;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public Optional<Long> skip() {
        return skip;
    }

    @JsonIgnore
    public Optional<Long> count() {
        return count;
    }

    @JsonIgnore
    public String walletID() {
        return walletID;
    }

    /**
     * Optional parameter to filter by transaction type.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<WalletTransactionType> transactionType() {
        return (Optional<WalletTransactionType>) transactionType;
    }

    /**
     * Optional, comma-separated parameter to filter by transaction types.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<List<WalletTransactionType>> transactionTypes() {
        return (Optional<List<WalletTransactionType>>) transactionTypes;
    }

    /**
     * Optional parameter to filter by source type (i.e. transfer, dispute, issuing-transaction).
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<WalletTransactionSourceType> sourceType() {
        return (Optional<WalletTransactionSourceType>) sourceType;
    }

    /**
     * Optional parameter to filter by source ID.
     */
    @JsonIgnore
    public Optional<String> sourceID() {
        return sourceID;
    }

    /**
     * Optional parameter to filter by status (`pending` or `completed`).
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<WalletTransactionStatus> status() {
        return (Optional<WalletTransactionStatus>) status;
    }

    /**
     * Optional date-time which inclusively filters all transactions created after this date-time.
     */
    @JsonIgnore
    public Optional<OffsetDateTime> createdStartDateTime() {
        return createdStartDateTime;
    }

    /**
     * Optional date-time which exclusively filters all transactions created before this date-time.
     */
    @JsonIgnore
    public Optional<OffsetDateTime> createdEndDateTime() {
        return createdEndDateTime;
    }

    /**
     * Optional date-time which inclusively filters all transactions completed after this date-time.
     */
    @JsonIgnore
    public Optional<OffsetDateTime> completedStartDateTime() {
        return completedStartDateTime;
    }

    /**
     * Optional date-time which exclusively filters all transactions completed before this date-time.
     */
    @JsonIgnore
    public Optional<OffsetDateTime> completedEndDateTime() {
        return completedEndDateTime;
    }

    /**
     * Optional ID to filter for transactions accrued in a sweep.
     */
    @JsonIgnore
    public Optional<String> sweepID() {
        return sweepID;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * Specify an API version.
     * 
     * <p>API versioning follows the format `vYYYY.QQ.BB`, where 
     *   - `YYYY` is the year
     *   - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
     *   - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter. 
     *     - For example, `v2024.01.00` is the initial release of the first quarter of 2024.
     * 
     * <p>The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
     */
    public ListWalletTransactionsRequest withXMoovVersion(String xMoovVersion) {
        Utils.checkNotNull(xMoovVersion, "xMoovVersion");
        this.xMoovVersion = Optional.ofNullable(xMoovVersion);
        return this;
    }

    /**
     * Specify an API version.
     * 
     * <p>API versioning follows the format `vYYYY.QQ.BB`, where 
     *   - `YYYY` is the year
     *   - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
     *   - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter. 
     *     - For example, `v2024.01.00` is the initial release of the first quarter of 2024.
     * 
     * <p>The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
     */
    public ListWalletTransactionsRequest withXMoovVersion(Optional<String> xMoovVersion) {
        Utils.checkNotNull(xMoovVersion, "xMoovVersion");
        this.xMoovVersion = xMoovVersion;
        return this;
    }

    public ListWalletTransactionsRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public ListWalletTransactionsRequest withSkip(long skip) {
        Utils.checkNotNull(skip, "skip");
        this.skip = Optional.ofNullable(skip);
        return this;
    }

    public ListWalletTransactionsRequest withSkip(Optional<Long> skip) {
        Utils.checkNotNull(skip, "skip");
        this.skip = skip;
        return this;
    }

    public ListWalletTransactionsRequest withCount(long count) {
        Utils.checkNotNull(count, "count");
        this.count = Optional.ofNullable(count);
        return this;
    }

    public ListWalletTransactionsRequest withCount(Optional<Long> count) {
        Utils.checkNotNull(count, "count");
        this.count = count;
        return this;
    }

    public ListWalletTransactionsRequest withWalletID(String walletID) {
        Utils.checkNotNull(walletID, "walletID");
        this.walletID = walletID;
        return this;
    }

    /**
     * Optional parameter to filter by transaction type.
     */
    public ListWalletTransactionsRequest withTransactionType(WalletTransactionType transactionType) {
        Utils.checkNotNull(transactionType, "transactionType");
        this.transactionType = Optional.ofNullable(transactionType);
        return this;
    }

    /**
     * Optional parameter to filter by transaction type.
     */
    public ListWalletTransactionsRequest withTransactionType(Optional<? extends WalletTransactionType> transactionType) {
        Utils.checkNotNull(transactionType, "transactionType");
        this.transactionType = transactionType;
        return this;
    }

    /**
     * Optional, comma-separated parameter to filter by transaction types.
     */
    public ListWalletTransactionsRequest withTransactionTypes(List<WalletTransactionType> transactionTypes) {
        Utils.checkNotNull(transactionTypes, "transactionTypes");
        this.transactionTypes = Optional.ofNullable(transactionTypes);
        return this;
    }

    /**
     * Optional, comma-separated parameter to filter by transaction types.
     */
    public ListWalletTransactionsRequest withTransactionTypes(Optional<? extends List<WalletTransactionType>> transactionTypes) {
        Utils.checkNotNull(transactionTypes, "transactionTypes");
        this.transactionTypes = transactionTypes;
        return this;
    }

    /**
     * Optional parameter to filter by source type (i.e. transfer, dispute, issuing-transaction).
     */
    public ListWalletTransactionsRequest withSourceType(WalletTransactionSourceType sourceType) {
        Utils.checkNotNull(sourceType, "sourceType");
        this.sourceType = Optional.ofNullable(sourceType);
        return this;
    }

    /**
     * Optional parameter to filter by source type (i.e. transfer, dispute, issuing-transaction).
     */
    public ListWalletTransactionsRequest withSourceType(Optional<? extends WalletTransactionSourceType> sourceType) {
        Utils.checkNotNull(sourceType, "sourceType");
        this.sourceType = sourceType;
        return this;
    }

    /**
     * Optional parameter to filter by source ID.
     */
    public ListWalletTransactionsRequest withSourceID(String sourceID) {
        Utils.checkNotNull(sourceID, "sourceID");
        this.sourceID = Optional.ofNullable(sourceID);
        return this;
    }

    /**
     * Optional parameter to filter by source ID.
     */
    public ListWalletTransactionsRequest withSourceID(Optional<String> sourceID) {
        Utils.checkNotNull(sourceID, "sourceID");
        this.sourceID = sourceID;
        return this;
    }

    /**
     * Optional parameter to filter by status (`pending` or `completed`).
     */
    public ListWalletTransactionsRequest withStatus(WalletTransactionStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = Optional.ofNullable(status);
        return this;
    }

    /**
     * Optional parameter to filter by status (`pending` or `completed`).
     */
    public ListWalletTransactionsRequest withStatus(Optional<? extends WalletTransactionStatus> status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    /**
     * Optional date-time which inclusively filters all transactions created after this date-time.
     */
    public ListWalletTransactionsRequest withCreatedStartDateTime(OffsetDateTime createdStartDateTime) {
        Utils.checkNotNull(createdStartDateTime, "createdStartDateTime");
        this.createdStartDateTime = Optional.ofNullable(createdStartDateTime);
        return this;
    }

    /**
     * Optional date-time which inclusively filters all transactions created after this date-time.
     */
    public ListWalletTransactionsRequest withCreatedStartDateTime(Optional<OffsetDateTime> createdStartDateTime) {
        Utils.checkNotNull(createdStartDateTime, "createdStartDateTime");
        this.createdStartDateTime = createdStartDateTime;
        return this;
    }

    /**
     * Optional date-time which exclusively filters all transactions created before this date-time.
     */
    public ListWalletTransactionsRequest withCreatedEndDateTime(OffsetDateTime createdEndDateTime) {
        Utils.checkNotNull(createdEndDateTime, "createdEndDateTime");
        this.createdEndDateTime = Optional.ofNullable(createdEndDateTime);
        return this;
    }

    /**
     * Optional date-time which exclusively filters all transactions created before this date-time.
     */
    public ListWalletTransactionsRequest withCreatedEndDateTime(Optional<OffsetDateTime> createdEndDateTime) {
        Utils.checkNotNull(createdEndDateTime, "createdEndDateTime");
        this.createdEndDateTime = createdEndDateTime;
        return this;
    }

    /**
     * Optional date-time which inclusively filters all transactions completed after this date-time.
     */
    public ListWalletTransactionsRequest withCompletedStartDateTime(OffsetDateTime completedStartDateTime) {
        Utils.checkNotNull(completedStartDateTime, "completedStartDateTime");
        this.completedStartDateTime = Optional.ofNullable(completedStartDateTime);
        return this;
    }

    /**
     * Optional date-time which inclusively filters all transactions completed after this date-time.
     */
    public ListWalletTransactionsRequest withCompletedStartDateTime(Optional<OffsetDateTime> completedStartDateTime) {
        Utils.checkNotNull(completedStartDateTime, "completedStartDateTime");
        this.completedStartDateTime = completedStartDateTime;
        return this;
    }

    /**
     * Optional date-time which exclusively filters all transactions completed before this date-time.
     */
    public ListWalletTransactionsRequest withCompletedEndDateTime(OffsetDateTime completedEndDateTime) {
        Utils.checkNotNull(completedEndDateTime, "completedEndDateTime");
        this.completedEndDateTime = Optional.ofNullable(completedEndDateTime);
        return this;
    }

    /**
     * Optional date-time which exclusively filters all transactions completed before this date-time.
     */
    public ListWalletTransactionsRequest withCompletedEndDateTime(Optional<OffsetDateTime> completedEndDateTime) {
        Utils.checkNotNull(completedEndDateTime, "completedEndDateTime");
        this.completedEndDateTime = completedEndDateTime;
        return this;
    }

    /**
     * Optional ID to filter for transactions accrued in a sweep.
     */
    public ListWalletTransactionsRequest withSweepID(String sweepID) {
        Utils.checkNotNull(sweepID, "sweepID");
        this.sweepID = Optional.ofNullable(sweepID);
        return this;
    }

    /**
     * Optional ID to filter for transactions accrued in a sweep.
     */
    public ListWalletTransactionsRequest withSweepID(Optional<String> sweepID) {
        Utils.checkNotNull(sweepID, "sweepID");
        this.sweepID = sweepID;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ListWalletTransactionsRequest other = (ListWalletTransactionsRequest) o;
        return 
            Objects.deepEquals(this.xMoovVersion, other.xMoovVersion) &&
            Objects.deepEquals(this.accountID, other.accountID) &&
            Objects.deepEquals(this.skip, other.skip) &&
            Objects.deepEquals(this.count, other.count) &&
            Objects.deepEquals(this.walletID, other.walletID) &&
            Objects.deepEquals(this.transactionType, other.transactionType) &&
            Objects.deepEquals(this.transactionTypes, other.transactionTypes) &&
            Objects.deepEquals(this.sourceType, other.sourceType) &&
            Objects.deepEquals(this.sourceID, other.sourceID) &&
            Objects.deepEquals(this.status, other.status) &&
            Objects.deepEquals(this.createdStartDateTime, other.createdStartDateTime) &&
            Objects.deepEquals(this.createdEndDateTime, other.createdEndDateTime) &&
            Objects.deepEquals(this.completedStartDateTime, other.completedStartDateTime) &&
            Objects.deepEquals(this.completedEndDateTime, other.completedEndDateTime) &&
            Objects.deepEquals(this.sweepID, other.sweepID);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            xMoovVersion,
            accountID,
            skip,
            count,
            walletID,
            transactionType,
            transactionTypes,
            sourceType,
            sourceID,
            status,
            createdStartDateTime,
            createdEndDateTime,
            completedStartDateTime,
            completedEndDateTime,
            sweepID);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ListWalletTransactionsRequest.class,
                "xMoovVersion", xMoovVersion,
                "accountID", accountID,
                "skip", skip,
                "count", count,
                "walletID", walletID,
                "transactionType", transactionType,
                "transactionTypes", transactionTypes,
                "sourceType", sourceType,
                "sourceID", sourceID,
                "status", status,
                "createdStartDateTime", createdStartDateTime,
                "createdEndDateTime", createdEndDateTime,
                "completedStartDateTime", completedStartDateTime,
                "completedEndDateTime", completedEndDateTime,
                "sweepID", sweepID);
    }
    
    public final static class Builder {
 
        private Optional<String> xMoovVersion;
 
        private String accountID;
 
        private Optional<Long> skip = Optional.empty();
 
        private Optional<Long> count = Optional.empty();
 
        private String walletID;
 
        private Optional<? extends WalletTransactionType> transactionType = Optional.empty();
 
        private Optional<? extends List<WalletTransactionType>> transactionTypes = Optional.empty();
 
        private Optional<? extends WalletTransactionSourceType> sourceType = Optional.empty();
 
        private Optional<String> sourceID = Optional.empty();
 
        private Optional<? extends WalletTransactionStatus> status = Optional.empty();
 
        private Optional<OffsetDateTime> createdStartDateTime = Optional.empty();
 
        private Optional<OffsetDateTime> createdEndDateTime = Optional.empty();
 
        private Optional<OffsetDateTime> completedStartDateTime = Optional.empty();
 
        private Optional<OffsetDateTime> completedEndDateTime = Optional.empty();
 
        private Optional<String> sweepID = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Specify an API version.
         * 
         * <p>API versioning follows the format `vYYYY.QQ.BB`, where 
         *   - `YYYY` is the year
         *   - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
         *   - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter. 
         *     - For example, `v2024.01.00` is the initial release of the first quarter of 2024.
         * 
         * <p>The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
         */
        public Builder xMoovVersion(String xMoovVersion) {
            Utils.checkNotNull(xMoovVersion, "xMoovVersion");
            this.xMoovVersion = Optional.ofNullable(xMoovVersion);
            return this;
        }

        /**
         * Specify an API version.
         * 
         * <p>API versioning follows the format `vYYYY.QQ.BB`, where 
         *   - `YYYY` is the year
         *   - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
         *   - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter. 
         *     - For example, `v2024.01.00` is the initial release of the first quarter of 2024.
         * 
         * <p>The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
         */
        public Builder xMoovVersion(Optional<String> xMoovVersion) {
            Utils.checkNotNull(xMoovVersion, "xMoovVersion");
            this.xMoovVersion = xMoovVersion;
            return this;
        }

        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }

        public Builder skip(long skip) {
            Utils.checkNotNull(skip, "skip");
            this.skip = Optional.ofNullable(skip);
            return this;
        }

        public Builder skip(Optional<Long> skip) {
            Utils.checkNotNull(skip, "skip");
            this.skip = skip;
            return this;
        }

        public Builder count(long count) {
            Utils.checkNotNull(count, "count");
            this.count = Optional.ofNullable(count);
            return this;
        }

        public Builder count(Optional<Long> count) {
            Utils.checkNotNull(count, "count");
            this.count = count;
            return this;
        }

        public Builder walletID(String walletID) {
            Utils.checkNotNull(walletID, "walletID");
            this.walletID = walletID;
            return this;
        }

        /**
         * Optional parameter to filter by transaction type.
         */
        public Builder transactionType(WalletTransactionType transactionType) {
            Utils.checkNotNull(transactionType, "transactionType");
            this.transactionType = Optional.ofNullable(transactionType);
            return this;
        }

        /**
         * Optional parameter to filter by transaction type.
         */
        public Builder transactionType(Optional<? extends WalletTransactionType> transactionType) {
            Utils.checkNotNull(transactionType, "transactionType");
            this.transactionType = transactionType;
            return this;
        }

        /**
         * Optional, comma-separated parameter to filter by transaction types.
         */
        public Builder transactionTypes(List<WalletTransactionType> transactionTypes) {
            Utils.checkNotNull(transactionTypes, "transactionTypes");
            this.transactionTypes = Optional.ofNullable(transactionTypes);
            return this;
        }

        /**
         * Optional, comma-separated parameter to filter by transaction types.
         */
        public Builder transactionTypes(Optional<? extends List<WalletTransactionType>> transactionTypes) {
            Utils.checkNotNull(transactionTypes, "transactionTypes");
            this.transactionTypes = transactionTypes;
            return this;
        }

        /**
         * Optional parameter to filter by source type (i.e. transfer, dispute, issuing-transaction).
         */
        public Builder sourceType(WalletTransactionSourceType sourceType) {
            Utils.checkNotNull(sourceType, "sourceType");
            this.sourceType = Optional.ofNullable(sourceType);
            return this;
        }

        /**
         * Optional parameter to filter by source type (i.e. transfer, dispute, issuing-transaction).
         */
        public Builder sourceType(Optional<? extends WalletTransactionSourceType> sourceType) {
            Utils.checkNotNull(sourceType, "sourceType");
            this.sourceType = sourceType;
            return this;
        }

        /**
         * Optional parameter to filter by source ID.
         */
        public Builder sourceID(String sourceID) {
            Utils.checkNotNull(sourceID, "sourceID");
            this.sourceID = Optional.ofNullable(sourceID);
            return this;
        }

        /**
         * Optional parameter to filter by source ID.
         */
        public Builder sourceID(Optional<String> sourceID) {
            Utils.checkNotNull(sourceID, "sourceID");
            this.sourceID = sourceID;
            return this;
        }

        /**
         * Optional parameter to filter by status (`pending` or `completed`).
         */
        public Builder status(WalletTransactionStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = Optional.ofNullable(status);
            return this;
        }

        /**
         * Optional parameter to filter by status (`pending` or `completed`).
         */
        public Builder status(Optional<? extends WalletTransactionStatus> status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        /**
         * Optional date-time which inclusively filters all transactions created after this date-time.
         */
        public Builder createdStartDateTime(OffsetDateTime createdStartDateTime) {
            Utils.checkNotNull(createdStartDateTime, "createdStartDateTime");
            this.createdStartDateTime = Optional.ofNullable(createdStartDateTime);
            return this;
        }

        /**
         * Optional date-time which inclusively filters all transactions created after this date-time.
         */
        public Builder createdStartDateTime(Optional<OffsetDateTime> createdStartDateTime) {
            Utils.checkNotNull(createdStartDateTime, "createdStartDateTime");
            this.createdStartDateTime = createdStartDateTime;
            return this;
        }

        /**
         * Optional date-time which exclusively filters all transactions created before this date-time.
         */
        public Builder createdEndDateTime(OffsetDateTime createdEndDateTime) {
            Utils.checkNotNull(createdEndDateTime, "createdEndDateTime");
            this.createdEndDateTime = Optional.ofNullable(createdEndDateTime);
            return this;
        }

        /**
         * Optional date-time which exclusively filters all transactions created before this date-time.
         */
        public Builder createdEndDateTime(Optional<OffsetDateTime> createdEndDateTime) {
            Utils.checkNotNull(createdEndDateTime, "createdEndDateTime");
            this.createdEndDateTime = createdEndDateTime;
            return this;
        }

        /**
         * Optional date-time which inclusively filters all transactions completed after this date-time.
         */
        public Builder completedStartDateTime(OffsetDateTime completedStartDateTime) {
            Utils.checkNotNull(completedStartDateTime, "completedStartDateTime");
            this.completedStartDateTime = Optional.ofNullable(completedStartDateTime);
            return this;
        }

        /**
         * Optional date-time which inclusively filters all transactions completed after this date-time.
         */
        public Builder completedStartDateTime(Optional<OffsetDateTime> completedStartDateTime) {
            Utils.checkNotNull(completedStartDateTime, "completedStartDateTime");
            this.completedStartDateTime = completedStartDateTime;
            return this;
        }

        /**
         * Optional date-time which exclusively filters all transactions completed before this date-time.
         */
        public Builder completedEndDateTime(OffsetDateTime completedEndDateTime) {
            Utils.checkNotNull(completedEndDateTime, "completedEndDateTime");
            this.completedEndDateTime = Optional.ofNullable(completedEndDateTime);
            return this;
        }

        /**
         * Optional date-time which exclusively filters all transactions completed before this date-time.
         */
        public Builder completedEndDateTime(Optional<OffsetDateTime> completedEndDateTime) {
            Utils.checkNotNull(completedEndDateTime, "completedEndDateTime");
            this.completedEndDateTime = completedEndDateTime;
            return this;
        }

        /**
         * Optional ID to filter for transactions accrued in a sweep.
         */
        public Builder sweepID(String sweepID) {
            Utils.checkNotNull(sweepID, "sweepID");
            this.sweepID = Optional.ofNullable(sweepID);
            return this;
        }

        /**
         * Optional ID to filter for transactions accrued in a sweep.
         */
        public Builder sweepID(Optional<String> sweepID) {
            Utils.checkNotNull(sweepID, "sweepID");
            this.sweepID = sweepID;
            return this;
        }
        
        public ListWalletTransactionsRequest build() {
            if (xMoovVersion == null) {
                xMoovVersion = _SINGLETON_VALUE_XMoovVersion.value();
            }
            return new ListWalletTransactionsRequest(
                xMoovVersion,
                accountID,
                skip,
                count,
                walletID,
                transactionType,
                transactionTypes,
                sourceType,
                sourceID,
                status,
                createdStartDateTime,
                createdEndDateTime,
                completedStartDateTime,
                completedEndDateTime,
                sweepID);
        }

        private static final LazySingletonValue<Optional<String>> _SINGLETON_VALUE_XMoovVersion =
                new LazySingletonValue<>(
                        "x-moov-version",
                        "\"v2024.01.00\"",
                        new TypeReference<Optional<String>>() {});
    }
}
