/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.core.type.TypeReference;
import io.moov.sdk.models.components.PaymentMethodType;
import io.moov.sdk.utils.LazySingletonValue;
import io.moov.sdk.utils.Utils;
import java.lang.Exception;
import java.lang.String;
import java.util.Optional;

public class ListPaymentMethodsRequestBuilder {

    private Optional<String> xMoovVersion = Utils.readDefaultOrConstValue(
                            "xMoovVersion",
                            "\"v2024.01.00\"",
                            new TypeReference<Optional<String>>() {});
    private String accountID;
    private Optional<String> sourceID = Optional.empty();
    private Optional<? extends PaymentMethodType> paymentMethodType = Optional.empty();
    private final SDKMethodInterfaces.MethodCallListPaymentMethods sdk;

    public ListPaymentMethodsRequestBuilder(SDKMethodInterfaces.MethodCallListPaymentMethods sdk) {
        this.sdk = sdk;
    }
                
    public ListPaymentMethodsRequestBuilder xMoovVersion(String xMoovVersion) {
        Utils.checkNotNull(xMoovVersion, "xMoovVersion");
        this.xMoovVersion = Optional.of(xMoovVersion);
        return this;
    }

    public ListPaymentMethodsRequestBuilder xMoovVersion(Optional<String> xMoovVersion) {
        Utils.checkNotNull(xMoovVersion, "xMoovVersion");
        this.xMoovVersion = xMoovVersion;
        return this;
    }

    public ListPaymentMethodsRequestBuilder accountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }
                
    public ListPaymentMethodsRequestBuilder sourceID(String sourceID) {
        Utils.checkNotNull(sourceID, "sourceID");
        this.sourceID = Optional.of(sourceID);
        return this;
    }

    public ListPaymentMethodsRequestBuilder sourceID(Optional<String> sourceID) {
        Utils.checkNotNull(sourceID, "sourceID");
        this.sourceID = sourceID;
        return this;
    }
                
    public ListPaymentMethodsRequestBuilder paymentMethodType(PaymentMethodType paymentMethodType) {
        Utils.checkNotNull(paymentMethodType, "paymentMethodType");
        this.paymentMethodType = Optional.of(paymentMethodType);
        return this;
    }

    public ListPaymentMethodsRequestBuilder paymentMethodType(Optional<? extends PaymentMethodType> paymentMethodType) {
        Utils.checkNotNull(paymentMethodType, "paymentMethodType");
        this.paymentMethodType = paymentMethodType;
        return this;
    }

    public ListPaymentMethodsResponse call() throws Exception {
        if (xMoovVersion == null) {
            xMoovVersion = _SINGLETON_VALUE_XMoovVersion.value();
        }
        return sdk.list(
            xMoovVersion,
            accountID,
            sourceID,
            paymentMethodType);
    }

    private static final LazySingletonValue<Optional<String>> _SINGLETON_VALUE_XMoovVersion =
            new LazySingletonValue<>(
                    "xMoovVersion",
                    "\"v2024.01.00\"",
                    new TypeReference<Optional<String>>() {});
}
