/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import io.moov.sdk.models.components.PaymentMethodType;
import io.moov.sdk.utils.LazySingletonValue;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import java.util.Optional;

public class ListPaymentMethodsRequest {

    /**
     * Specify an API version.
     * 
     * <p>API versioning follows the format `vYYYY.QQ.BB`, where 
     *   - `YYYY` is the year
     *   - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
     *   - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter. 
     *     - For example, `v2024.01.00` is the initial release of the first quarter of 2024.
     * 
     * <p>The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-moov-version")
    private Optional<String> xMoovVersion;

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;

    /**
     * Optional parameter to filter the account's payment methods by source ID. 
     * 
     * <p>A source ID can be a [walletID](https://docs.moov.io/api/sources/wallets/list/), [cardID](https://docs.moov.io/api/sources/cards/list/), 
     * or [bankAccountID](https://docs.moov.io/api/sources/bank-accounts/list/).
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=sourceID")
    private Optional<String> sourceID;

    /**
     * Optional parameter to filter the account's payment methods by payment method type.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=paymentMethodType")
    private Optional<? extends PaymentMethodType> paymentMethodType;

    @JsonCreator
    public ListPaymentMethodsRequest(
            Optional<String> xMoovVersion,
            String accountID,
            Optional<String> sourceID,
            Optional<? extends PaymentMethodType> paymentMethodType) {
        Utils.checkNotNull(xMoovVersion, "xMoovVersion");
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(sourceID, "sourceID");
        Utils.checkNotNull(paymentMethodType, "paymentMethodType");
        this.xMoovVersion = xMoovVersion;
        this.accountID = accountID;
        this.sourceID = sourceID;
        this.paymentMethodType = paymentMethodType;
    }
    
    public ListPaymentMethodsRequest(
            String accountID) {
        this(Optional.empty(), accountID, Optional.empty(), Optional.empty());
    }

    /**
     * Specify an API version.
     * 
     * <p>API versioning follows the format `vYYYY.QQ.BB`, where 
     *   - `YYYY` is the year
     *   - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
     *   - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter. 
     *     - For example, `v2024.01.00` is the initial release of the first quarter of 2024.
     * 
     * <p>The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
     */
    @JsonIgnore
    public Optional<String> xMoovVersion() {
        return xMoovVersion;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    /**
     * Optional parameter to filter the account's payment methods by source ID. 
     * 
     * <p>A source ID can be a [walletID](https://docs.moov.io/api/sources/wallets/list/), [cardID](https://docs.moov.io/api/sources/cards/list/), 
     * or [bankAccountID](https://docs.moov.io/api/sources/bank-accounts/list/).
     */
    @JsonIgnore
    public Optional<String> sourceID() {
        return sourceID;
    }

    /**
     * Optional parameter to filter the account's payment methods by payment method type.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<PaymentMethodType> paymentMethodType() {
        return (Optional<PaymentMethodType>) paymentMethodType;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * Specify an API version.
     * 
     * <p>API versioning follows the format `vYYYY.QQ.BB`, where 
     *   - `YYYY` is the year
     *   - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
     *   - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter. 
     *     - For example, `v2024.01.00` is the initial release of the first quarter of 2024.
     * 
     * <p>The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
     */
    public ListPaymentMethodsRequest withXMoovVersion(String xMoovVersion) {
        Utils.checkNotNull(xMoovVersion, "xMoovVersion");
        this.xMoovVersion = Optional.ofNullable(xMoovVersion);
        return this;
    }

    /**
     * Specify an API version.
     * 
     * <p>API versioning follows the format `vYYYY.QQ.BB`, where 
     *   - `YYYY` is the year
     *   - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
     *   - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter. 
     *     - For example, `v2024.01.00` is the initial release of the first quarter of 2024.
     * 
     * <p>The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
     */
    public ListPaymentMethodsRequest withXMoovVersion(Optional<String> xMoovVersion) {
        Utils.checkNotNull(xMoovVersion, "xMoovVersion");
        this.xMoovVersion = xMoovVersion;
        return this;
    }

    public ListPaymentMethodsRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    /**
     * Optional parameter to filter the account's payment methods by source ID. 
     * 
     * <p>A source ID can be a [walletID](https://docs.moov.io/api/sources/wallets/list/), [cardID](https://docs.moov.io/api/sources/cards/list/), 
     * or [bankAccountID](https://docs.moov.io/api/sources/bank-accounts/list/).
     */
    public ListPaymentMethodsRequest withSourceID(String sourceID) {
        Utils.checkNotNull(sourceID, "sourceID");
        this.sourceID = Optional.ofNullable(sourceID);
        return this;
    }

    /**
     * Optional parameter to filter the account's payment methods by source ID. 
     * 
     * <p>A source ID can be a [walletID](https://docs.moov.io/api/sources/wallets/list/), [cardID](https://docs.moov.io/api/sources/cards/list/), 
     * or [bankAccountID](https://docs.moov.io/api/sources/bank-accounts/list/).
     */
    public ListPaymentMethodsRequest withSourceID(Optional<String> sourceID) {
        Utils.checkNotNull(sourceID, "sourceID");
        this.sourceID = sourceID;
        return this;
    }

    /**
     * Optional parameter to filter the account's payment methods by payment method type.
     */
    public ListPaymentMethodsRequest withPaymentMethodType(PaymentMethodType paymentMethodType) {
        Utils.checkNotNull(paymentMethodType, "paymentMethodType");
        this.paymentMethodType = Optional.ofNullable(paymentMethodType);
        return this;
    }

    /**
     * Optional parameter to filter the account's payment methods by payment method type.
     */
    public ListPaymentMethodsRequest withPaymentMethodType(Optional<? extends PaymentMethodType> paymentMethodType) {
        Utils.checkNotNull(paymentMethodType, "paymentMethodType");
        this.paymentMethodType = paymentMethodType;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ListPaymentMethodsRequest other = (ListPaymentMethodsRequest) o;
        return 
            Objects.deepEquals(this.xMoovVersion, other.xMoovVersion) &&
            Objects.deepEquals(this.accountID, other.accountID) &&
            Objects.deepEquals(this.sourceID, other.sourceID) &&
            Objects.deepEquals(this.paymentMethodType, other.paymentMethodType);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            xMoovVersion,
            accountID,
            sourceID,
            paymentMethodType);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ListPaymentMethodsRequest.class,
                "xMoovVersion", xMoovVersion,
                "accountID", accountID,
                "sourceID", sourceID,
                "paymentMethodType", paymentMethodType);
    }
    
    public final static class Builder {
 
        private Optional<String> xMoovVersion;
 
        private String accountID;
 
        private Optional<String> sourceID = Optional.empty();
 
        private Optional<? extends PaymentMethodType> paymentMethodType = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Specify an API version.
         * 
         * <p>API versioning follows the format `vYYYY.QQ.BB`, where 
         *   - `YYYY` is the year
         *   - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
         *   - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter. 
         *     - For example, `v2024.01.00` is the initial release of the first quarter of 2024.
         * 
         * <p>The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
         */
        public Builder xMoovVersion(String xMoovVersion) {
            Utils.checkNotNull(xMoovVersion, "xMoovVersion");
            this.xMoovVersion = Optional.ofNullable(xMoovVersion);
            return this;
        }

        /**
         * Specify an API version.
         * 
         * <p>API versioning follows the format `vYYYY.QQ.BB`, where 
         *   - `YYYY` is the year
         *   - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
         *   - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter. 
         *     - For example, `v2024.01.00` is the initial release of the first quarter of 2024.
         * 
         * <p>The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
         */
        public Builder xMoovVersion(Optional<String> xMoovVersion) {
            Utils.checkNotNull(xMoovVersion, "xMoovVersion");
            this.xMoovVersion = xMoovVersion;
            return this;
        }

        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }

        /**
         * Optional parameter to filter the account's payment methods by source ID. 
         * 
         * <p>A source ID can be a [walletID](https://docs.moov.io/api/sources/wallets/list/), [cardID](https://docs.moov.io/api/sources/cards/list/), 
         * or [bankAccountID](https://docs.moov.io/api/sources/bank-accounts/list/).
         */
        public Builder sourceID(String sourceID) {
            Utils.checkNotNull(sourceID, "sourceID");
            this.sourceID = Optional.ofNullable(sourceID);
            return this;
        }

        /**
         * Optional parameter to filter the account's payment methods by source ID. 
         * 
         * <p>A source ID can be a [walletID](https://docs.moov.io/api/sources/wallets/list/), [cardID](https://docs.moov.io/api/sources/cards/list/), 
         * or [bankAccountID](https://docs.moov.io/api/sources/bank-accounts/list/).
         */
        public Builder sourceID(Optional<String> sourceID) {
            Utils.checkNotNull(sourceID, "sourceID");
            this.sourceID = sourceID;
            return this;
        }

        /**
         * Optional parameter to filter the account's payment methods by payment method type.
         */
        public Builder paymentMethodType(PaymentMethodType paymentMethodType) {
            Utils.checkNotNull(paymentMethodType, "paymentMethodType");
            this.paymentMethodType = Optional.ofNullable(paymentMethodType);
            return this;
        }

        /**
         * Optional parameter to filter the account's payment methods by payment method type.
         */
        public Builder paymentMethodType(Optional<? extends PaymentMethodType> paymentMethodType) {
            Utils.checkNotNull(paymentMethodType, "paymentMethodType");
            this.paymentMethodType = paymentMethodType;
            return this;
        }
        
        public ListPaymentMethodsRequest build() {
            if (xMoovVersion == null) {
                xMoovVersion = _SINGLETON_VALUE_XMoovVersion.value();
            }
            return new ListPaymentMethodsRequest(
                xMoovVersion,
                accountID,
                sourceID,
                paymentMethodType);
        }

        private static final LazySingletonValue<Optional<String>> _SINGLETON_VALUE_XMoovVersion =
                new LazySingletonValue<>(
                        "x-moov-version",
                        "\"v2024.01.00\"",
                        new TypeReference<Optional<String>>() {});
    }
}
