/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import io.moov.sdk.models.components.FeePlanAgreementStatus;
import io.moov.sdk.utils.LazySingletonValue;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ListFeePlanAgreementsRequest {

    /**
     * Specify an API version.
     * 
     * <p>API versioning follows the format `vYYYY.QQ.BB`, where 
     *   - `YYYY` is the year
     *   - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
     *   - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter. 
     *     - For example, `v2024.01.00` is the initial release of the first quarter of 2024.
     * 
     * <p>The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-moov-version")
    private Optional<String> xMoovVersion;

    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=skip")
    private Optional<Long> skip;

    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=count")
    private Optional<Long> count;

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;

    /**
     * A comma-separated list of agreement IDs to filter the results by.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=agreementID")
    private Optional<? extends List<String>> agreementID;

    /**
     * A comma-separated list of statuses to filter the results by.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=status")
    private Optional<? extends List<FeePlanAgreementStatus>> status;

    @JsonCreator
    public ListFeePlanAgreementsRequest(
            Optional<String> xMoovVersion,
            Optional<Long> skip,
            Optional<Long> count,
            String accountID,
            Optional<? extends List<String>> agreementID,
            Optional<? extends List<FeePlanAgreementStatus>> status) {
        Utils.checkNotNull(xMoovVersion, "xMoovVersion");
        Utils.checkNotNull(skip, "skip");
        Utils.checkNotNull(count, "count");
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(agreementID, "agreementID");
        Utils.checkNotNull(status, "status");
        this.xMoovVersion = xMoovVersion;
        this.skip = skip;
        this.count = count;
        this.accountID = accountID;
        this.agreementID = agreementID;
        this.status = status;
    }
    
    public ListFeePlanAgreementsRequest(
            String accountID) {
        this(Optional.empty(), Optional.empty(), Optional.empty(), accountID, Optional.empty(), Optional.empty());
    }

    /**
     * Specify an API version.
     * 
     * <p>API versioning follows the format `vYYYY.QQ.BB`, where 
     *   - `YYYY` is the year
     *   - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
     *   - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter. 
     *     - For example, `v2024.01.00` is the initial release of the first quarter of 2024.
     * 
     * <p>The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
     */
    @JsonIgnore
    public Optional<String> xMoovVersion() {
        return xMoovVersion;
    }

    @JsonIgnore
    public Optional<Long> skip() {
        return skip;
    }

    @JsonIgnore
    public Optional<Long> count() {
        return count;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    /**
     * A comma-separated list of agreement IDs to filter the results by.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<List<String>> agreementID() {
        return (Optional<List<String>>) agreementID;
    }

    /**
     * A comma-separated list of statuses to filter the results by.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<List<FeePlanAgreementStatus>> status() {
        return (Optional<List<FeePlanAgreementStatus>>) status;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * Specify an API version.
     * 
     * <p>API versioning follows the format `vYYYY.QQ.BB`, where 
     *   - `YYYY` is the year
     *   - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
     *   - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter. 
     *     - For example, `v2024.01.00` is the initial release of the first quarter of 2024.
     * 
     * <p>The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
     */
    public ListFeePlanAgreementsRequest withXMoovVersion(String xMoovVersion) {
        Utils.checkNotNull(xMoovVersion, "xMoovVersion");
        this.xMoovVersion = Optional.ofNullable(xMoovVersion);
        return this;
    }

    /**
     * Specify an API version.
     * 
     * <p>API versioning follows the format `vYYYY.QQ.BB`, where 
     *   - `YYYY` is the year
     *   - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
     *   - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter. 
     *     - For example, `v2024.01.00` is the initial release of the first quarter of 2024.
     * 
     * <p>The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
     */
    public ListFeePlanAgreementsRequest withXMoovVersion(Optional<String> xMoovVersion) {
        Utils.checkNotNull(xMoovVersion, "xMoovVersion");
        this.xMoovVersion = xMoovVersion;
        return this;
    }

    public ListFeePlanAgreementsRequest withSkip(long skip) {
        Utils.checkNotNull(skip, "skip");
        this.skip = Optional.ofNullable(skip);
        return this;
    }

    public ListFeePlanAgreementsRequest withSkip(Optional<Long> skip) {
        Utils.checkNotNull(skip, "skip");
        this.skip = skip;
        return this;
    }

    public ListFeePlanAgreementsRequest withCount(long count) {
        Utils.checkNotNull(count, "count");
        this.count = Optional.ofNullable(count);
        return this;
    }

    public ListFeePlanAgreementsRequest withCount(Optional<Long> count) {
        Utils.checkNotNull(count, "count");
        this.count = count;
        return this;
    }

    public ListFeePlanAgreementsRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    /**
     * A comma-separated list of agreement IDs to filter the results by.
     */
    public ListFeePlanAgreementsRequest withAgreementID(List<String> agreementID) {
        Utils.checkNotNull(agreementID, "agreementID");
        this.agreementID = Optional.ofNullable(agreementID);
        return this;
    }

    /**
     * A comma-separated list of agreement IDs to filter the results by.
     */
    public ListFeePlanAgreementsRequest withAgreementID(Optional<? extends List<String>> agreementID) {
        Utils.checkNotNull(agreementID, "agreementID");
        this.agreementID = agreementID;
        return this;
    }

    /**
     * A comma-separated list of statuses to filter the results by.
     */
    public ListFeePlanAgreementsRequest withStatus(List<FeePlanAgreementStatus> status) {
        Utils.checkNotNull(status, "status");
        this.status = Optional.ofNullable(status);
        return this;
    }

    /**
     * A comma-separated list of statuses to filter the results by.
     */
    public ListFeePlanAgreementsRequest withStatus(Optional<? extends List<FeePlanAgreementStatus>> status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ListFeePlanAgreementsRequest other = (ListFeePlanAgreementsRequest) o;
        return 
            Objects.deepEquals(this.xMoovVersion, other.xMoovVersion) &&
            Objects.deepEquals(this.skip, other.skip) &&
            Objects.deepEquals(this.count, other.count) &&
            Objects.deepEquals(this.accountID, other.accountID) &&
            Objects.deepEquals(this.agreementID, other.agreementID) &&
            Objects.deepEquals(this.status, other.status);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            xMoovVersion,
            skip,
            count,
            accountID,
            agreementID,
            status);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ListFeePlanAgreementsRequest.class,
                "xMoovVersion", xMoovVersion,
                "skip", skip,
                "count", count,
                "accountID", accountID,
                "agreementID", agreementID,
                "status", status);
    }
    
    public final static class Builder {
 
        private Optional<String> xMoovVersion;
 
        private Optional<Long> skip = Optional.empty();
 
        private Optional<Long> count = Optional.empty();
 
        private String accountID;
 
        private Optional<? extends List<String>> agreementID = Optional.empty();
 
        private Optional<? extends List<FeePlanAgreementStatus>> status = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Specify an API version.
         * 
         * <p>API versioning follows the format `vYYYY.QQ.BB`, where 
         *   - `YYYY` is the year
         *   - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
         *   - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter. 
         *     - For example, `v2024.01.00` is the initial release of the first quarter of 2024.
         * 
         * <p>The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
         */
        public Builder xMoovVersion(String xMoovVersion) {
            Utils.checkNotNull(xMoovVersion, "xMoovVersion");
            this.xMoovVersion = Optional.ofNullable(xMoovVersion);
            return this;
        }

        /**
         * Specify an API version.
         * 
         * <p>API versioning follows the format `vYYYY.QQ.BB`, where 
         *   - `YYYY` is the year
         *   - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
         *   - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter. 
         *     - For example, `v2024.01.00` is the initial release of the first quarter of 2024.
         * 
         * <p>The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
         */
        public Builder xMoovVersion(Optional<String> xMoovVersion) {
            Utils.checkNotNull(xMoovVersion, "xMoovVersion");
            this.xMoovVersion = xMoovVersion;
            return this;
        }

        public Builder skip(long skip) {
            Utils.checkNotNull(skip, "skip");
            this.skip = Optional.ofNullable(skip);
            return this;
        }

        public Builder skip(Optional<Long> skip) {
            Utils.checkNotNull(skip, "skip");
            this.skip = skip;
            return this;
        }

        public Builder count(long count) {
            Utils.checkNotNull(count, "count");
            this.count = Optional.ofNullable(count);
            return this;
        }

        public Builder count(Optional<Long> count) {
            Utils.checkNotNull(count, "count");
            this.count = count;
            return this;
        }

        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }

        /**
         * A comma-separated list of agreement IDs to filter the results by.
         */
        public Builder agreementID(List<String> agreementID) {
            Utils.checkNotNull(agreementID, "agreementID");
            this.agreementID = Optional.ofNullable(agreementID);
            return this;
        }

        /**
         * A comma-separated list of agreement IDs to filter the results by.
         */
        public Builder agreementID(Optional<? extends List<String>> agreementID) {
            Utils.checkNotNull(agreementID, "agreementID");
            this.agreementID = agreementID;
            return this;
        }

        /**
         * A comma-separated list of statuses to filter the results by.
         */
        public Builder status(List<FeePlanAgreementStatus> status) {
            Utils.checkNotNull(status, "status");
            this.status = Optional.ofNullable(status);
            return this;
        }

        /**
         * A comma-separated list of statuses to filter the results by.
         */
        public Builder status(Optional<? extends List<FeePlanAgreementStatus>> status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }
        
        public ListFeePlanAgreementsRequest build() {
            if (xMoovVersion == null) {
                xMoovVersion = _SINGLETON_VALUE_XMoovVersion.value();
            }
            return new ListFeePlanAgreementsRequest(
                xMoovVersion,
                skip,
                count,
                accountID,
                agreementID,
                status);
        }

        private static final LazySingletonValue<Optional<String>> _SINGLETON_VALUE_XMoovVersion =
                new LazySingletonValue<>(
                        "x-moov-version",
                        "\"v2024.01.00\"",
                        new TypeReference<Optional<String>>() {});
    }
}
